/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.jwt.strategy;

import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.plugin.jwt.exception.ThrowingFunction;
import org.apache.shenyu.plugin.jwt.strategy.JwtPayloadParseStrategy;
import org.apache.shenyu.spi.Join;

@Join
public class DefaultJwtPayloadParseStrategy
implements JwtPayloadParseStrategy {
    @Override
    public Map<String, Object> parse(String secretKey, String authorization) {
        JwtParserBuilder jwtParserBuilder = Jwts.parser();
        jwtParserBuilder.verifyWith(Keys.hmacShaKeyFor((byte[])secretKey.getBytes()));
        JwtParser jwtParser = jwtParserBuilder.build();
        if (jwtParser.isSigned((CharSequence)authorization)) {
            Jwt jwt = ThrowingFunction.wrap(() -> jwtParser.parse((CharSequence)authorization));
            return Objects.isNull(jwt) ? null : (Map)jwt.getPayload();
        }
        return null;
    }
}

