/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.cache;

import com.github.pagehelper.PageException;
import com.github.pagehelper.PageProperties;
import com.github.pagehelper.cache.Cache;
import com.github.pagehelper.cache.GuavaCache;
import com.github.pagehelper.cache.SimpleCache;
import com.github.pagehelper.util.StringUtil;
import java.lang.reflect.Constructor;
import java.util.Properties;

public abstract class CacheFactory {
    public static <K, V> Cache<K, V> createCache(String sqlCacheClass, String prefix, Properties properties) {
        if (StringUtil.isEmpty(sqlCacheClass)) {
            try {
                Class.forName("com.google.common.cache.Cache");
                return new GuavaCache(properties, prefix);
            }
            catch (Throwable t) {
                return new SimpleCache(properties, prefix);
            }
        }
        try {
            Class<?> clazz = Class.forName(sqlCacheClass);
            try {
                Constructor<?> constructor = clazz.getConstructor(Properties.class, String.class);
                return (Cache)constructor.newInstance(properties, prefix);
            }
            catch (Exception e) {
                Cache cache = (Cache)clazz.newInstance();
                if (cache instanceof PageProperties) {
                    ((PageProperties)((Object)cache)).setProperties(properties);
                }
                return cache;
            }
        }
        catch (Throwable t) {
            throw new PageException("Created Sql Cache [" + sqlCacheClass + "] Error", t);
        }
    }
}

