/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.infix;

import com.netflix.infix.NumericValuePredicate;
import com.netflix.infix.TimeUtil;
import com.netflix.infix.ValuePredicate;
import javax.annotation.Nullable;
import org.joda.time.format.DateTimeFormatter;

public class TimeMillisValuePredicate
implements ValuePredicate<Long> {
    private String timeFormat;
    private String value;
    private String fnName;
    private NumericValuePredicate longPredicate;

    public TimeMillisValuePredicate(String timeFormat, String value, String fnName) {
        this.timeFormat = timeFormat;
        this.value = value;
        this.fnName = fnName;
        DateTimeFormatter formatter = TimeUtil.toDateTimeFormatter("time format", timeFormat);
        long timeInMs = formatter.parseMillis(value);
        this.longPredicate = new NumericValuePredicate(timeInMs, fnName);
    }

    public boolean apply(@Nullable Long input) {
        return this.longPredicate.apply(input);
    }

    public String getValue() {
        return this.value;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    String getFnName() {
        return this.fnName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TimeMillisValuePredicate [timeFormat=");
        builder.append(this.timeFormat);
        builder.append(", value=");
        builder.append(this.value);
        builder.append(", fnName=");
        builder.append(this.fnName);
        builder.append(", longPredicate=");
        builder.append(this.longPredicate);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fnName == null ? 0 : this.fnName.hashCode());
        result = 31 * result + (this.timeFormat == null ? 0 : this.timeFormat.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeMillisValuePredicate other = (TimeMillisValuePredicate)obj;
        if (this.fnName == null ? other.fnName != null : !this.fnName.equals(other.fnName)) {
            return false;
        }
        if (this.timeFormat == null ? other.timeFormat != null : !this.timeFormat.equals(other.timeFormat)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

