/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(VersionUtils.class);
    private static final String VERSION = VersionUtils.getVersion(VersionUtils.class, "1.0.0");
    private static final String JAR = ".jar";

    private VersionUtils() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getVersion(Class<?> cls, String defaultVersion) {
        String version = cls.getPackage().getImplementationVersion();
        if (StringUtils.isBlank((CharSequence)version)) {
            version = cls.getPackage().getSpecificationVersion();
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{version})) {
            return version;
        }
        CodeSource codeSource = cls.getProtectionDomain().getCodeSource();
        if (Objects.isNull(codeSource)) {
            LOG.info("No codeSource for class {} when getVersion, use default version {}", (Object)cls.getName(), (Object)defaultVersion);
            return defaultVersion;
        }
        String file = codeSource.getLocation().getFile();
        if (Objects.nonNull(file) && file.endsWith(JAR)) {
            int i = (file = file.substring(0, file.length() - 4)).lastIndexOf(47);
            if (i >= 0) {
                file = file.substring(i + 1);
            }
            if ((i = file.indexOf("-")) >= 0) {
                file = file.substring(i + 1);
            }
            while (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{file}) && !Character.isDigit(file.charAt(0)) && (i = file.indexOf("-")) >= 0) {
                file = file.substring(i + 1);
            }
            version = file;
        }
        return StringUtils.isBlank((CharSequence)version) ? defaultVersion : version;
    }

    public static void checkDuplicate(Class<?> cls) {
        try {
            String path = cls.getName().replace('.', '/') + ".class";
            Set<String> files = VersionUtils.readResources(path, cls);
            if (files.size() > 1) {
                String error = "Duplicate class " + path + " in " + files.size() + " jar " + files;
                LOG.error("checkDuplicate error,{}", (Object)error);
            }
        }
        catch (Throwable e) {
            LOG.error("checkDuplicate error,msg :{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static Set<String> readResources(String path, Class<?> cls) throws IOException {
        Enumeration<URL> urls = cls.getClassLoader().getResources(path);
        HashSet<String> files = new HashSet<String>();
        while (urls.hasMoreElements()) {
            String file;
            URL url = urls.nextElement();
            if (!Objects.nonNull(url) || !StringUtils.isNotEmpty((CharSequence)(file = url.getFile()))) continue;
            files.add(file);
        }
        return files;
    }
}

