/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.ratelimit.client.sync;

import com.tencent.polaris.api.plugin.ratelimiter.AmountInfo;
import com.tencent.polaris.api.plugin.ratelimiter.LocalQuotaInfo;
import com.tencent.polaris.api.plugin.ratelimiter.QuotaBucket;
import com.tencent.polaris.api.utils.MapUtils;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.ratelimit.client.flow.AsyncRateLimitConnector;
import com.tencent.polaris.ratelimit.client.flow.InitializeRecord;
import com.tencent.polaris.ratelimit.client.flow.RateLimitWindow;
import com.tencent.polaris.ratelimit.client.flow.ServiceIdentifier;
import com.tencent.polaris.ratelimit.client.flow.StreamCounterSet;
import com.tencent.polaris.ratelimit.client.flow.StreamResource;
import com.tencent.polaris.ratelimit.client.pb.RatelimitV2;
import java.util.Map;
import org.slf4j.Logger;

public class RemoteSyncTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteSyncTask.class);
    private final RateLimitWindow window;
    private final AsyncRateLimitConnector asyncRateLimitConnector;
    private final ServiceIdentifier serviceIdentifier;

    public RemoteSyncTask(RateLimitWindow window) {
        this.window = window;
        this.asyncRateLimitConnector = window.getWindowSet().getAsyncRateLimitConnector();
        this.serviceIdentifier = new ServiceIdentifier(window.getSvcKey().getService(), window.getSvcKey().getNamespace(), window.getLabels());
    }

    public RateLimitWindow getWindow() {
        return this.window;
    }

    @Override
    public void run() {
        LOG.debug("remote sync task:{}", (Object)this.window.getStatus());
        try {
            switch (this.window.getStatus()) {
                case CREATED: 
                case DELETED: {
                    break;
                }
                case INITIALIZING: {
                    this.doRemoteInit();
                    break;
                }
                default: {
                    this.doRemoteAcquire();
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.error("remote sync task:{}", (Object)this.window.getStatus(), (Object)e);
        }
    }

    private boolean isInitExpired(InitializeRecord initializeRecord) {
        if (null == initializeRecord || initializeRecord.getInitStartTimeMilli() == 0L) {
            return true;
        }
        return System.currentTimeMillis() - initializeRecord.getInitStartTimeMilli() >= this.window.getRateLimitConfig().getRemoteSyncTimeoutMilli();
    }

    private void doRemoteInit() {
        RatelimitV2.RateLimitRequest rateLimitInitRequest;
        StreamCounterSet streamCounterSet = this.asyncRateLimitConnector.getStreamCounterSet(this.window.getWindowSet().getRateLimitExtension().getExtensions(), this.window.getRemoteCluster(), this.window.getRemoteAddresses(), this.window.getUniqueKey(), this.serviceIdentifier);
        if (streamCounterSet == null) {
            LOG.error("[doRemoteInit] failed, stream counter is null. remote cluster:{}, remote addresses: {}", (Object)this.window.getRemoteCluster(), (Object)this.window.getRemoteAddresses());
            return;
        }
        StreamResource streamResource = streamCounterSet.checkAndCreateResource(this.serviceIdentifier, this.window);
        this.adjustTime(streamResource);
        InitializeRecord initRecord = streamResource.getInitRecord(this.serviceIdentifier);
        if (null == initRecord) {
            initRecord = streamResource.addInitRecord(this.serviceIdentifier, this.window);
        }
        if (!this.isInitExpired(initRecord)) {
            return;
        }
        LOG.info("[RateLimit] start to init {}, remote server {}", (Object)this.serviceIdentifier, (Object)streamResource.getHostIdentifier());
        initRecord.setInitStartTimeMilli(System.currentTimeMillis());
        RatelimitV2.RateLimitInitRequest.Builder initRequest = RatelimitV2.RateLimitInitRequest.newBuilder();
        initRequest.setClientId(this.window.getWindowSet().getClientId());
        RatelimitV2.LimitTarget.Builder target = RatelimitV2.LimitTarget.newBuilder();
        target.setNamespace(this.window.getSvcKey().getNamespace());
        target.setService(this.window.getSvcKey().getService());
        target.setLabels(this.window.getLabels());
        initRequest.setTarget(target);
        RatelimitV2.QuotaMode quotaMode = RatelimitV2.QuotaMode.forNumber(this.window.getRule().getAmountModeValue());
        QuotaBucket allocatingBucket = this.window.getAllocatingBucket();
        Map<Integer, AmountInfo> amountInfos = allocatingBucket.getAmountInfo();
        if (MapUtils.isNotEmpty(amountInfos)) {
            for (Map.Entry<Integer, AmountInfo> entry : amountInfos.entrySet()) {
                RatelimitV2.QuotaTotal.Builder total = RatelimitV2.QuotaTotal.newBuilder();
                total.setDuration(entry.getKey());
                total.setMode(quotaMode);
                total.setMaxAmount((int)entry.getValue().getMaxAmount());
                initRequest.addTotals(total.build());
            }
        }
        if (!streamResource.sendRateLimitRequest(rateLimitInitRequest = RatelimitV2.RateLimitRequest.newBuilder().setCmd(RatelimitV2.RateLimitCmd.INIT).setRateLimitInitRequest(initRequest).build())) {
            LOG.warn("fail to init token request by {}", (Object)this.window.getUniqueKey());
        }
    }

    private void doRemoteAcquire() {
        StreamCounterSet streamCounterSet = this.asyncRateLimitConnector.getStreamCounterSet(this.window.getWindowSet().getRateLimitExtension().getExtensions(), this.window.getRemoteCluster(), this.window.getRemoteAddresses(), this.window.getUniqueKey(), this.serviceIdentifier);
        if (streamCounterSet == null) {
            LOG.error("[doRemoteAcquire] failed, stream counter is null. remote cluster:{},", (Object)this.window.getRemoteCluster());
            return;
        }
        StreamResource streamResource = streamCounterSet.checkAndCreateResource(this.serviceIdentifier, this.window);
        if (!streamResource.hasInit(this.serviceIdentifier)) {
            LOG.warn("[doRemoteAcquire] has not inited. serviceKey:{}", (Object)this.window.getSvcKey());
            this.doRemoteInit();
            return;
        }
        streamResource.adjustTime();
        RatelimitV2.RateLimitReportRequest.Builder rateLimitReportRequest = RatelimitV2.RateLimitReportRequest.newBuilder();
        rateLimitReportRequest.setClientKey(streamResource.getClientKey());
        long curTimeMilli = System.currentTimeMillis();
        long serverTimeMilli = streamResource.getRemoteTimeMilli(curTimeMilli);
        rateLimitReportRequest.setTimestamp(serverTimeMilli);
        Map<Integer, LocalQuotaInfo> localQuotaInfos = this.window.getAllocatingBucket().fetchLocalUsage(curTimeMilli);
        for (Map.Entry<Integer, LocalQuotaInfo> entry : localQuotaInfos.entrySet()) {
            RatelimitV2.QuotaSum.Builder quotaSum = RatelimitV2.QuotaSum.newBuilder();
            quotaSum.setUsed((int)entry.getValue().getQuotaUsed());
            quotaSum.setLimited((int)entry.getValue().getQuotaLimited());
            Integer counterKey = streamResource.getCounterKey(this.serviceIdentifier, entry.getKey());
            if (null == counterKey) {
                LOG.warn("[doRemoteAcquire] counterKey for {}, duration {} not found", (Object)this.window.getUniqueKey(), (Object)entry.getKey());
                this.doRemoteInit();
                return;
            }
            quotaSum.setCounterKey(counterKey);
            rateLimitReportRequest.addQuotaUses(quotaSum.build());
        }
        RatelimitV2.RateLimitRequest rateLimitRequest = RatelimitV2.RateLimitRequest.newBuilder().setCmd(RatelimitV2.RateLimitCmd.ACQUIRE).setRateLimitReportRequest(rateLimitReportRequest).build();
        if (!streamResource.sendRateLimitRequest(rateLimitRequest)) {
            LOG.warn("fail to acquire token request by {}", (Object)this.window.getUniqueKey());
        }
    }

    private void adjustTime(StreamResource streamResource) {
        streamResource.adjustTime();
    }
}

