/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.composite;

import com.tencent.polaris.api.plugin.circuitbreaker.entity.MethodResource;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.Resource;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.utils.RuleUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.specification.api.v1.fault.tolerance.CircuitBreakerProto;
import com.tencent.polaris.specification.api.v1.model.ModelProto;
import java.util.function.Function;
import java.util.regex.Pattern;

public class MatchUtils {
    public static boolean matchService(ServiceKey serviceKey, String namespace, String service) {
        String inputNamespace = "";
        String inputService = "";
        if (null != serviceKey) {
            inputNamespace = serviceKey.getNamespace();
            inputService = serviceKey.getService();
        }
        if (StringUtils.isNotBlank(namespace) && !StringUtils.equals(namespace, "*") && !StringUtils.equals(inputNamespace, namespace)) {
            return false;
        }
        return !StringUtils.isNotBlank(service) || StringUtils.equals(service, "*") || StringUtils.equals(inputService, service);
    }

    public static boolean matchMethod(Resource resource, ModelProto.MatchString matchString, Function<String, Pattern> regexToPattern) {
        if (resource.getLevel() != CircuitBreakerProto.Level.METHOD) {
            return true;
        }
        String method = ((MethodResource)resource).getMethod();
        return RuleUtils.matchStringValue(matchString, method, regexToPattern);
    }

    public static boolean isWildcardMatcherSingle(String name) {
        return name.equals("*") || StringUtils.isBlank(name);
    }
}

