/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.registry.eureka;

import com.google.gson.JsonObject;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.LeaseInfo;
import com.netflix.appinfo.MyDataCenterInstanceConfig;
import com.netflix.appinfo.RefreshableInstanceConfig;
import com.netflix.appinfo.UniqueIdentifier;
import com.netflix.appinfo.providers.Archaius1VipAddressResolver;
import com.netflix.appinfo.providers.EurekaConfigBasedInstanceInfoProvider;
import com.netflix.appinfo.providers.VipAddressResolver;
import com.netflix.discovery.DefaultEurekaClientConfig;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.transport.jersey.TransportClientFactories;
import com.netflix.discovery.shared.transport.jersey3.Jersey3TransportClientFactories;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.registry.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.registry.api.config.RegisterConfig;
import org.apache.shenyu.registry.api.entity.InstanceEntity;
import org.apache.shenyu.registry.api.event.ChangedEventListener;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join(isSingleton=false)
public class EurekaInstanceRegisterRepository
implements ShenyuInstanceRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(EurekaInstanceRegisterRepository.class);
    private EurekaClient eurekaClient;
    private EurekaClient registerDiscoveryClient;
    private DefaultEurekaClientConfig eurekaClientConfig;
    private EurekaInstanceConfig eurekaInstanceConfig;
    private final ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(10, ShenyuThreadFactory.create((String)"scheduled-eureka-watcher", (boolean)true));
    private final ConcurrentMap<String, ScheduledFuture<?>> listenerThreadsMap = new ConcurrentHashMap();
    private final ConcurrentMap<String, List<InstanceInfo>> instanceListMap = new ConcurrentHashMap<String, List<InstanceInfo>>();

    public void init(final RegisterConfig config) {
        this.eurekaInstanceConfig = new MyDataCenterInstanceConfig();
        this.eurekaClientConfig = new DefaultEurekaClientConfig(){

            public List<String> getEurekaServerServiceUrls(String zone) {
                return Arrays.asList(config.getServerLists().split(","));
            }

            public boolean shouldFetchRegistry() {
                return false;
            }
        };
        DefaultEurekaClientConfig eurekaClientNotRegisterEurekaConfig = new DefaultEurekaClientConfig(){

            public List<String> getEurekaServerServiceUrls(String zone) {
                return Arrays.asList(config.getServerLists().split(","));
            }

            public boolean shouldRegisterWithEureka() {
                return false;
            }
        };
        LOGGER.info("eureka registry init...");
        this.eurekaClient = new DiscoveryClient(new ApplicationInfoManager(this.eurekaInstanceConfig, new EurekaConfigBasedInstanceInfoProvider(this.eurekaInstanceConfig).get()), (EurekaClientConfig)eurekaClientNotRegisterEurekaConfig, (TransportClientFactories)new Jersey3TransportClientFactories());
    }

    public void persistInstance(InstanceEntity instance) {
        InstanceInfo.Builder instanceInfoBuilder = this.instanceInfoBuilder();
        InstanceInfo instanceInfo = instanceInfoBuilder.setAppName(instance.getAppName()).setIPAddr(instance.getHost()).setHostName(instance.getHost()).setPort(instance.getPort().intValue()).setLastDirtyTimestamp(System.currentTimeMillis()).setStatus(InstanceInfo.InstanceStatus.UP).build();
        LeaseInfo.Builder leaseInfoBuilder = LeaseInfo.Builder.newBuilder().setRenewalIntervalInSecs(this.eurekaInstanceConfig.getLeaseRenewalIntervalInSeconds()).setDurationInSecs(this.eurekaInstanceConfig.getLeaseExpirationDurationInSeconds());
        instanceInfo.setLeaseInfo(leaseInfoBuilder.build());
        ApplicationInfoManager applicationInfoManager = new ApplicationInfoManager(this.eurekaInstanceConfig, instanceInfo);
        this.registerDiscoveryClient = new DiscoveryClient(applicationInfoManager, (EurekaClientConfig)this.eurekaClientConfig, (TransportClientFactories)new Jersey3TransportClientFactories());
        LOGGER.info("eureka registry persistInstance success: {}", (Object)instanceInfo);
    }

    public List<InstanceEntity> selectInstances(String selectKey) {
        return this.getInstances(selectKey);
    }

    public boolean serviceExists(String key) {
        try {
            List instances = this.eurekaClient.getInstancesByVipAddressAndAppName(null, key, true);
            return !instances.isEmpty();
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public void watchInstances(String key, ChangedEventListener listener) {
        try {
            List initialInstances = this.eurekaClient.getInstancesByVipAddressAndAppName(null, key, true);
            this.instanceListMap.put(key, initialInstances);
            for (InstanceInfo instance : initialInstances) {
                listener.onEvent(key, this.buildUpstreamJsonFromInstance(instance), ChangedEventListener.Event.ADDED);
            }
            ScheduledFuture<?> scheduledFuture = this.executorService.scheduleAtFixedRate(() -> {
                try {
                    List previousInstances = (List)this.instanceListMap.get(key);
                    List currentInstances = this.eurekaClient.getInstancesByVipAddressAndAppName(null, key, true);
                    this.compareInstances(new HashSet<InstanceInfo>(previousInstances), new HashSet<InstanceInfo>(currentInstances), listener);
                    this.instanceListMap.put(key, currentInstances);
                }
                catch (Exception e) {
                    LOGGER.error("eureka registry eurekaDiscoveryService watch key: {} error", (Object)key, (Object)e);
                    throw new ShenyuException((Throwable)e);
                }
            }, 0L, 1L, TimeUnit.SECONDS);
            this.listenerThreadsMap.put(key, scheduledFuture);
            LOGGER.info("eureka registry subscribed to eureka updates for key: {}", (Object)key);
        }
        catch (Exception e) {
            LOGGER.error("eureka registry error watching key: {}", (Object)key, (Object)e);
            throw new ShenyuException((Throwable)e);
        }
    }

    public void unWatchInstances(String key) {
        try {
            ScheduledFuture scheduledFuture = (ScheduledFuture)this.listenerThreadsMap.get(key);
            if (Objects.nonNull(scheduledFuture)) {
                scheduledFuture.cancel(true);
                this.listenerThreadsMap.remove(key);
                LOGGER.info("eureka registry unwatch key {} successfully", (Object)key);
            }
        }
        catch (Exception e) {
            LOGGER.error("eureka registry error removing eureka watch task for key {} {}", new Object[]{key, e.getMessage(), e});
            throw new ShenyuException((Throwable)e);
        }
    }

    private void compareInstances(Set<InstanceInfo> previousInstances, Set<InstanceInfo> currentInstances, ChangedEventListener listener) {
        Set updatedInstances;
        Set deletedInstances;
        Set addedInstances = currentInstances.stream().filter(item -> !previousInstances.contains(item)).collect(Collectors.toSet());
        if (!addedInstances.isEmpty()) {
            for (Object instance : addedInstances) {
                listener.onEvent(instance.getAppName(), this.buildUpstreamJsonFromInstance((InstanceInfo)instance), ChangedEventListener.Event.ADDED);
            }
        }
        if (!(deletedInstances = previousInstances.stream().filter(item -> !currentInstances.contains(item)).collect(Collectors.toSet())).isEmpty()) {
            for (InstanceInfo instance : deletedInstances) {
                instance.setStatus(InstanceInfo.InstanceStatus.DOWN);
                listener.onEvent(instance.getAppName(), this.buildUpstreamJsonFromInstance(instance), ChangedEventListener.Event.DELETED);
            }
        }
        if (!(updatedInstances = currentInstances.stream().filter(currentInstance -> previousInstances.stream().anyMatch(previousInstance -> currentInstance.getInstanceId().equals(previousInstance.getInstanceId()) && !currentInstance.equals(previousInstance))).collect(Collectors.toSet())).isEmpty()) {
            for (InstanceInfo instance : updatedInstances) {
                listener.onEvent(instance.getAppName(), this.buildUpstreamJsonFromInstance(instance), ChangedEventListener.Event.UPDATED);
            }
        }
    }

    private String buildUpstreamJsonFromInstance(InstanceInfo instanceInfo) {
        JsonObject upstreamJson = new JsonObject();
        upstreamJson.addProperty("url", instanceInfo.getIPAddr() + ":" + instanceInfo.getPort());
        upstreamJson.addProperty("weight", (String)instanceInfo.getMetadata().get("weight"));
        boolean secure = instanceInfo.isPortEnabled(InstanceInfo.PortType.SECURE);
        String scheme = secure ? "https://" : "http://";
        upstreamJson.addProperty("protocol", Optional.ofNullable((String)instanceInfo.getMetadata().get("protocol")).orElse(scheme));
        upstreamJson.addProperty("props", (String)instanceInfo.getMetadata().get("props"));
        if (instanceInfo.getStatus() == InstanceInfo.InstanceStatus.UP) {
            upstreamJson.addProperty("status", (Number)0);
        } else if (instanceInfo.getStatus() == InstanceInfo.InstanceStatus.DOWN) {
            upstreamJson.addProperty("status", (Number)1);
        }
        return GsonUtils.getInstance().toJson((Object)upstreamJson);
    }

    private List<InstanceEntity> getInstances(String selectKey) {
        List instances = this.eurekaClient.getInstancesByVipAddressAndAppName(null, selectKey, true);
        return instances.stream().map(i -> InstanceEntity.builder().appName(i.getAppName()).host(i.getHostName()).port(Integer.valueOf(i.getPort())).uri(this.getURI((InstanceInfo)i)).build()).collect(Collectors.toList());
    }

    private URI getURI(InstanceInfo instance) {
        boolean secure = instance.isPortEnabled(InstanceInfo.PortType.SECURE);
        String scheme = secure ? "https" : "http";
        int port = instance.getPort();
        if (port <= 0) {
            port = secure ? 443 : 80;
        }
        String uri = String.format("%s://%s:%s", scheme, instance.getIPAddr(), port);
        return URI.create(uri);
    }

    public void close() {
        try {
            for (ScheduledFuture scheduledFuture : this.listenerThreadsMap.values()) {
                scheduledFuture.cancel(true);
            }
            this.listenerThreadsMap.clear();
            if (Objects.nonNull(this.eurekaClient)) {
                this.eurekaClient.getApplicationInfoManager().setInstanceStatus(InstanceInfo.InstanceStatus.DOWN);
                this.eurekaClient.shutdown();
            }
            if (Objects.nonNull(this.registerDiscoveryClient)) {
                this.registerDiscoveryClient.getApplicationInfoManager().setInstanceStatus(InstanceInfo.InstanceStatus.DOWN);
                this.registerDiscoveryClient.shutdown();
            }
            LOGGER.info("eureka registry shutting down...");
        }
        catch (Exception e) {
            LOGGER.error("eureka registry shutting down error", (Throwable)e);
            throw new ShenyuException((Throwable)e);
        }
    }

    public InstanceInfo.Builder instanceInfoBuilder() {
        String defaultAddress;
        InstanceInfo.Builder builder = InstanceInfo.Builder.newBuilder((VipAddressResolver)new Archaius1VipAddressResolver());
        String instanceId = this.eurekaInstanceConfig.getInstanceId();
        if (StringUtils.isEmpty((String)instanceId)) {
            DataCenterInfo dataCenterInfo = this.eurekaInstanceConfig.getDataCenterInfo();
            instanceId = dataCenterInfo instanceof UniqueIdentifier ? ((UniqueIdentifier)dataCenterInfo).getId() : this.eurekaInstanceConfig.getHostName(false);
        }
        if (StringUtils.isEmpty((String)(defaultAddress = this.eurekaInstanceConfig instanceof RefreshableInstanceConfig ? ((RefreshableInstanceConfig)this.eurekaInstanceConfig).resolveDefaultAddress(false) : this.eurekaInstanceConfig.getHostName(false)))) {
            defaultAddress = this.eurekaInstanceConfig.getIpAddress();
        }
        builder.setNamespace(this.eurekaInstanceConfig.getNamespace()).setInstanceId(instanceId).setAppName(this.eurekaInstanceConfig.getAppname()).setAppGroupName(this.eurekaInstanceConfig.getAppGroupName()).setDataCenterInfo(this.eurekaInstanceConfig.getDataCenterInfo()).setIPAddr(this.eurekaInstanceConfig.getIpAddress()).setHostName(defaultAddress).setPort(this.eurekaInstanceConfig.getNonSecurePort()).enablePort(InstanceInfo.PortType.UNSECURE, this.eurekaInstanceConfig.isNonSecurePortEnabled()).setSecurePort(this.eurekaInstanceConfig.getSecurePort()).enablePort(InstanceInfo.PortType.SECURE, this.eurekaInstanceConfig.getSecurePortEnabled()).setVIPAddress(this.eurekaInstanceConfig.getVirtualHostName()).setSecureVIPAddress(this.eurekaInstanceConfig.getSecureVirtualHostName()).setHomePageUrl(this.eurekaInstanceConfig.getHomePageUrlPath(), this.eurekaInstanceConfig.getHomePageUrl()).setStatusPageUrl(this.eurekaInstanceConfig.getStatusPageUrlPath(), this.eurekaInstanceConfig.getStatusPageUrl()).setASGName(this.eurekaInstanceConfig.getASGName()).setHealthCheckUrls(this.eurekaInstanceConfig.getHealthCheckUrlPath(), this.eurekaInstanceConfig.getHealthCheckUrl(), this.eurekaInstanceConfig.getSecureHealthCheckUrl());
        if (!this.eurekaInstanceConfig.isInstanceEnabledOnit()) {
            InstanceInfo.InstanceStatus initialStatus = InstanceInfo.InstanceStatus.STARTING;
            LOGGER.info("Setting initial instance status as: {}", (Object)initialStatus);
            builder.setStatus(initialStatus);
        } else {
            LOGGER.info("Setting initial instance status as: {}. This may be too early for the instance to advertise itself as available. You would instead want to control this via a healthcheck handler.", (Object)InstanceInfo.InstanceStatus.UP);
        }
        for (Map.Entry mapEntry : this.eurekaInstanceConfig.getMetadataMap().entrySet()) {
            String key = (String)mapEntry.getKey();
            String value = (String)mapEntry.getValue();
            if (!StringUtils.isNotEmpty((String)value)) continue;
            builder.add(key, value);
        }
        return builder;
    }
}

