/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.configs;

import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.result.ConfigImportResult;
import org.apache.shenyu.admin.service.ProxySelectorService;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportEnum;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportHandler;
import org.apache.shenyu.admin.service.configs.ConfigsImportContext;
import org.apache.shenyu.common.dto.ProxySelectorData;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.springframework.stereotype.Component;

@Component
public class ProxySelectorDataConfigsExportImportHandler
implements ConfigsExportImportHandler {
    private final ProxySelectorService proxySelectorService;

    public ProxySelectorDataConfigsExportImportHandler(ProxySelectorService proxySelectorService) {
        this.proxySelectorService = proxySelectorService;
    }

    @Override
    public ConfigsExportImportEnum configsEnum() {
        return ConfigsExportImportEnum.ProxySelector;
    }

    @Override
    public Optional<String> configsExport(String namespaceId) {
        List<ProxySelectorData> proxySelectorDataList = this.proxySelectorService.listAllByNamespaceId(namespaceId);
        if (CollectionUtils.isNotEmpty(proxySelectorDataList)) {
            proxySelectorDataList.forEach(proxySelectorData -> proxySelectorData.setNamespaceId(null));
            return Optional.of(JsonUtils.toJson(proxySelectorDataList));
        }
        return Optional.empty();
    }

    @Override
    public void configsImport(String namespaceId, String data, ConfigsImportContext context) {
        List proxySelectorList = GsonUtils.getInstance().fromList(data, ProxySelectorData.class);
        ConfigImportResult configImportResult = this.proxySelectorService.importData(namespaceId, proxySelectorList, context);
        context.getResult().put("proxySelectorImportSuccessCount", configImportResult.getSuccessCount());
        if (StringUtils.isNotEmpty((CharSequence)configImportResult.getFailMessage())) {
            context.getResult().put("proxySelectorImportFailMessage", configImportResult.getFailMessage());
        }
    }
}

