/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.configs;

import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.MetaDataDTO;
import org.apache.shenyu.admin.model.result.ConfigImportResult;
import org.apache.shenyu.admin.model.vo.MetaDataVO;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportEnum;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportHandler;
import org.apache.shenyu.admin.service.configs.ConfigsImportContext;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.springframework.stereotype.Component;

@Component
public class MetadataConfigsExportImportHandler
implements ConfigsExportImportHandler {
    private final MetaDataService metaDataService;

    public MetadataConfigsExportImportHandler(MetaDataService metaDataService) {
        this.metaDataService = metaDataService;
    }

    @Override
    public ConfigsExportImportEnum configsEnum() {
        return ConfigsExportImportEnum.Meta;
    }

    @Override
    public Optional<String> configsExport(String namespaceId) {
        List<MetaDataVO> metaDataList = this.metaDataService.listAllDataByNamespaceId(namespaceId);
        if (CollectionUtils.isNotEmpty(metaDataList)) {
            metaDataList.forEach(metaDataVO -> metaDataVO.setNamespaceId(null));
            return Optional.of(JsonUtils.toJson(metaDataList));
        }
        return Optional.empty();
    }

    @Override
    public void configsImport(String namespaceId, String data, ConfigsImportContext context) {
        List metaDataList = GsonUtils.getInstance().fromList(data, MetaDataDTO.class);
        ConfigImportResult configImportResult = this.metaDataService.importData(namespaceId, metaDataList);
        context.getResult().put("metaImportSuccessCount", configImportResult.getSuccessCount());
        if (StringUtils.isNotEmpty((CharSequence)configImportResult.getFailMessage())) {
            context.getResult().put("metaImportFailMessage", configImportResult.getFailMessage());
        }
    }
}

