/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import jakarta.validation.Valid;
import java.util.Optional;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.mapper.ScalePolicyMapper;
import org.apache.shenyu.admin.model.dto.ScalePolicyDTO;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.ScalePolicyVO;
import org.apache.shenyu.admin.service.ScalePolicyService;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@RestApi(value={"/scale/policy"})
public class ScalePolicyController {
    private final ScalePolicyService scalePolicyService;

    public ScalePolicyController(ScalePolicyService scalePolicyService) {
        this.scalePolicyService = scalePolicyService;
    }

    @GetMapping(value={"/getAllPolicies"})
    public ShenyuAdminResult selectAll() {
        return ShenyuAdminResult.success("query success", this.scalePolicyService.selectAll());
    }

    @GetMapping(value={"/{id}"})
    public ShenyuAdminResult detailPolicy(@PathVariable(value="id") @Valid @Existed(provider=ScalePolicyMapper.class, message="scale policy is not existed") @Valid @Existed(provider=ScalePolicyMapper.class, message="scale policy is not existed") String id) {
        ScalePolicyVO scalePolicyVO = this.scalePolicyService.findById(id);
        return Optional.ofNullable(scalePolicyVO).map(item -> ShenyuAdminResult.success("detail success", item)).orElse(ShenyuAdminResult.error("detail failed"));
    }

    @PutMapping
    public ShenyuAdminResult updateScalePolicy(@Valid @RequestBody ScalePolicyDTO scalePolicyDTO) {
        return ShenyuAdminResult.success("update success", this.scalePolicyService.update(scalePolicyDTO));
    }
}

