/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.common.util;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.sink.SaveModePlaceHolder;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.connectors.seatunnel.common.sql.template.SqlTemplate;
import org.apache.seatunnel.connectors.seatunnel.common.util.CreateTableParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CatalogUtil {
    private static final Logger log = LoggerFactory.getLogger(CatalogUtil.class);

    public abstract String columnToConnectorType(Column var1);

    public String getCreateTableSql(String template, String database, String table, TableSchema tableSchema, String optionsKey) {
        String primaryKey = "";
        if (tableSchema.getPrimaryKey() != null) {
            primaryKey = tableSchema.getPrimaryKey().getColumnNames().stream().map(r -> "`" + r + "`").collect(Collectors.joining(","));
        }
        String uniqueKey = "";
        if (!tableSchema.getConstraintKeys().isEmpty()) {
            uniqueKey = tableSchema.getConstraintKeys().stream().flatMap(c -> c.getColumnNames().stream()).map(r -> "`" + r.getColumnName() + "`").collect(Collectors.joining(","));
        }
        SqlTemplate.canHandledByTemplateWithPlaceholder(template, SaveModePlaceHolder.ROWTYPE_PRIMARY_KEY.getPlaceHolder(), primaryKey, TablePath.of((String)database, (String)table).getFullName(), optionsKey);
        template = template.replaceAll(SaveModePlaceHolder.ROWTYPE_PRIMARY_KEY.getReplacePlaceHolder(), primaryKey);
        SqlTemplate.canHandledByTemplateWithPlaceholder(template, SaveModePlaceHolder.ROWTYPE_UNIQUE_KEY.getPlaceHolder(), uniqueKey, TablePath.of((String)database, (String)table).getFullName(), optionsKey);
        template = template.replaceAll(SaveModePlaceHolder.ROWTYPE_UNIQUE_KEY.getReplacePlaceHolder(), uniqueKey);
        Map<String, CreateTableParser.ColumnInfo> columnInTemplate = CreateTableParser.getColumnList(template);
        template = this.mergeColumnInTemplate(columnInTemplate, tableSchema, template);
        String rowTypeFields = tableSchema.getColumns().stream().filter(column -> !columnInTemplate.containsKey(column.getName())).map(x -> this.columnToConnectorType((Column)x)).collect(Collectors.joining(",\n"));
        if (template.contains(SaveModePlaceHolder.TABLE_NAME.getPlaceHolder())) {
            template = template.replaceAll(SaveModePlaceHolder.TABLE_NAME.getReplacePlaceHolder(), table);
            log.warn("The variable placeholder `${table_name}` has been marked as deprecated and will be removed soon, please use `${table}`");
        }
        return template.replaceAll(SaveModePlaceHolder.DATABASE.getReplacePlaceHolder(), database).replaceAll(SaveModePlaceHolder.TABLE.getReplacePlaceHolder(), table).replaceAll(SaveModePlaceHolder.ROWTYPE_FIELDS.getReplacePlaceHolder(), rowTypeFields);
    }

    private String mergeColumnInTemplate(Map<String, CreateTableParser.ColumnInfo> columnInTemplate, TableSchema tableSchema, String template) {
        int offset = 0;
        Map columnMap = tableSchema.getColumns().stream().collect(Collectors.toMap(Column::getName, Function.identity()));
        List columnInfosInSeq = columnInTemplate.values().stream().sorted(Comparator.comparingInt(CreateTableParser.ColumnInfo::getStartIndex)).collect(Collectors.toList());
        for (CreateTableParser.ColumnInfo columnInfo : columnInfosInSeq) {
            String col = columnInfo.getName();
            if (!StringUtils.isEmpty((CharSequence)columnInfo.getInfo())) continue;
            if (columnMap.containsKey(col)) {
                Column column = (Column)columnMap.get(col);
                String newCol = this.columnToConnectorType(column);
                String prefix = template.substring(0, columnInfo.getStartIndex() + offset);
                String suffix = template.substring(offset + columnInfo.getEndIndex());
                if (prefix.endsWith("`")) {
                    prefix = prefix.substring(0, prefix.length() - 1);
                    --offset;
                }
                if (suffix.startsWith("`")) {
                    suffix = suffix.substring(1);
                    --offset;
                }
                template = prefix + newCol + suffix;
                offset += newCol.length() - columnInfo.getName().length();
                continue;
            }
            throw new IllegalArgumentException("Can't find column " + col + " in table.");
        }
        return template;
    }

    public String getDropDatabaseSql(String database, boolean ignoreIfNotExists) {
        if (ignoreIfNotExists) {
            return "DROP DATABASE IF EXISTS `" + database + "`";
        }
        return "DROP DATABASE `" + database + "`";
    }

    public String getCreateDatabaseSql(String database, boolean ignoreIfExists) {
        if (ignoreIfExists) {
            return "CREATE DATABASE IF NOT EXISTS `" + database + "`";
        }
        return "CREATE DATABASE `" + database + "`";
    }

    public String getDropTableSql(TablePath tablePath, boolean ignoreIfNotExists) {
        if (ignoreIfNotExists) {
            return "DROP TABLE IF EXISTS " + tablePath.getFullName();
        }
        return "DROP TABLE " + tablePath.getFullName();
    }

    public String getTruncateTableSql(TablePath tablePath) {
        return "TRUNCATE TABLE " + tablePath.getFullName();
    }
}

