/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class DoubleValue
extends ASTNodeAccessImpl
implements Expression {
    private double value;
    private String stringValue;

    public DoubleValue() {
    }

    public DoubleValue(String value) {
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException("value can neither be null nor empty.");
        }
        String val = value;
        if (val.charAt(0) == '+') {
            val = val.substring(1);
        }
        this.value = Double.parseDouble(val);
        this.stringValue = val;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public String toString() {
        return this.stringValue;
    }

    public DoubleValue withValue(double value) {
        this.setValue(value);
        return this;
    }
}

