/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.keytab;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.kerby.kerberos.kerb.KrbInputStream;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.NameType;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;

public class KeytabInputStream
extends KrbInputStream {
    public KeytabInputStream(InputStream in) {
        super(in);
    }

    @Override
    public KerberosTime readTime() throws IOException {
        long value = this.readInt();
        KerberosTime time = new KerberosTime(value * 1000L);
        return time;
    }

    @Override
    public PrincipalName readPrincipal(int version) throws IOException {
        int numComponents = this.readShort();
        if (version == 1281) {
            --numComponents;
        }
        String realm = this.readCountedString();
        ArrayList<String> nameStrings = new ArrayList<String>();
        for (int i = 0; i < numComponents; ++i) {
            String component = this.readCountedString();
            nameStrings.add(component);
        }
        int type = this.readInt();
        NameType nameType = NameType.fromValue(type);
        PrincipalName principal = new PrincipalName(nameStrings, nameType);
        principal.setRealm(realm);
        return principal;
    }

    @Override
    public int readOctetsCount() throws IOException {
        return this.readShort();
    }
}

