/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions;

import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IParameterDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.royale.compiler.internal.definitions.VariableDefinition;
import org.apache.royale.compiler.internal.scopes.CatchScope;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.tree.as.IParameterNode;

public class ParameterDefinition
extends VariableDefinition
implements IParameterDefinition {
    public ParameterDefinition(String name) {
        super(name);
    }

    @Override
    public boolean isRest() {
        return (this.flags & 0x80) != 0;
    }

    public void setRest() {
        this.flags = (short)(this.flags | 0x80);
        IReference arrayTypeReference = ReferenceFactory.builtinReference(IASLanguageConstants.BuiltinType.ARRAY);
        this.setTypeReference(arrayTypeReference);
    }

    @Override
    public boolean hasDefaultValue() {
        return (this.flags & 0x200) != 0;
    }

    public void setHasDefault() {
        this.flags = (short)(this.flags | 0x200);
    }

    public void setDefaultValue(Object value) {
        this.initValue = value;
        this.flags = (short)(this.flags | 0x200);
    }

    @Override
    public TypeDefinitionBase resolveType(ICompilerProject project) {
        ITypeDefinition typeDef;
        IParameterNode paramNode;
        if (project.getInferTypes() && this.getTypeReference() == null && (paramNode = this.getNode()) != null && (typeDef = SemanticUtils.resolveVariableInferredType(paramNode, project)) != null) {
            this.setTypeReference(ReferenceFactory.resolvedReference(typeDef));
            return (TypeDefinitionBase)typeDef;
        }
        return super.resolveType(project);
    }

    @Override
    public Object resolveDefaultValue(ICompilerProject project) {
        if (this.hasDefaultValue()) {
            return this.resolveInitialValue(project);
        }
        return null;
    }

    @Override
    protected DependencyType getTypeDependencyType() {
        return DependencyType.SIGNATURE;
    }

    @Override
    public IParameterNode getNode() {
        return (IParameterNode)super.getNode();
    }

    @Override
    public boolean matches(DefinitionBase node) {
        boolean matches = super.matches(node);
        if (!matches) {
            return false;
        }
        return node.getNameStart() == this.getNameStart() && node.getNameEnd() == this.getNameEnd();
    }

    @Override
    public void buildInnerString(StringBuilder sb) {
        sb.append(this.getBaseName());
        String type = this.getTypeAsDisplayString();
        if (!type.isEmpty()) {
            sb.append(':');
            sb.append(type);
        }
    }

    @Override
    public final IVariableDefinition.VariableClassification getVariableClassification() {
        IASScope containingScope = this.getContainingScope();
        if (containingScope instanceof CatchScope) {
            return IVariableDefinition.VariableClassification.LOCAL;
        }
        return IVariableDefinition.VariableClassification.PARAMETER;
    }
}

