/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.util.Objects;
import java.util.Optional;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.util.JavaUtils;

public final class RaftStorageMetadata {
    private static final RaftStorageMetadata DEFAULT = RaftStorageMetadata.valueOf(RaftProtos.TermIndexProto.getDefaultInstance().getTerm(), RaftPeerId.valueOf(""));
    private final long term;
    private final RaftPeerId votedFor;

    public static RaftStorageMetadata getDefault() {
        return DEFAULT;
    }

    public static RaftStorageMetadata valueOf(long term, RaftPeerId votedFor) {
        return new RaftStorageMetadata(term, votedFor);
    }

    private RaftStorageMetadata(long term, RaftPeerId votedFor) {
        this.term = term;
        this.votedFor = Optional.ofNullable(votedFor).orElseGet(() -> RaftStorageMetadata.getDefault().getVotedFor());
    }

    public long getTerm() {
        return this.term;
    }

    public RaftPeerId getVotedFor() {
        return this.votedFor;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RaftStorageMetadata that = (RaftStorageMetadata)obj;
        return this.term == that.term && Objects.equals(this.votedFor, that.votedFor);
    }

    public int hashCode() {
        return Objects.hash(this.term, this.votedFor);
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + "{term=" + this.term + ", votedFor=" + this.votedFor + '}';
    }
}

