/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.search.suggest.phrase.CandidateGenerator;
import org.elasticsearch.search.suggest.phrase.DirectCandidateGenerator;

public final class MultiCandidateGeneratorWrapper
extends CandidateGenerator {
    private final CandidateGenerator[] candidateGenerator;
    private int numCandidates;

    public MultiCandidateGeneratorWrapper(int numCandidates, CandidateGenerator ... candidateGenerators) {
        this.candidateGenerator = candidateGenerators;
        this.numCandidates = numCandidates;
    }

    @Override
    public boolean isKnownWord(BytesRef term) throws IOException {
        return this.candidateGenerator[0].isKnownWord(term);
    }

    @Override
    public TermStats termStats(BytesRef term) throws IOException {
        return this.candidateGenerator[0].termStats(term);
    }

    @Override
    public DirectCandidateGenerator.CandidateSet drawCandidates(DirectCandidateGenerator.CandidateSet set) throws IOException {
        for (CandidateGenerator generator : this.candidateGenerator) {
            generator.drawCandidates(set);
        }
        return this.reduce(set, this.numCandidates);
    }

    private DirectCandidateGenerator.CandidateSet reduce(DirectCandidateGenerator.CandidateSet set, int numCandidates) {
        if (set.candidates.length > numCandidates) {
            DirectCandidateGenerator.Candidate[] candidates = set.candidates;
            Arrays.sort(candidates, (left, right) -> Double.compare(right.score, left.score));
            DirectCandidateGenerator.Candidate[] newSet = new DirectCandidateGenerator.Candidate[numCandidates];
            System.arraycopy(candidates, 0, newSet, 0, numCandidates);
            set.candidates = newSet;
        }
        return set;
    }

    @Override
    public DirectCandidateGenerator.Candidate createCandidate(BytesRef term, TermStats termStats, double channelScore, boolean userInput) throws IOException {
        return this.candidateGenerator[0].createCandidate(term, termStats, channelScore, userInput);
    }
}

