/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.kafka.authorizer;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerKafkaAuthorizer
implements Authorizer {
    private static final Logger logger = LoggerFactory.getLogger(RangerKafkaAuthorizer.class);
    private static final String RANGER_PLUGIN_TYPE = "kafka";
    private static final String RANGER_KAFKA_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.kafka.authorizer.RangerKafkaAuthorizer";
    private Authorizer rangerKafkaAuthorizerImpl = null;
    private RangerPluginClassLoader rangerPluginClassLoader = null;

    public RangerKafkaAuthorizer() {
        logger.debug("==> RangerKafkaAuthorizer.RangerKafkaAuthorizer()");
        this.init();
        logger.debug("<== RangerKafkaAuthorizer.RangerKafkaAuthorizer()");
    }

    private static String toString(AuthorizableRequestContext requestContext) {
        return requestContext == null ? null : String.format("AuthorizableRequestContext{principal=%s, clientAddress=%s, clientId=%s}", requestContext.principal(), requestContext.clientAddress(), requestContext.clientId());
    }

    private void init() {
        logger.debug("==> RangerKafkaAuthorizer.init()");
        try {
            this.rangerPluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(RANGER_KAFKA_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.rangerPluginClassLoader);
            this.activatePluginClassLoader();
            this.rangerKafkaAuthorizerImpl = (Authorizer)cls.newInstance();
        }
        catch (Exception e) {
            logger.error("Error Enabling RangerKafkaPlugin", (Throwable)e);
            throw new IllegalStateException("Error Enabling RangerKafkaPlugin", e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        logger.debug("<== RangerKafkaAuthorizer.init()");
    }

    public void configure(Map<String, ?> configs) {
        logger.debug("==> RangerKafkaAuthorizer.configure(Map<String, ?>)");
        try {
            this.activatePluginClassLoader();
            this.rangerKafkaAuthorizerImpl.configure(configs);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        logger.debug("<== RangerKafkaAuthorizer.configure(Map<String, ?>)");
    }

    public Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo authorizerServerInfo) {
        logger.debug("==> RangerKafkaAuthorizer.start(AuthorizerServerInfo)");
        try {
            this.activatePluginClassLoader();
            Map map = this.rangerKafkaAuthorizerImpl.start(authorizerServerInfo);
            return map;
        }
        finally {
            this.deactivatePluginClassLoader();
            logger.debug("<== RangerKafkaAuthorizer.start(AuthorizerServerInfo)");
        }
    }

    public void close() throws IOException {
        logger.debug("==> RangerKafkaAuthorizer.close()");
        try {
            this.activatePluginClassLoader();
            this.rangerKafkaAuthorizerImpl.close();
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        logger.debug("<== RangerKafkaAuthorizer.close()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
        List ret;
        logger.debug("==> RangerKafkaAuthorizer.authorize(AuthorizableRequestContext={}, List<Action>={})", (Object)RangerKafkaAuthorizer.toString(requestContext), actions);
        try {
            this.activatePluginClassLoader();
            ret = this.rangerKafkaAuthorizerImpl.authorize(requestContext, actions);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        logger.debug("<== RangerKafkaAuthorizer.authorize: {}", (Object)ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
        logger.debug("==> RangerKafkaAuthorizer.createAcls(AuthorizableRequestContext, List<AclBinding>)");
        try {
            this.activatePluginClassLoader();
            List list = this.rangerKafkaAuthorizerImpl.createAcls(requestContext, aclBindings);
            return list;
        }
        finally {
            this.deactivatePluginClassLoader();
            logger.debug("<== RangerKafkaAuthorizer.createAcls(AuthorizableRequestContext, List<AclBinding>)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters) {
        logger.debug("==> RangerKafkaAuthorizer.deleteAcls(AuthorizableRequestContext, List<AclBindingFilter>)");
        try {
            this.activatePluginClassLoader();
            List list = this.rangerKafkaAuthorizerImpl.deleteAcls(requestContext, aclBindingFilters);
            return list;
        }
        finally {
            this.deactivatePluginClassLoader();
            logger.debug("<== RangerKafkaAuthorizer.deleteAcls(AuthorizableRequestContext, List<AclBindingFilter>)");
        }
    }

    public Iterable<AclBinding> acls(AclBindingFilter filter) {
        logger.debug("==> RangerKafkaAuthorizer.acls(AclBindingFilter)");
        try {
            this.activatePluginClassLoader();
            Iterable iterable = this.rangerKafkaAuthorizerImpl.acls(filter);
            return iterable;
        }
        finally {
            this.deactivatePluginClassLoader();
            logger.debug("<== RangerKafkaAuthorizer.acls(AclBindingFilter)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext requestContext, AclOperation op, ResourceType resourceType) {
        AuthorizationResult ret;
        if (logger.isDebugEnabled()) {
            logger.debug("==> RangerKafkaAuthorizer.authorizeByResourceType(AuthorizableRequestContext={}, AclOperation={}, ResourceType={})", new Object[]{RangerKafkaAuthorizer.toString(requestContext), op, resourceType});
        }
        try {
            this.activatePluginClassLoader();
            ret = this.rangerKafkaAuthorizerImpl.authorizeByResourceType(requestContext, op, resourceType);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== RangerKafkaAuthorizer.authorizeByResourceType: {}", (Object)ret);
        }
        return ret;
    }

    private void activatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.deactivate();
        }
    }
}

