/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;

public class RestGetAliasesAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_alias"), new RestHandler.Route(RestRequest.Method.GET, "/_aliases"), new RestHandler.Route(RestRequest.Method.GET, "/_alias/{name}"), new RestHandler.Route(RestRequest.Method.HEAD, "/_alias/{name}"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_alias"), new RestHandler.Route(RestRequest.Method.HEAD, "/{index}/_alias"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_alias/{name}"), new RestHandler.Route(RestRequest.Method.HEAD, "/{index}/_alias/{name}")));
    }

    @Override
    public String getName() {
        return "get_aliases_action";
    }

    static RestResponse buildRestResponse(boolean aliasesExplicitlyRequested, String[] requestedAliases, ImmutableOpenMap<String, List<AliasMetadata>> responseAliasMap, XContentBuilder builder) throws Exception {
        RestStatus status;
        int n;
        int i;
        HashSet<String> indicesToDisplay = new HashSet<String>();
        HashSet<String> returnedAliasNames = new HashSet<String>();
        for (ObjectObjectCursor<String, List<AliasMetadata>> objectObjectCursor : responseAliasMap) {
            for (AliasMetadata aliasMetadata : (List)objectObjectCursor.value) {
                if (aliasesExplicitlyRequested) {
                    indicesToDisplay.add((String)objectObjectCursor.key);
                }
                returnedAliasNames.add(aliasMetadata.alias());
            }
        }
        TreeSet<String> missingAliases = new TreeSet<String>();
        int n2 = requestedAliases.length;
        for (i = 0; i < requestedAliases.length; ++i) {
            if (!Regex.isSimpleMatchPattern(requestedAliases[i])) continue;
            n = i;
            break;
        }
        for (i = 0; i < requestedAliases.length; ++i) {
            int j;
            if ("_all".equals(requestedAliases[i]) || Regex.isSimpleMatchPattern(requestedAliases[i]) || i > n && requestedAliases[i].charAt(0) == '-') continue;
            for (j = Math.max(i + 1, n); j < requestedAliases.length && (requestedAliases[j].charAt(0) != '-' || !Regex.simpleMatch(requestedAliases[j].substring(1), requestedAliases[i]) && !"_all".equals(requestedAliases[j].substring(1))); ++j) {
            }
            if (j != requestedAliases.length || returnedAliasNames.contains(requestedAliases[i])) continue;
            missingAliases.add(requestedAliases[i]);
        }
        builder.startObject();
        if (missingAliases.isEmpty()) {
            status = RestStatus.OK;
        } else {
            status = RestStatus.NOT_FOUND;
            String message = missingAliases.size() == 1 ? String.format(Locale.ROOT, "alias [%s] missing", Strings.collectionToCommaDelimitedString(missingAliases)) : String.format(Locale.ROOT, "aliases [%s] missing", Strings.collectionToCommaDelimitedString(missingAliases));
            builder.field("error", message);
            builder.field("status", status.getStatus());
        }
        for (ObjectObjectCursor<String, List<AliasMetadata>> objectObjectCursor : responseAliasMap) {
            if (aliasesExplicitlyRequested && (!aliasesExplicitlyRequested || !indicesToDisplay.contains(objectObjectCursor.key))) continue;
            builder.startObject((String)objectObjectCursor.key);
            builder.startObject("aliases");
            for (AliasMetadata alias : (List)objectObjectCursor.value) {
                AliasMetadata.Builder.toXContent(alias, builder, ToXContent.EMPTY_PARAMS);
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return new BytesRestResponse(status, builder);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        final boolean namesProvided = request.hasParam("name");
        final String[] aliases = request.paramAsStringArrayOrEmptyIfAll("name");
        GetAliasesRequest getAliasesRequest = new GetAliasesRequest(aliases);
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        getAliasesRequest.indices(indices);
        getAliasesRequest.indicesOptions(IndicesOptions.fromRequest(request, getAliasesRequest.indicesOptions()));
        getAliasesRequest.local(request.paramAsBoolean("local", getAliasesRequest.local()));
        return channel -> client.admin().indices().getAliases(getAliasesRequest, (ActionListener<GetAliasesResponse>)new RestBuilderListener<GetAliasesResponse>(channel){

            @Override
            public RestResponse buildResponse(GetAliasesResponse response, XContentBuilder builder) throws Exception {
                return RestGetAliasesAction.buildRestResponse(namesProvided, aliases, response.getAliases(), builder);
            }
        });
    }
}

