/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint;

import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class SimpleTxnMap<T extends Txn> {
    private final int cacheMask;
    private final Txn[] arrayMap;
    private int arrayMapSize = 0;
    private final HashMap<Long, T> backupMap = new HashMap();

    public SimpleTxnMap(int arrayMapSize) {
        if (Integer.bitCount(arrayMapSize) != 1) {
            throw new IllegalArgumentException("argument:" + arrayMapSize + " must be a power of two");
        }
        this.arrayMap = new Txn[arrayMapSize];
        this.cacheMask = arrayMapSize - 1;
    }

    public synchronized void put(T txn) {
        assert (this.get(((Locker)txn).getId()) == null);
        long txnId = ((Locker)txn).getId();
        int i = (int)((Locker)txn).getId() & this.cacheMask;
        Txn cachedTxn = this.arrayMap[i];
        if (cachedTxn == null) {
            this.arrayMap[i] = txn;
            ++this.arrayMapSize;
            return;
        }
        this.backupMap.put(txnId, txn);
    }

    public synchronized T get(long txnId) {
        Txn cachedTxn = this.arrayMap[(int)txnId & this.cacheMask];
        if (cachedTxn != null && cachedTxn.getId() == txnId) {
            assert (!this.backupMap.containsKey(txnId));
            return (T)cachedTxn;
        }
        return (T)((Txn)this.backupMap.get(txnId));
    }

    public synchronized T remove(long txnId) {
        int i = (int)txnId & this.cacheMask;
        Txn cachedTxn = this.arrayMap[i];
        if (cachedTxn != null && cachedTxn.getId() == txnId) {
            this.arrayMap[i] = null;
            --this.arrayMapSize;
            assert (!this.backupMap.containsKey(txnId));
            return (T)cachedTxn;
        }
        return (T)((Txn)this.backupMap.remove(txnId));
    }

    public synchronized int size() {
        return this.backupMap.size() + this.arrayMapSize;
    }

    public synchronized boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void clear() {
        this.backupMap.clear();
        Arrays.fill(this.arrayMap, null);
        this.arrayMapSize = 0;
    }

    public synchronized Map<Long, T> getMap() {
        HashMap<Long, T> map = new HashMap<Long, T>(this.backupMap);
        for (Txn element : this.arrayMap) {
            Txn txn = element;
            if (txn == null) continue;
            Txn old = map.put(txn.getId(), txn);
            assert (old == null);
        }
        return map;
    }

    public HashMap<Long, T> getBackupMap() {
        return this.backupMap;
    }
}

