/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.util.ArrayList;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_10.FrameSizeObserver;
import org.apache.qpid.server.protocol.v0_10.ServerAssembler;
import org.apache.qpid.server.protocol.v0_10.ServerFrame;
import org.apache.qpid.server.protocol.v0_10.transport.ProtocolError;
import org.apache.qpid.server.protocol.v0_10.transport.ProtocolHeader;
import org.apache.qpid.server.protocol.v0_10.transport.SegmentType;
import org.apache.qpid.server.transport.util.Functions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInputHandler
implements FrameSizeObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerInputHandler.class);
    private static final QpidByteBuffer EMPTY_BYTE_BUFFER = QpidByteBuffer.allocateDirect((int)0);
    private int _maxFrameSize = 4096;
    private final ServerAssembler _serverAssembler;
    private State _state = State.PROTO_HDR;
    private byte flags;
    private SegmentType type;
    private byte track;
    private int channel;

    public ServerInputHandler(ServerAssembler serverAssembler) {
        this._serverAssembler = serverAssembler;
        this._state = State.PROTO_HDR;
    }

    @Override
    public void setMaxFrameSize(int maxFrameSize) {
        this._maxFrameSize = maxFrameSize;
    }

    private void error(String fmt, Object ... args) {
        this._serverAssembler.error(new ProtocolError(0, fmt, args));
    }

    public void received(QpidByteBuffer buf) {
        int position = buf.position();
        ArrayList<ServerFrame> frames = new ArrayList<ServerFrame>();
        while (buf.hasRemaining() && this._state != State.ERROR) {
            int newPosition;
            buf.mark();
            switch (this._state) {
                case PROTO_HDR: {
                    if (buf.remaining() < 8) break;
                    if (buf.get() != 65 || buf.get() != 77 || buf.get() != 81 || buf.get() != 80) {
                        buf.reset();
                        this.error("bad protocol header: %s", Functions.str((QpidByteBuffer)buf));
                        this._state = State.ERROR;
                        break;
                    }
                    byte protoClass = buf.get();
                    byte instance = buf.get();
                    byte major = buf.get();
                    byte minor = buf.get();
                    this._serverAssembler.init(new ProtocolHeader(protoClass, instance, major, minor));
                    this._state = State.FRAME_HDR;
                    break;
                }
                case FRAME_HDR: {
                    if (buf.remaining() < 12) {
                        buf.reset();
                        break;
                    }
                    this.flags = buf.get();
                    this.type = SegmentType.get(buf.get());
                    int size = 0xFFFF & buf.getShort();
                    if ((size -= 12) < 0 || size > this._maxFrameSize - 12) {
                        this.error("bad frame size: %d", size);
                        this._state = State.ERROR;
                        break;
                    }
                    buf.get();
                    byte b = buf.get();
                    if ((b & 0xF0) != 0) {
                        this.error("non-zero reserved bits in upper nibble of frame header byte 5: '%x'", b);
                        this._state = State.ERROR;
                        break;
                    }
                    this.track = (byte)(b & 0xF);
                    this.channel = 0xFFFF & buf.getShort();
                    buf.position(buf.position() + 4);
                    if (size == 0) {
                        ServerFrame frame = new ServerFrame(this.flags, this.type, this.track, this.channel, EMPTY_BYTE_BUFFER.duplicate());
                        frames.add(frame);
                        break;
                    }
                    if (buf.remaining() < size) {
                        buf.reset();
                        break;
                    }
                    QpidByteBuffer body = buf.slice();
                    body.limit(size);
                    ServerFrame frame = new ServerFrame(this.flags, this.type, this.track, this.channel, body);
                    frames.add(frame);
                    buf.position(buf.position() + size);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (position == (newPosition = buf.position())) break;
            position = newPosition;
        }
        this._serverAssembler.received(frames);
    }

    public void exception(Throwable t) {
        this._serverAssembler.exception(t);
    }

    public void closed() {
        this._serverAssembler.closed();
    }

    public static enum State {
        PROTO_HDR,
        FRAME_HDR,
        ERROR;

    }
}

