/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.nio.charset.Charset;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.commons.Internal;
import opennlp.tools.formats.LanguageSampleStreamFactory;
import opennlp.tools.formats.ad.ADNameSampleStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;

@Internal
public class ADNameSampleStreamFactory
extends LanguageSampleStreamFactory<NameSample, Parameters> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, "ad", new ADNameSampleStreamFactory(Parameters.class));
    }

    protected ADNameSampleStreamFactory(Class<Parameters> params) {
        super(params);
    }

    @Override
    public ObjectStream<NameSample> create(String[] args) {
        Parameters params = this.validateBasicFormatParameters(args, Parameters.class);
        this.language = params.getLang();
        ObjectStream<String> lineStream = this.readData(args, Parameters.class);
        return new ADNameSampleStream(lineStream, params.getSplitHyphenatedTokens());
    }

    public static interface Parameters
    extends BasicFormatParams {
        @Override
        @ArgumentParser.ParameterDescription(valueName="charsetName", description="encoding for reading and writing text, if absent the system default is used.")
        public Charset getEncoding();

        @ArgumentParser.ParameterDescription(valueName="split", description="if true all hyphenated tokens will be separated (default true)")
        @ArgumentParser.OptionalParameter(defaultValue="true")
        public Boolean getSplitHyphenatedTokens();

        @ArgumentParser.ParameterDescription(valueName="language", description="language which is being processed.")
        public String getLang();
    }
}

