# ##############################################################################
# cmake/savedefconfig.cmake
#
# SPDX-License-Identifier: Apache-2.0
#
# Licensed to the Apache Software Foundation (ASF) under one or more contributor
# license agreements.  See the NOTICE file distributed with this work for
# additional information regarding copyright ownership.  The ASF licenses this
# file to you under the Apache License, Version 2.0 (the "License"); you may not
# use this file except in compliance with the License.  You may obtain a copy of
# the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
# License for the specific language governing permissions and limitations under
# the License.
#
# ##############################################################################

include(cmake/nuttx_kconfig.cmake)

set(SOURCE_FILE ${CMAKE_ARGV3})
set(TARGET_FILE ${CMAKE_ARGV4})

file(STRINGS ${SOURCE_FILE} ConfigContents)
encode_brackets(ConfigContents)

foreach(NameAndValue ${ConfigContents})
  decode_brackets(NameAndValue)
  encode_semicolon(NameAndValue)
  if("${NameAndValue}" MATCHES "CONFIG_ARCH="
     OR "${NameAndValue}" MATCHES "^CONFIG_ARCH_CHIP_"
     OR "${NameAndValue}" MATCHES "CONFIG_ARCH_CHIP="
     OR "${NameAndValue}" MATCHES "CONFIG_ARCH_BOARD="
     OR "${NameAndValue}" MATCHES "^CONFIG_ARCH_CUSTOM"
     OR "${NameAndValue}" MATCHES "^CONFIG_ARCH_BOARD_CUSTOM")
    decode_semicolon(Value)
    file(APPEND ${TARGET_FILE} "${NameAndValue}\n")
  endif()
endforeach()

get_filename_component(BINARY_DIR "${TARGET_FILE}" DIRECTORY)

set(OUTPUT_FILE ${BINARY_DIR}/defconfig)

# cmake-format: off
file(WRITE ${OUTPUT_FILE} "")
file(APPEND ${OUTPUT_FILE} "\#\n")
file(APPEND ${OUTPUT_FILE} "\# This file is autogenerated: PLEASE DO NOT EDIT IT.\n")
file(APPEND ${OUTPUT_FILE} "\#\n")
file(APPEND ${OUTPUT_FILE} "\# You can use \"make menuconfig\" to make any modifications to the installed .config file.\n")
file(APPEND ${OUTPUT_FILE} "\# You can then do \"make savedefconfig\" to generate a new defconfig file that includes your\n")
file(APPEND ${OUTPUT_FILE} "\# modifications.\n")
file(APPEND ${OUTPUT_FILE} "\#\n")
file(READ ${TARGET_FILE} CONTENTS)
# cmake-format: on
encode_brackets(CONTENTS)
encode_semicolon(CONTENTS)

string(REGEX MATCHALL "[^\n]+" LINES ${CONTENTS})

list(REMOVE_DUPLICATES LINES)
list(SORT LINES)

foreach(LINE IN LISTS LINES)
  decode_brackets(LINE)
  decode_semicolon(LINE)
  file(APPEND ${OUTPUT_FILE} "${LINE}\n")
endforeach()

execute_process(COMMAND ${CMAKE_COMMAND} -E remove ${TARGET_FILE})
