/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.index;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import v14.h2.engine.Session;
import v14.h2.index.Cursor;
import v14.h2.message.DbException;
import v14.h2.result.Row;
import v14.h2.result.SearchRow;
import v14.h2.table.Column;
import v14.h2.table.TableLink;
import v14.h2.value.DataType;
import v14.h2.value.Value;

public class LinkedCursor
implements Cursor {
    private final TableLink tableLink;
    private final PreparedStatement prep;
    private final String sql;
    private final Session session;
    private final ResultSet rs;
    private Row current;

    LinkedCursor(TableLink tableLink, ResultSet resultSet, Session session, String string, PreparedStatement preparedStatement) {
        this.session = session;
        this.tableLink = tableLink;
        this.rs = resultSet;
        this.sql = string;
        this.prep = preparedStatement;
    }

    @Override
    public Row get() {
        return this.current;
    }

    @Override
    public SearchRow getSearchRow() {
        return this.current;
    }

    @Override
    public boolean next() {
        int n;
        try {
            n = this.rs.next();
            if (n == 0) {
                this.rs.close();
                this.tableLink.reusePreparedStatement(this.prep, this.sql);
                this.current = null;
                return false;
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
        this.current = this.tableLink.getTemplateRow();
        for (n = 0; n < this.current.getColumnCount(); ++n) {
            Column column = this.tableLink.getColumn(n);
            Value value = DataType.readValue(this.session, this.rs, n + 1, column.getType().getValueType());
            this.current.setValue(n, value);
        }
        return true;
    }

    @Override
    public boolean previous() {
        throw DbException.throwInternalError(this.toString());
    }
}

