/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.crypto.EnvKryptKt;
import jetbrains.exodus.crypto.StreamCipher;
import jetbrains.exodus.crypto.StreamCipherInputStream;
import jetbrains.exodus.crypto.StreamCipherInputStreamKt;
import jetbrains.exodus.crypto.StreamCipherOutputStream;
import jetbrains.exodus.crypto.StreamCipherProvider;
import jetbrains.exodus.entitystore.BlobVault;
import jetbrains.exodus.entitystore.BlobVaultItem;
import jetbrains.exodus.entitystore.DiskBasedBlobVault;
import jetbrains.exodus.entitystore.FileSystemBlobVaultOld;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016J:\u0010\u0012\u001a\u00020\r2\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\r\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0018\u0010#\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u0010H\u0016J\u001a\u0010%\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010&\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010'\u001a\u00020\u0004H\u0016J\u0015\u0010(\u001a\u00070)\u00a2\u0006\u0002\b\u001e2\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0010\u0010*\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010+\u001a\u00020\u0010H\u0016J\b\u0010,\u001a\u00020\nH\u0016J\u0016\u0010-\u001a\u00020.2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010/\u001a\u000200R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Ljetbrains/exodus/crypto/EncryptedBlobVault;", "Ljetbrains/exodus/entitystore/BlobVault;", "Ljetbrains/exodus/entitystore/DiskBasedBlobVault;", "decorated", "Ljetbrains/exodus/entitystore/FileSystemBlobVaultOld;", "cipherProvider", "Ljetbrains/exodus/crypto/StreamCipherProvider;", "cipherKey", "", "cipherBasicIV", "", "(Ljetbrains/exodus/entitystore/FileSystemBlobVaultOld;Ljetbrains/exodus/crypto/StreamCipherProvider;[BJ)V", "clear", "", "close", "delete", "", "blobHandle", "flushBlobs", "blobStreams", "Ljetbrains/exodus/core/dataStructures/hash/LongHashMap;", "Ljava/io/InputStream;", "blobFiles", "Ljava/io/File;", "deferredBlobsToDelete", "Ljetbrains/exodus/core/dataStructures/hash/LongSet;", "txn", "Ljetbrains/exodus/env/Transaction;", "getBackupStrategy", "Ljetbrains/exodus/backup/BackupStrategy;", "Lorg/jetbrains/annotations/NotNull;", "getBlob", "Ljetbrains/exodus/entitystore/BlobVaultItem;", "getBlobKey", "", "getBlobLocation", "readonly", "getContent", "getSize", "getSourceVault", "newCipher", "Ljetbrains/exodus/crypto/StreamCipher;", "nextHandle", "requiresTxn", "size", "wrapOutputStream", "Ljetbrains/exodus/crypto/StreamCipherOutputStream;", "output", "Ljava/io/OutputStream;", "xodus-entity-store"})
public final class EncryptedBlobVault
extends BlobVault
implements DiskBasedBlobVault {
    @NotNull
    private final FileSystemBlobVaultOld decorated;
    @NotNull
    private final StreamCipherProvider cipherProvider;
    @NotNull
    private final byte[] cipherKey;
    private final long cipherBasicIV;

    public EncryptedBlobVault(@NotNull FileSystemBlobVaultOld decorated, @NotNull StreamCipherProvider cipherProvider, @NotNull byte[] cipherKey, long cipherBasicIV) {
        Intrinsics.checkNotNullParameter((Object)((Object)decorated), (String)"decorated");
        Intrinsics.checkNotNullParameter((Object)cipherProvider, (String)"cipherProvider");
        Intrinsics.checkNotNullParameter((Object)cipherKey, (String)"cipherKey");
        super((BlobVault)decorated);
        this.decorated = decorated;
        this.cipherProvider = cipherProvider;
        this.cipherKey = cipherKey;
        this.cipherBasicIV = cipherBasicIV;
    }

    @NotNull
    public FileSystemBlobVaultOld getSourceVault() {
        return this.decorated;
    }

    public void clear() {
        this.decorated.clear();
    }

    @NotNull
    public BackupStrategy getBackupStrategy() {
        BackupStrategy backupStrategy = this.decorated.getBackupStrategy();
        Intrinsics.checkNotNullExpressionValue((Object)backupStrategy, (String)"decorated.backupStrategy");
        return backupStrategy;
    }

    @NotNull
    public BlobVaultItem getBlob(long blobHandle) {
        BlobVaultItem blobVaultItem = this.decorated.getBlob(blobHandle);
        Intrinsics.checkNotNullExpressionValue((Object)blobVaultItem, (String)"decorated.getBlob(blobHandle)");
        return blobVaultItem;
    }

    @Nullable
    public InputStream getContent(long blobHandle, @NotNull Transaction txn) {
        StreamCipherInputStream streamCipherInputStream;
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        InputStream inputStream = this.decorated.getContent(blobHandle, txn);
        if (inputStream == null) {
            streamCipherInputStream = null;
        } else {
            InputStream $this$getContent_u24lambda_u2d0 = inputStream;
            boolean bl = false;
            streamCipherInputStream = new StreamCipherInputStream($this$getContent_u24lambda_u2d0, (Function0)new Function0<StreamCipher>(this, blobHandle){
                final /* synthetic */ EncryptedBlobVault this$0;
                final /* synthetic */ long $blobHandle;
                {
                    this.this$0 = $receiver;
                    this.$blobHandle = $blobHandle;
                    super(0);
                }

                @NotNull
                public final StreamCipher invoke() {
                    return EncryptedBlobVault.access$newCipher(this.this$0, this.$blobHandle);
                }
            });
        }
        return (InputStream)streamCipherInputStream;
    }

    public boolean delete(long blobHandle) {
        return this.decorated.delete(blobHandle);
    }

    @NotNull
    public File getBlobLocation(long blobHandle) {
        File file = this.decorated.getBlobLocation(blobHandle);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"decorated.getBlobLocation(blobHandle)");
        return file;
    }

    @NotNull
    public File getBlobLocation(long blobHandle, boolean readonly) {
        File file = this.decorated.getBlobLocation(blobHandle, readonly);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"decorated.getBlobLocation(blobHandle, readonly)");
        return file;
    }

    @NotNull
    public String getBlobKey(long blobHandle) {
        String string = this.decorated.getBlobKey(blobHandle);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decorated.getBlobKey(blobHandle)");
        return string;
    }

    public long getSize(long blobHandle, @NotNull Transaction txn) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        return this.decorated.getSize(blobHandle, txn);
    }

    public boolean requiresTxn() {
        return this.decorated.requiresTxn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void flushBlobs(@Nullable LongHashMap<InputStream> blobStreams, @Nullable LongHashMap<File> blobFiles, @Nullable LongSet deferredBlobsToDelete, @NotNull Transaction txn) {
        Object object;
        Map.Entry it;
        boolean $i$f$forEach;
        Map $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        LongHashMap streams = new LongHashMap(0, 0.0f, 3, null);
        LongHashMap<InputStream> longHashMap = blobStreams;
        if (longHashMap != null) {
            $this$forEach$iv = (Map)longHashMap;
            $i$f$forEach = false;
            for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
                it = element$iv;
                boolean bl = false;
                Map map = (Map)streams;
                Object k = it.getKey();
                object = it.getValue();
                Intrinsics.checkNotNullExpressionValue(object, (String)"it.value");
                map.put(k, new StreamCipherInputStream((InputStream)object, (Function0)new Function0<StreamCipher>(this, it){
                    final /* synthetic */ EncryptedBlobVault this$0;
                    final /* synthetic */ Map.Entry<Long, InputStream> $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(0);
                    }

                    @NotNull
                    public final StreamCipher invoke() {
                        Long l = this.$it.getKey();
                        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"it.key");
                        return EncryptedBlobVault.access$newCipher(this.this$0, ((Number)l).longValue());
                    }
                }));
            }
        }
        List openFiles = null;
        try {
            if (blobFiles != null && !((Map)blobFiles).isEmpty()) {
                openFiles = new ArrayList();
                $this$forEach$iv = (Map)blobFiles;
                $i$f$forEach = false;
                for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
                    void $this$flushBlobs_u24lambda_u2d4_u24lambda_u2d3;
                    Object it2;
                    it = element$iv;
                    boolean bl = false;
                    Object object2 = object = new FileInputStream((File)it.getValue());
                    Object k = it.getKey();
                    Map map = (Map)streams;
                    boolean bl2 = false;
                    openFiles.add(it2);
                    Unit unit = Unit.INSTANCE;
                    it2 = object = StreamCipherInputStreamKt.getAsBuffered((InputStream)((InputStream)object));
                    boolean bl3 = false;
                    $this$flushBlobs_u24lambda_u2d4_u24lambda_u2d3.mark(Integer.MAX_VALUE);
                    unit = Unit.INSTANCE;
                    Function0 function0 = (Function0)new Function0<StreamCipher>(this, it){
                        final /* synthetic */ EncryptedBlobVault this$0;
                        final /* synthetic */ Map.Entry<Long, File> $it;
                        {
                            this.this$0 = $receiver;
                            this.$it = $it;
                            super(0);
                        }

                        @NotNull
                        public final StreamCipher invoke() {
                            Long l = this.$it.getKey();
                            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"it.key");
                            return EncryptedBlobVault.access$newCipher(this.this$0, ((Number)l).longValue());
                        }
                    };
                    Object object3 = object;
                    map.put(k, new StreamCipherInputStream(object3, function0));
                }
            }
            this.decorated.flushBlobs((LongHashMap<InputStream>)streams, null, deferredBlobsToDelete, txn);
        }
        finally {
            List list = openFiles;
            if (list != null) {
                Iterable $this$forEach$iv2 = list;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    InputStream it3 = (InputStream)element$iv;
                    boolean bl = false;
                    it3.close();
                }
            }
        }
    }

    public long size() {
        return this.decorated.size();
    }

    public long nextHandle(@NotNull Transaction txn) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        return this.decorated.nextHandle(txn);
    }

    public void close() {
        this.decorated.close();
    }

    @NotNull
    public final StreamCipherOutputStream wrapOutputStream(long blobHandle, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return new StreamCipherOutputStream(output, this.newCipher(blobHandle));
    }

    private final StreamCipher newCipher(long blobHandle) {
        StreamCipher streamCipher;
        StreamCipher $this$newCipher_u24lambda_u2d6 = streamCipher = this.cipherProvider.newCipher();
        boolean bl = false;
        $this$newCipher_u24lambda_u2d6.init(this.cipherKey, EnvKryptKt.asHashedIV((long)(this.cipherBasicIV - blobHandle)));
        StreamCipher streamCipher2 = streamCipher;
        Intrinsics.checkNotNullExpressionValue((Object)streamCipher2, (String)"cipherProvider.newCipher\u2026obHandle).asHashedIV()) }");
        return streamCipher2;
    }

    public static final /* synthetic */ StreamCipher access$newCipher(EncryptedBlobVault $this, long blobHandle) {
        return $this.newCipher(blobHandle);
    }
}

