/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization.user;

import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserDetails;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public final class NiFiUserUtils {
    public static NiFiUser getNiFiUser() {
        Object principal;
        NiFiUser user = null;
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        if (authentication != null && (principal = authentication.getPrincipal()) instanceof NiFiUserDetails) {
            user = ((NiFiUserDetails)principal).getNiFiUser();
        }
        return user;
    }

    public static String getNiFiUserIdentity() {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user == null) {
            return "unknown";
        }
        return user.getIdentity();
    }

    public static List<String> buildProxiedEntitiesChain(NiFiUser user) {
        ArrayList<String> proxyChain = new ArrayList<String>();
        for (NiFiUser chainedUser = user; chainedUser != null; chainedUser = chainedUser.getChain()) {
            if (chainedUser.isAnonymous()) {
                proxyChain.add("");
                continue;
            }
            proxyChain.add(chainedUser.getIdentity());
        }
        return proxyChain;
    }
}

