/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.lt;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.constants.CharConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class LtCharFunctionFactory
implements FunctionFactory {
    private static final char CHAR_NULL = CharConstant.ZERO.getChar(null);

    @Override
    public String getSignature() {
        return "<(AA)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new LtCharFunction(args.getQuick(0), args.getQuick(1));
    }

    private static class LtCharFunction
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final Function left;
        private final Function right;

        public LtCharFunction(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean getBool(Record rec) {
            char left = this.left.getChar(rec);
            char right = this.right.getChar(rec);
            if (left == CHAR_NULL || right == CHAR_NULL) {
                return false;
            }
            return this.negated == left >= right;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.left);
            if (this.negated) {
                sink.val(">=");
            } else {
                sink.val('<');
            }
            sink.val(this.right);
        }
    }
}

