/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.std.Misc;
import org.jetbrains.annotations.Nullable;

public class SymbolColumn
extends SymbolFunction
implements ScalarFunction {
    private final int columnIndex;
    private final boolean symbolTableStatic;
    private boolean ownSymbolTable;
    private SymbolTable symbolTable;
    private SymbolTableSource symbolTableSource;

    public SymbolColumn(int columnIndex, boolean symbolTableStatic) {
        this.columnIndex = columnIndex;
        this.symbolTableStatic = symbolTableStatic;
    }

    @Override
    public void close() {
        if (this.ownSymbolTable) {
            this.symbolTable = Misc.freeIfCloseable(this.symbolTable);
        }
    }

    @Override
    public int getInt(Record rec) {
        return rec.getInt(this.columnIndex);
    }

    @Override
    @Nullable
    public StaticSymbolTable getStaticSymbolTable() {
        if (this.symbolTable instanceof StaticSymbolTable) {
            return (StaticSymbolTable)this.symbolTable;
        }
        if (this.symbolTable instanceof SymbolFunction) {
            return ((SymbolFunction)this.symbolTable).getStaticSymbolTable();
        }
        return null;
    }

    @Override
    public CharSequence getSymbol(Record rec) {
        return this.symbolTable.valueOf(rec.getInt(this.columnIndex));
    }

    @Override
    public CharSequence getSymbolB(Record rec) {
        return this.symbolTable.valueBOf(rec.getInt(this.columnIndex));
    }

    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        this.symbolTableSource = symbolTableSource;
        if (executionContext.getCloneSymbolTables()) {
            if (this.symbolTable != null) {
                assert (this.ownSymbolTable);
                this.symbolTable = Misc.freeIfCloseable(this.symbolTable);
            }
            this.symbolTable = symbolTableSource.newSymbolTable(this.columnIndex);
            this.ownSymbolTable = true;
        } else {
            this.symbolTable = symbolTableSource.getSymbolTable(this.columnIndex);
        }
        assert (!this.symbolTableStatic || this.getStaticSymbolTable() != null);
    }

    @Override
    public boolean isReadThreadSafe() {
        return false;
    }

    @Override
    public boolean isSymbolTableStatic() {
        return this.symbolTableStatic;
    }

    @Override
    @Nullable
    public SymbolTable newSymbolTable() {
        return this.symbolTableSource.newSymbolTable(this.columnIndex);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.putColumnName(this.columnIndex);
    }

    @Override
    public CharSequence valueBOf(int symbolKey) {
        return this.symbolTable.valueBOf(symbolKey);
    }

    @Override
    public CharSequence valueOf(int symbolKey) {
        return this.symbolTable.valueOf(symbolKey);
    }
}

