/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToStrFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

public class CastFloatToStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Fs)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function intFunc = args.getQuick(0);
        if (intFunc.isConstant()) {
            StringSink sink = Misc.getThreadLocalBuilder();
            sink.put(intFunc.getFloat(null), configuration.getFloatToStrCastScale());
            return new StrConstant(Chars.toString(sink));
        }
        return new CastFloatToStrFunction(args.getQuick(0), configuration.getFloatToStrCastScale());
    }

    public static class CastFloatToStrFunction
    extends AbstractCastToStrFunction {
        private final int scale;
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();

        public CastFloatToStrFunction(Function arg, int scale) {
            super(arg);
            this.scale = scale;
        }

        @Override
        public CharSequence getStr(Record rec) {
            float value = this.arg.getFloat(rec);
            if (Float.isNaN(value)) {
                return null;
            }
            this.sinkA.clear();
            this.sinkA.put(value, 4);
            return this.sinkA;
        }

        @Override
        public void getStr(Record rec, CharSink sink) {
            float value = this.arg.getFloat(rec);
            if (Float.isNaN(value)) {
                return;
            }
            sink.put(value, this.scale);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            float value = this.arg.getFloat(rec);
            if (Float.isNaN(value)) {
                return null;
            }
            this.sinkB.clear();
            this.sinkB.put(value, 4);
            return this.sinkB;
        }
    }
}

