/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.map.FastMapValue;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.std.BinarySequence;
import io.questdb.std.DirectBinarySequence;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FastMapRecord
implements MapRecord {
    private final DirectBinarySequence[] bs;
    private final DirectCharSequence[] csA;
    private final DirectCharSequence[] csB;
    private final Long256Impl[] keyLong256A;
    private final Long256Impl[] keyLong256B;
    private final int keyOffset;
    private final ColumnTypes keyTypes;
    private final int split;
    private final FastMapValue value;
    private final int[] valueOffsets;
    private long keyAddress;
    private int lastKeyIndex = -1;
    private int lastKeyOffset = -1;
    private long limit;
    private IntList symbolTableIndex;
    private RecordCursor symbolTableResolver;
    private long valueAddress;

    FastMapRecord(@Nullable int[] valueOffsets, int keyOffset, FastMapValue value, @NotNull ColumnTypes keyTypes, @Nullable ColumnTypes valueTypes) {
        int i;
        int nColumns;
        int keyIndexOffset;
        this.valueOffsets = valueOffsets;
        this.keyOffset = keyOffset;
        this.value = value;
        this.value.linkRecord(this);
        int n = this.split = valueOffsets != null ? valueOffsets.length : 0;
        if (valueTypes != null) {
            keyIndexOffset = valueTypes.getColumnCount();
            nColumns = keyTypes.getColumnCount() + valueTypes.getColumnCount();
        } else {
            keyIndexOffset = 0;
            nColumns = keyTypes.getColumnCount();
        }
        DirectCharSequence[] csA = null;
        DirectCharSequence[] csB = null;
        DirectBinarySequence[] bs = null;
        Long256Impl[] long256A = null;
        Long256Impl[] long256B = null;
        ArrayColumnTypes keyTypesCopy = new ArrayColumnTypes();
        int n2 = keyTypes.getColumnCount();
        block5: for (i = 0; i < n2; ++i) {
            int columnType = keyTypes.getColumnType(i);
            keyTypesCopy.add(columnType);
            switch (ColumnType.tagOf(columnType)) {
                case 11: {
                    if (csA == null) {
                        csA = new DirectCharSequence[nColumns];
                        csB = new DirectCharSequence[nColumns];
                    }
                    csA[i + keyIndexOffset] = new DirectCharSequence();
                    csB[i + keyIndexOffset] = new DirectCharSequence();
                    continue block5;
                }
                case 18: {
                    if (bs == null) {
                        bs = new DirectBinarySequence[nColumns];
                    }
                    bs[i + keyIndexOffset] = new DirectBinarySequence();
                    continue block5;
                }
                case 13: {
                    if (long256A == null) {
                        long256A = new Long256Impl[nColumns];
                        long256B = new Long256Impl[nColumns];
                    }
                    long256A[i + keyIndexOffset] = new Long256Impl();
                    long256B[i + keyIndexOffset] = new Long256Impl();
                    continue block5;
                }
            }
        }
        this.keyTypes = keyTypesCopy;
        if (valueTypes != null) {
            n2 = valueTypes.getColumnCount();
            for (i = 0; i < n2; ++i) {
                if (ColumnType.tagOf(valueTypes.getColumnType(i)) != 13) continue;
                if (long256A == null) {
                    long256A = new Long256Impl[nColumns];
                    long256B = new Long256Impl[nColumns];
                }
                long256A[i] = new Long256Impl();
                long256B[i] = new Long256Impl();
            }
        }
        this.csA = csA;
        this.csB = csB;
        this.bs = bs;
        this.keyLong256A = long256A;
        this.keyLong256B = long256B;
    }

    private FastMapRecord(int[] valueOffsets, ColumnTypes keyTypes, int split, int keyOffset, DirectCharSequence[] csA, DirectCharSequence[] csB, DirectBinarySequence[] bs, Long256Impl[] keyLong256A, Long256Impl[] keyLong256B) {
        this.valueOffsets = valueOffsets;
        this.keyTypes = keyTypes;
        this.split = split;
        this.keyOffset = keyOffset;
        this.value = new FastMapValue(valueOffsets);
        this.csA = csA;
        this.csB = csB;
        this.bs = bs;
        this.keyLong256A = keyLong256A;
        this.keyLong256B = keyLong256B;
    }

    @Override
    public BinarySequence getBin(int columnIndex) {
        long address = this.addressOfColumn(columnIndex);
        int len = Unsafe.getUnsafe().getInt(address);
        if (len == -1) {
            return null;
        }
        DirectBinarySequence bs = this.bs[columnIndex];
        bs.of(address + 4L, len);
        return bs;
    }

    @Override
    public long getBinLen(int columnIndex) {
        return Unsafe.getUnsafe().getInt(this.addressOfColumn(columnIndex));
    }

    @Override
    public boolean getBool(int columnIndex) {
        return Unsafe.getBool(this.addressOfColumn(columnIndex));
    }

    @Override
    public byte getByte(int columnIndex) {
        return Unsafe.getUnsafe().getByte(this.addressOfColumn(columnIndex));
    }

    @Override
    public char getChar(int columnIndex) {
        return Unsafe.getUnsafe().getChar(this.addressOfColumn(columnIndex));
    }

    @Override
    public double getDouble(int columnIndex) {
        return Unsafe.getUnsafe().getDouble(this.addressOfColumn(columnIndex));
    }

    @Override
    public float getFloat(int columnIndex) {
        return Unsafe.getUnsafe().getFloat(this.addressOfColumn(columnIndex));
    }

    @Override
    public byte getGeoByte(int col) {
        return this.getByte(col);
    }

    @Override
    public int getGeoInt(int col) {
        return this.getInt(col);
    }

    @Override
    public long getGeoLong(int col) {
        return this.getLong(col);
    }

    @Override
    public short getGeoShort(int col) {
        return this.getShort(col);
    }

    @Override
    public int getInt(int columnIndex) {
        return Unsafe.getUnsafe().getInt(this.addressOfColumn(columnIndex));
    }

    @Override
    public long getLong(int columnIndex) {
        return Unsafe.getUnsafe().getLong(this.addressOfColumn(columnIndex));
    }

    @Override
    public long getLong128Hi(int columnIndex) {
        return Unsafe.getUnsafe().getLong(this.addressOfColumn(columnIndex) + 8L);
    }

    @Override
    public long getLong128Lo(int columnIndex) {
        return Unsafe.getUnsafe().getLong(this.addressOfColumn(columnIndex));
    }

    @Override
    public void getLong256(int columnIndex, CharSink sink) {
        long address = this.addressOfColumn(columnIndex);
        long a = Unsafe.getUnsafe().getLong(address);
        long b = Unsafe.getUnsafe().getLong(address + 8L);
        long c = Unsafe.getUnsafe().getLong(address + 16L);
        long d = Unsafe.getUnsafe().getLong(address + 24L);
        Numbers.appendLong256(a, b, c, d, sink);
    }

    @Override
    public Long256 getLong256A(int columnIndex) {
        return this.getLong256Generic(this.keyLong256A, columnIndex);
    }

    @Override
    public Long256 getLong256B(int columnIndex) {
        return this.getLong256Generic(this.keyLong256B, columnIndex);
    }

    @Override
    public long getRowId() {
        return this.valueAddress;
    }

    @Override
    public short getShort(int columnIndex) {
        return Unsafe.getUnsafe().getShort(this.addressOfColumn(columnIndex));
    }

    @Override
    public CharSequence getStr(int columnIndex) {
        return this.getStr0(columnIndex, this.csA[columnIndex]);
    }

    @Override
    public void getStr(int columnIndex, CharSink sink) {
        long address = this.addressOfColumn(columnIndex);
        int len = Unsafe.getUnsafe().getInt(address);
        address += 4L;
        for (int i = 0; i < len; ++i) {
            sink.put(Unsafe.getUnsafe().getChar(address));
            address += 2L;
        }
    }

    @Override
    public CharSequence getStrB(int columnIndex) {
        return this.getStr0(columnIndex, this.csB[columnIndex]);
    }

    @Override
    public int getStrLen(int columnIndex) {
        return Unsafe.getUnsafe().getInt(this.addressOfColumn(columnIndex));
    }

    @Override
    public CharSequence getSym(int col) {
        return this.symbolTableResolver.getSymbolTable(this.symbolTableIndex.getQuick(col)).valueOf(this.getInt(col));
    }

    @Override
    public CharSequence getSymB(int col) {
        return this.symbolTableResolver.getSymbolTable(this.symbolTableIndex.getQuick(col)).valueBOf(this.getInt(col));
    }

    @Override
    public MapValue getValue() {
        return this.value.of(this.valueAddress, this.limit, false);
    }

    @Override
    public void setSymbolTableResolver(RecordCursor resolver, IntList symbolTableIndex) {
        this.symbolTableResolver = resolver;
        this.symbolTableIndex = symbolTableIndex;
    }

    private long addressOfColumn(int index) {
        if (index < this.split) {
            return this.valueAddress + (long)this.valueOffsets[index];
        }
        if (index == this.split) {
            return this.keyAddress;
        }
        return this.addressOfKeyColumn(index - this.split);
    }

    private long addressOfKeyColumn(int index) {
        long addr = this.keyAddress;
        int i = 0;
        if (this.lastKeyIndex > -1 && index >= this.lastKeyIndex) {
            addr += (long)this.lastKeyOffset;
            i = this.lastKeyIndex;
        }
        while (i < index) {
            int columnType = this.keyTypes.getColumnType(i);
            int size = ColumnType.sizeOf(columnType);
            if (size > 0) {
                addr += (long)size;
            } else {
                int len = Unsafe.getUnsafe().getInt(addr);
                addr += 4L;
                if (len != -1) {
                    addr = ColumnType.isString(columnType) ? (addr += (long)len << 1) : (addr += (long)len);
                }
            }
            ++i;
        }
        this.lastKeyOffset = (int)(addr - this.keyAddress);
        this.lastKeyIndex = i;
        return addr;
    }

    @NotNull
    private Long256 getLong256Generic(Long256Impl[] keyLong256, int columnIndex) {
        long address = this.addressOfColumn(columnIndex);
        Long256Impl long256 = keyLong256[columnIndex];
        long256.setAll(Unsafe.getUnsafe().getLong(address), Unsafe.getUnsafe().getLong(address + 8L), Unsafe.getUnsafe().getLong(address + 16L), Unsafe.getUnsafe().getLong(address + 24L));
        return long256;
    }

    private CharSequence getStr0(int index, DirectCharSequence cs) {
        long address = this.addressOfColumn(index);
        int len = Unsafe.getUnsafe().getInt(address);
        return len == -1 ? null : cs.of(address + 4L, address + 4L + (long)len * 2L);
    }

    protected MapRecord clone() {
        Long256Impl[] long256B;
        Long256Impl[] long256A;
        DirectBinarySequence[] bs;
        int i;
        DirectCharSequence[] csB;
        DirectCharSequence[] csA;
        int n;
        if (this.csA != null) {
            n = this.csA.length;
            csA = new DirectCharSequence[n];
            csB = new DirectCharSequence[n];
            for (i = 0; i < n; ++i) {
                if (this.csA[i] == null) continue;
                csA[i] = new DirectCharSequence();
                csB[i] = new DirectCharSequence();
            }
        } else {
            csA = null;
            csB = null;
        }
        if (this.bs != null) {
            n = this.bs.length;
            bs = new DirectBinarySequence[n];
            for (i = 0; i < n; ++i) {
                if (this.bs[i] == null) continue;
                bs[i] = new DirectBinarySequence();
            }
        } else {
            bs = null;
        }
        if (this.keyLong256A != null) {
            n = this.keyLong256A.length;
            long256A = new Long256Impl[n];
            long256B = new Long256Impl[n];
            for (i = 0; i < n; ++i) {
                if (this.keyLong256A[i] == null) continue;
                long256A[i] = new Long256Impl();
                long256B[i] = new Long256Impl();
            }
        } else {
            long256A = null;
            long256B = null;
        }
        return new FastMapRecord(this.valueOffsets, this.keyTypes, this.split, this.keyOffset, csA, csB, bs, long256A, long256B);
    }

    void of(long address, long limit) {
        this.valueAddress = address;
        this.keyAddress = address + (long)this.keyOffset;
        this.limit = limit;
        this.lastKeyIndex = -1;
        this.lastKeyOffset = -1;
    }
}

