/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.client.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.client.BucketClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.RequestConfig;
import org.apache.nifi.registry.client.impl.AbstractJerseyClient;
import org.apache.nifi.registry.field.Fields;
import org.apache.nifi.registry.revision.entity.RevisionInfo;

public class JerseyBucketClient
extends AbstractJerseyClient
implements BucketClient {
    private final WebTarget bucketsTarget;

    public JerseyBucketClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyBucketClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.bucketsTarget = baseTarget.path("/buckets");
    }

    @Override
    public Bucket create(Bucket bucket) throws NiFiRegistryException, IOException {
        return this.create(bucket, Boolean.FALSE);
    }

    @Override
    public Bucket create(Bucket bucket, boolean preserveSourceProperties) throws NiFiRegistryException, IOException {
        if (bucket == null) {
            throw new IllegalArgumentException("Bucket cannot be null");
        }
        WebTarget target = this.bucketsTarget.queryParam("preserveSourceProperties", new Object[]{preserveSourceProperties});
        return this.executeAction("Error creating bucket", () -> (Bucket)this.getRequestBuilder(target).post(Entity.entity((Object)bucket, (String)"application/json"), Bucket.class));
    }

    @Override
    public Bucket get(String bucketId) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket ID cannot be blank");
        }
        return this.executeAction("Error retrieving bucket", () -> {
            WebTarget target = this.bucketsTarget.path("/{bucketId}").resolveTemplate("bucketId", (Object)bucketId);
            return (Bucket)this.getRequestBuilder(target).get(Bucket.class);
        });
    }

    @Override
    public Bucket update(Bucket bucket) throws NiFiRegistryException, IOException {
        if (bucket == null) {
            throw new IllegalArgumentException("Bucket cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)bucket.getIdentifier())) {
            throw new IllegalArgumentException("Bucket Identifier must be provided");
        }
        return this.executeAction("Error updating bucket", () -> {
            WebTarget target = this.bucketsTarget.path("/{bucketId}").resolveTemplate("bucketId", (Object)bucket.getIdentifier());
            return (Bucket)this.getRequestBuilder(target).put(Entity.entity((Object)bucket, (String)"application/json"), Bucket.class);
        });
    }

    @Override
    public Bucket delete(String bucketId) throws NiFiRegistryException, IOException {
        return this.delete(bucketId, null);
    }

    @Override
    public Bucket delete(String bucketId, RevisionInfo revision) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket ID cannot be blank");
        }
        return this.executeAction("Error deleting bucket", () -> {
            WebTarget target = this.bucketsTarget.path("/{bucketId}").resolveTemplate("bucketId", (Object)bucketId);
            target = this.addRevisionQueryParams(target, revision);
            return (Bucket)this.getRequestBuilder(target).delete(Bucket.class);
        });
    }

    @Override
    public Fields getFields() throws NiFiRegistryException, IOException {
        return this.executeAction("Error retrieving bucket field info", () -> {
            WebTarget target = this.bucketsTarget.path("/fields");
            return (Fields)this.getRequestBuilder(target).get(Fields.class);
        });
    }

    @Override
    public List<Bucket> getAll() throws NiFiRegistryException, IOException {
        return this.executeAction("Error retrieving all buckets", () -> {
            Bucket[] buckets = (Bucket[])this.getRequestBuilder(this.bucketsTarget).get(Bucket[].class);
            return buckets == null ? Collections.emptyList() : Arrays.asList(buckets);
        });
    }
}

