/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.mapping;

import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.service.ControllerServiceNode;

public interface VersionedComponentStateLookup {
    public static final VersionedComponentStateLookup ENABLED_OR_DISABLED = new VersionedComponentStateLookup(){

        @Override
        public org.apache.nifi.flow.ScheduledState getState(ProcessorNode processorNode) {
            return processorNode.getScheduledState() == ScheduledState.DISABLED ? org.apache.nifi.flow.ScheduledState.DISABLED : org.apache.nifi.flow.ScheduledState.ENABLED;
        }

        @Override
        public org.apache.nifi.flow.ScheduledState getState(Port port) {
            return port.getScheduledState() == ScheduledState.DISABLED ? org.apache.nifi.flow.ScheduledState.DISABLED : org.apache.nifi.flow.ScheduledState.ENABLED;
        }

        @Override
        public org.apache.nifi.flow.ScheduledState getState(ReportingTaskNode taskNode) {
            return taskNode.getScheduledState() == ScheduledState.DISABLED ? org.apache.nifi.flow.ScheduledState.DISABLED : org.apache.nifi.flow.ScheduledState.ENABLED;
        }

        @Override
        public org.apache.nifi.flow.ScheduledState getState(ControllerServiceNode serviceNode) {
            return org.apache.nifi.flow.ScheduledState.DISABLED;
        }
    };
    public static final VersionedComponentStateLookup IDENTITY_LOOKUP = new VersionedComponentStateLookup(){

        @Override
        public org.apache.nifi.flow.ScheduledState getState(ProcessorNode processorNode) {
            return this.map(processorNode.getDesiredState());
        }

        @Override
        public org.apache.nifi.flow.ScheduledState getState(Port port) {
            return this.map(port.getScheduledState());
        }

        @Override
        public org.apache.nifi.flow.ScheduledState getState(ReportingTaskNode taskNode) {
            return this.map(taskNode.getScheduledState());
        }

        @Override
        public org.apache.nifi.flow.ScheduledState getState(ControllerServiceNode serviceNode) {
            switch (serviceNode.getState()) {
                case ENABLED: 
                case ENABLING: {
                    return org.apache.nifi.flow.ScheduledState.ENABLED;
                }
            }
            return org.apache.nifi.flow.ScheduledState.DISABLED;
        }

        private org.apache.nifi.flow.ScheduledState map(ScheduledState componentState) {
            if (componentState == null) {
                return null;
            }
            switch (componentState) {
                case DISABLED: {
                    return org.apache.nifi.flow.ScheduledState.DISABLED;
                }
                case RUNNING: 
                case STARTING: {
                    return org.apache.nifi.flow.ScheduledState.RUNNING;
                }
            }
            return org.apache.nifi.flow.ScheduledState.ENABLED;
        }
    };

    public org.apache.nifi.flow.ScheduledState getState(ProcessorNode var1);

    public org.apache.nifi.flow.ScheduledState getState(Port var1);

    public org.apache.nifi.flow.ScheduledState getState(ReportingTaskNode var1);

    public org.apache.nifi.flow.ScheduledState getState(ControllerServiceNode var1);
}

