/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.util;

import org.apache.nifi.events.EventReporter;
import org.apache.nifi.remote.util.SiteToSiteRestApiClient;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.web.api.entity.TransactionResultEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendTransactionCommand
implements Runnable {
    private static final String CATEGORY = "Site-to-Site";
    private static final Logger logger = LoggerFactory.getLogger(ExtendTransactionCommand.class);
    private final SiteToSiteRestApiClient client;
    private final String transactionUrl;
    private final EventReporter eventReporter;

    ExtendTransactionCommand(SiteToSiteRestApiClient client, String transactionUrl, EventReporter eventReporter) {
        this.client = client;
        this.transactionUrl = transactionUrl;
        this.eventReporter = eventReporter;
    }

    @Override
    public void run() {
        try {
            TransactionResultEntity entity = this.client.extendTransaction(this.transactionUrl);
            logger.debug("Extend Transaction Completed [{}] Code [{}] FlowFiles Sent [{}]", new Object[]{this.transactionUrl, entity.getResponseCode(), entity.getFlowFileSent()});
        }
        catch (Throwable e) {
            if (e instanceof IllegalStateException) {
                logger.debug("Extend Transaction Failed [{}] client connection pool shutdown", (Object)this.transactionUrl, (Object)e);
            }
            logger.warn("Extend Transaction Failed [{}]", (Object)this.transactionUrl, (Object)e);
            String message = String.format("Extend Transaction Failed [%s]: %s", this.transactionUrl, e.getMessage());
            this.eventReporter.reportEvent(Severity.WARNING, CATEGORY, message);
            try {
                this.client.close();
            }
            catch (Exception closeException) {
                logger.warn("Extend Transaction [{}] Close Client Failed", (Object)this.transactionUrl, (Object)closeException);
            }
        }
    }
}

