/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openide.actions.ActionManager;
import org.openide.actions.Bundle;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.JMenuPlus;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class ToolsAction
extends SystemAction
implements ContextAwareAction,
Presenter.Menu,
Presenter.Popup {
    static final long serialVersionUID = 4906417339959070129L;
    private static ScheduledFuture<G> taskGl;

    static final G gl() {
        return ToolsAction.gl(Long.MAX_VALUE);
    }

    static final G gl(long timeOut) {
        ToolsAction.initGl();
        while (true) {
            try {
                return (G)taskGl.get(timeOut, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException ex) {
                return null;
            }
            catch (InterruptedException ex) {
                continue;
            }
            catch (Exception ex) {
                taskGl = null;
                throw new IllegalStateException(ex);
            }
            break;
        }
    }

    private static synchronized void initGl() {
        if (taskGl == null) {
            taskGl = RequestProcessor.getDefault().schedule(new G(), 0L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
    }

    @Override
    public String getName() {
        return ToolsAction.getActionName();
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx(ToolsAction.class);
    }

    @Override
    public JMenuItem getMenuPresenter() {
        return new Inline(this);
    }

    @Override
    public JMenuItem getPopupPresenter() {
        return new Popup(this);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        assert (false);
    }

    @Override
    public Action createContextAwareInstance(Lookup actionContext) {
        return new DelegateAction(this, actionContext);
    }

    private static String getActionName() {
        return NbBundle.getMessage(ToolsAction.class, "CTL_Tools");
    }

    static List<Action> getToolActions() {
        ActionManager am = ActionManager.getDefault();
        ArrayList<Action> arr = new ArrayList<Action>();
        arr.addAll(Arrays.asList(am.getContextActions()));
        String pref = arr.isEmpty() ? null : "";
        for (Lookup.Item<Action> item : ToolsAction.gl().result.allItems()) {
            Action action = item.getInstance();
            if (action == null) continue;
            String where = item.getId().replaceFirst("[^/]*$", "");
            if (pref != null && !pref.equals(where)) {
                arr.add(null);
            }
            pref = where;
            arr.add(action);
        }
        return arr;
    }

    private static List<JMenuItem> generate(Action toolsAction, boolean forMenu) {
        List<Action> actions = ToolsAction.getToolActions();
        ArrayList<JMenuItem> list = new ArrayList<JMenuItem>(actions.size());
        boolean separator = false;
        boolean firstItemAdded = false;
        Lookup lookup = toolsAction instanceof Lookup.Provider ? ((Lookup.Provider)((Object)toolsAction)).getLookup() : null;
        for (Action a : actions) {
            JMenuItem mi;
            if (lookup != null && a instanceof ContextAwareAction) {
                a = ((ContextAwareAction)a).createContextAwareInstance(lookup);
            }
            if (a == null) {
                if (!firstItemAdded) continue;
                separator = true;
                continue;
            }
            boolean isPopup = a instanceof Presenter.Popup;
            boolean isMenu = a instanceof Presenter.Menu;
            if (!(forMenu && isMenu || !forMenu && isPopup) && (isMenu || isPopup) || !a.isEnabled()) continue;
            if (forMenu && isMenu) {
                mi = ((Presenter.Menu)((Object)a)).getMenuPresenter();
            } else if (!forMenu && isPopup) {
                mi = ((Presenter.Popup)((Object)a)).getPopupPresenter();
            } else {
                if (isMenu || isPopup) continue;
                mi = new JMenuItem();
                Actions.connect(mi, a, !forMenu);
            }
            if (separator) {
                list.add(null);
                separator = false;
            }
            list.add(mi);
            firstItemAdded = true;
        }
        return list;
    }

    @Deprecated
    public static void setModel(Model m) {
        throw new SecurityException();
    }

    private static class G
    implements PropertyChangeListener,
    LookupListener,
    Callable<G> {
        public static final String PROP_STATE = "actionsState";
        private int timestamp = 1;
        private Action[] actions = null;
        private PropertyChangeSupport supp = new PropertyChangeSupport(this);
        Lookup.Result<Action> result;

        @Override
        public G call() {
            ActionManager am = ActionManager.getDefault();
            am.addPropertyChangeListener(this);
            this.result = Lookups.forPath("UI/ToolActions").lookupResult(Action.class);
            this.result.addLookupListener(this);
            this.actionsListChanged();
            return this;
        }

        public final void addPropertyChangeListener(PropertyChangeListener listener) {
            this.supp.addPropertyChangeListener(listener);
        }

        public final void removePropertyChangeListener(PropertyChangeListener listener) {
            this.supp.removePropertyChangeListener(listener);
        }

        protected final void firePropertyChange(String name, Object o, Object n) {
            this.supp.firePropertyChange(name, o, n);
        }

        private void actionsListChanged() {
            ++this.timestamp;
            Action[] copy = this.actions;
            if (copy != null) {
                for (int i = 0; i < copy.length; ++i) {
                    Action act = copy[i];
                    if (act == null) continue;
                    act.removePropertyChangeListener(this);
                }
            }
            ActionManager am = ActionManager.getDefault();
            ArrayList<Action> all = new ArrayList<Action>();
            all.addAll(Arrays.asList(am.getContextActions()));
            all.addAll(this.result.allInstances());
            copy = all.toArray(new Action[0]);
            for (int i = 0; i < copy.length; ++i) {
                Action act = copy[i];
                if (act == null) continue;
                act.addPropertyChangeListener(this);
            }
            this.actions = copy;
            this.firePropertyChange(PROP_STATE, null, null);
        }

        private void actionStateChanged() {
            ++this.timestamp;
            this.firePropertyChange(PROP_STATE, null, null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            String prop = ev.getPropertyName();
            if (prop == null || prop.equals("contextActions")) {
                this.actionsListChanged();
            } else if (prop.equals("enabled")) {
                this.actionStateChanged();
            }
        }

        private boolean isPopupEnabled(Action toolsAction) {
            boolean en = false;
            Action[] copy = this.actions;
            Lookup lookup = toolsAction instanceof Lookup.Provider ? ((Lookup.Provider)((Object)toolsAction)).getLookup() : null;
            for (int i = 0; i < copy.length; ++i) {
                Action act;
                if (copy[i] == null) continue;
                if (lookup != null && copy[i] instanceof ContextAwareAction) {
                    act = ((ContextAwareAction)copy[i]).createContextAwareInstance(lookup);
                    if (act == null) {
                        throw new IllegalStateException("createContextAwareInstance for " + copy[i] + " returned null!");
                    }
                } else {
                    act = copy[i];
                }
                if (!act.isEnabled()) continue;
                en = true;
                break;
            }
            return en;
        }

        private int getTimestamp() {
            return this.timestamp;
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            this.actionsListChanged();
        }
    }

    private static final class Inline
    extends JMenuItem
    implements DynamicMenuContent {
        static final long serialVersionUID = 2269006599727576059L;
        private int timestamp = 0;
        private Action toolsAction;

        Inline(Action toolsAction) {
            this.toolsAction = toolsAction;
        }

        @Override
        public JComponent[] synchMenuPresenters(JComponent[] items) {
            G g = ToolsAction.gl(50L);
            if (g == null) {
                JMenuItem init = new JMenuItem();
                init.setText(Bundle.LAB_ToolsActionInitializing());
                init.setEnabled(false);
                return new JMenuItem[]{init};
            }
            if (this.timestamp == g.getTimestamp()) {
                return items;
            }
            List l = ToolsAction.generate(this.toolsAction, true);
            this.timestamp = ToolsAction.gl().getTimestamp();
            return l.toArray(new JMenuItem[0]);
        }

        @Override
        public JComponent[] getMenuPresenters() {
            return this.synchMenuPresenters(new JComponent[0]);
        }
    }

    private static final class Popup
    extends JMenuItem
    implements DynamicMenuContent {
        static final long serialVersionUID = 2269006599727576059L;
        private JMenu menu = new MyMenu();
        private Action toolsAction;

        public Popup(Action toolsAction) {
            this.toolsAction = toolsAction;
            HelpCtx.setHelpIDString(this.menu, ToolsAction.class.getName());
        }

        @Override
        public JComponent[] synchMenuPresenters(JComponent[] items) {
            JComponent[] jComponentArray;
            if (ToolsAction.gl().isPopupEnabled(this.toolsAction)) {
                JMenuItem[] jMenuItemArray = new JMenuItem[1];
                jComponentArray = jMenuItemArray;
                jMenuItemArray[0] = this.menu;
            } else {
                jComponentArray = new JMenuItem[]{};
            }
            return jComponentArray;
        }

        @Override
        public JComponent[] getMenuPresenters() {
            return this.synchMenuPresenters(new JComponent[0]);
        }

        private class MyMenu
        extends JMenuPlus
        implements PopupMenuListener {
            private JPopupMenu lastPopup;

            MyMenu() {
                super(ToolsAction.getActionName());
                this.lastPopup = null;
            }

            @Override
            public JPopupMenu getPopupMenu() {
                JPopupMenu popup = super.getPopupMenu();
                this.fillSubmenu(popup);
                return popup;
            }

            private void fillSubmenu(JPopupMenu pop) {
                if (this.lastPopup == null) {
                    pop.addPopupMenuListener(this);
                    this.lastPopup = pop;
                    this.removeAll();
                    for (Component item : ToolsAction.generate(Popup.this.toolsAction, false)) {
                        if (item == null) {
                            this.addSeparator();
                            continue;
                        }
                        this.add(item);
                    }
                    if (this.getMenuComponentCount() == 0) {
                        JMenuItem empty = new JMenuItem(NbBundle.getMessage(ToolsAction.class, "CTL_EmptySubMenu"));
                        empty.setEnabled(false);
                        this.add(empty);
                    }
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (this.lastPopup != null) {
                    this.lastPopup.removePopupMenuListener(this);
                    this.lastPopup = null;
                }
            }
        }
    }

    private static final class DelegateAction
    implements Action,
    Presenter.Menu,
    Presenter.Popup,
    Lookup.Provider {
        private ToolsAction delegate;
        private Lookup lookup;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);

        public DelegateAction(ToolsAction delegate, Lookup actionContext) {
            this.delegate = delegate;
            this.lookup = actionContext;
        }

        public String toString() {
            return super.toString() + "[delegate=" + this.delegate + "]";
        }

        @Override
        public Lookup getLookup() {
            return this.lookup;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        public void putValue(String key, Object o) {
        }

        @Override
        public Object getValue(String key) {
            return this.delegate.getValue(key);
        }

        @Override
        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }

        @Override
        public JMenuItem getMenuPresenter() {
            return new Inline(this);
        }

        @Override
        public JMenuItem getPopupPresenter() {
            return new Popup(this);
        }
    }

    @Deprecated
    public static interface Model {
        public SystemAction[] getActions();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }
}

