/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.comp;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import jpt.sun.tools.javac.code.Directive;
import jpt.sun.tools.javac.code.Kinds;
import jpt.sun.tools.javac.code.Lint;
import jpt.sun.tools.javac.code.Symbol;
import jpt.sun.tools.javac.code.Symtab;
import jpt.sun.tools.javac.code.Type;
import jpt.sun.tools.javac.code.TypeTag;
import jpt.sun.tools.javac.code.Types;
import jpt.sun.tools.javac.comp.AttrContext;
import jpt.sun.tools.javac.comp.Env;
import jpt.sun.tools.javac.comp.Resolve;
import jpt.sun.tools.javac.resources.CompilerProperties;
import jpt.sun.tools.javac.tree.JCTree;
import jpt.sun.tools.javac.tree.TreeInfo;
import jpt.sun.tools.javac.tree.TreeScanner;
import jpt.sun.tools.javac.util.Assert;
import jpt.sun.tools.javac.util.Context;
import jpt.sun.tools.javac.util.JCDiagnostic;
import jpt.sun.tools.javac.util.List;
import jpt.sun.tools.javac.util.Log;
import jpt.sun.tools.javac.util.Names;
import jpt.sun.tools.javac.util.Pair;

public class ThisEscapeAnalyzer
extends TreeScanner {
    protected static final Context.Key<ThisEscapeAnalyzer> contextKey = new Context.Key();
    private final Names names;
    private final Symtab syms;
    private final Types types;
    private final Resolve rs;
    private final Log log;
    private Lint lint;
    private Env<AttrContext> topLevelEnv;
    private final Map<Symbol, MethodInfo> methodMap = new LinkedHashMap<Symbol, MethodInfo>();
    private final Set<Symbol> suppressed = new HashSet<Symbol>();
    private final Set<Symbol.ClassSymbol> nonPublicOuters = new HashSet<Symbol.ClassSymbol>();
    private JCTree.JCClassDecl targetClass;
    private final ArrayList<Warning> warningList = new ArrayList();
    private MethodInfo currentMethod;
    private final ArrayList<StackFrame> callStack = new ArrayList();
    private final Set<Pair<JCTree.JCMethodDecl, RefSet<Ref>>> invocations = new HashSet<Pair<JCTree.JCMethodDecl, RefSet<Ref>>>();
    private int depth = -1;
    private RefSet<Ref> refs;

    public static ThisEscapeAnalyzer instance(Context context) {
        ThisEscapeAnalyzer instance = context.get(contextKey);
        if (instance == null) {
            instance = new ThisEscapeAnalyzer(context);
        }
        return instance;
    }

    protected ThisEscapeAnalyzer(Context context) {
        context.put(contextKey, this);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.rs = Resolve.instance(context);
        this.lint = Lint.instance(context);
    }

    public void analyzeTree(Env<AttrContext> env) {
        this.topLevelEnv = env;
        try {
            this.doAnalyzeTree(env);
        }
        finally {
            this.topLevelEnv = null;
            this.methodMap.clear();
            this.nonPublicOuters.clear();
            this.targetClass = null;
            this.warningList.clear();
            this.currentMethod = null;
            this.callStack.clear();
            this.invocations.clear();
            this.depth = -1;
            this.refs = null;
        }
    }

    private void doAnalyzeTree(Env<AttrContext> env) {
        Assert.check(this.checkInvariants(false, false));
        Assert.check(this.methodMap.isEmpty());
        if (!this.lint.isEnabled(Lint.LintCategory.THIS_ESCAPE)) {
            return;
        }
        final Set exportedPackages = Optional.ofNullable(env.toplevel.modle).filter(mod -> mod != this.syms.noModule).filter(mod -> mod != this.syms.unnamedModule).map(mod -> mod.exports.stream().map(Directive.ExportsDirective::getPackage).collect(Collectors.toSet())).orElse(null);
        new TreeScanner(){
            private Lint lint;
            private JCTree.JCClassDecl currentClass;
            private boolean nonPublicOuter;
            {
                this.lint = ThisEscapeAnalyzer.this.lint;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visitClassDef(JCTree.JCClassDecl tree) {
                JCTree.JCClassDecl currentClassPrev = this.currentClass;
                boolean nonPublicOuterPrev = this.nonPublicOuter;
                Lint lintPrev = this.lint;
                this.lint = this.lint.augment(tree.sym);
                try {
                    this.currentClass = tree;
                    this.nonPublicOuter |= tree.sym.isAnonymous();
                    this.nonPublicOuter |= (tree.mods.flags & 1L) == 0L;
                    if (this.nonPublicOuter) {
                        ThisEscapeAnalyzer.this.nonPublicOuters.add(this.currentClass.sym);
                    }
                    super.visitClassDef(tree);
                }
                finally {
                    this.currentClass = currentClassPrev;
                    this.nonPublicOuter = nonPublicOuterPrev;
                    this.lint = lintPrev;
                }
            }

            @Override
            public void visitVarDef(JCTree.JCVariableDecl tree) {
                Lint lintPrev = this.lint;
                this.lint = this.lint.augment(tree.sym);
                try {
                    if (tree.sym.owner.kind == Kinds.Kind.TYP && !this.lint.isEnabled(Lint.LintCategory.THIS_ESCAPE)) {
                        ThisEscapeAnalyzer.this.suppressed.add(tree.sym);
                    }
                    super.visitVarDef(tree);
                }
                finally {
                    this.lint = lintPrev;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visitMethodDef(JCTree.JCMethodDecl tree) {
                Lint lintPrev = this.lint;
                this.lint = this.lint.augment(tree.sym);
                try {
                    if (TreeInfo.isConstructor(tree) && !this.lint.isEnabled(Lint.LintCategory.THIS_ESCAPE)) {
                        ThisEscapeAnalyzer.this.suppressed.add(tree.sym);
                    }
                    boolean constructor = TreeInfo.isConstructor(tree);
                    boolean extendableClass = this.currentClassIsExternallyExtendable();
                    boolean nonPrivate = (tree.sym.flags() & 5L) != 0L;
                    boolean finalish = (tree.mods.flags & 0x1AL) != 0L;
                    boolean analyzable = extendableClass && constructor && nonPrivate;
                    boolean invokable = !extendableClass || constructor || finalish;
                    ThisEscapeAnalyzer.this.methodMap.put(tree.sym, new MethodInfo(this.currentClass, tree, constructor, analyzable, invokable));
                    super.visitMethodDef(tree);
                }
                finally {
                    this.lint = lintPrev;
                }
            }

            private boolean currentClassIsExternallyExtendable() {
                return !this.currentClass.sym.isFinal() && this.currentClass.sym.isPublic() && (exportedPackages == null || exportedPackages.contains(this.currentClass.sym.packge())) && !this.currentClass.sym.isSealed() && !this.currentClass.sym.isDirectlyOrIndirectlyLocal() && !this.nonPublicOuter;
            }
        }.scan(env.tree);
        this.methodMap.values().stream().filter(MethodInfo::analyzable).forEach(this::analyzeConstructor);
        this.filterWarnings(warning -> !warning.isSuppressed());
        this.warningList.forEach(Warning::trimInitializerFrames);
        this.warningList.sort(Warning::sortByStackFrames);
        AtomicReference previousRef = new AtomicReference();
        this.filterWarnings(warning -> {
            Warning previous = (Warning)previousRef.get();
            if (previous != null && warning.isRedundantWith(previous)) {
                return false;
            }
            previousRef.set(warning);
            return true;
        });
        HashSet thingsWarnedAbout = new HashSet();
        this.filterWarnings(warning -> thingsWarnedAbout.add(warning.origin));
        for (Warning warning2 : this.warningList) {
            JCDiagnostic.LintWarning key = CompilerProperties.LintWarnings.PossibleThisEscape;
            for (StackFrame frame : warning2.stack) {
                this.log.warning(frame.site.pos(), (JCDiagnostic.Warning)key);
                key = CompilerProperties.LintWarnings.PossibleThisEscapeLocation;
            }
        }
        this.warningList.clear();
    }

    private void filterWarnings(Predicate<Warning> filter) {
        int numRetained = 0;
        for (Warning warning : this.warningList) {
            if (!filter.test(warning)) continue;
            this.warningList.set(numRetained++, warning);
        }
        this.warningList.subList(numRetained, this.warningList.size()).clear();
    }

    @Override
    public void scan(JCTree tree) {
        if (tree == null || tree.type == Type.stuckType) {
            return;
        }
        Assert.check(this.checkInvariants(true, false));
        boolean referenceExpressionNode = switch (tree.getTag()) {
            case JCTree.Tag.SWITCH_EXPRESSION, JCTree.Tag.CONDEXPR, JCTree.Tag.YIELD, JCTree.Tag.APPLY, JCTree.Tag.NEWCLASS, JCTree.Tag.NEWARRAY, JCTree.Tag.LAMBDA, JCTree.Tag.PARENS, JCTree.Tag.ASSIGN, JCTree.Tag.TYPECAST, JCTree.Tag.INDEXED, JCTree.Tag.SELECT, JCTree.Tag.REFERENCE, JCTree.Tag.IDENT, JCTree.Tag.NULLCHK, JCTree.Tag.LETEXPR -> true;
            default -> false;
        };
        super.scan(tree);
        Assert.check(this.checkInvariants(true, referenceExpressionNode));
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        this.visitVarDef(tree.sym, tree.init);
    }

    private void visitVarDef(Symbol.VarSymbol sym, JCTree.JCExpression expr) {
        this.scan(expr);
        if (this.isParamOrVar(sym)) {
            this.refs.replaceExprs(this.depth, ref -> new VarRef(sym, (Ref)ref));
        } else {
            this.refs.discardExprs(this.depth);
        }
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        Assert.check(false);
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation invoke) {
        Symbol sym = TreeInfo.symbolFor(invoke.meth);
        this.scan(invoke.meth);
        RefSet<ThisRef> receiverRefs = RefSet.newEmpty();
        if (sym != null && !sym.isStatic()) {
            this.refs.removeExprs(this.depth).map(ThisRef::new).forEach(receiverRefs::add);
        } else {
            this.refs.discardExprs(this.depth);
        }
        if (TreeInfo.name(invoke.meth) == this.names._super) {
            this.currentMethod.declaringClass.defs.stream().filter(def -> (TreeInfo.flags(def) & 8L) == 0L).forEach(def -> {
                int n;
                JCTree jCTree = def;
                Objects.requireNonNull(jCTree);
                JCTree selector0$temp = jCTree;
                int index$1 = 0;
                if (selector0$temp == null) {
                    n = -1;
                } else {
                    switch (index$1) {
                        case 0: {
                            if (selector0$temp instanceof JCTree.JCBlock) {
                                n = 0;
                                break;
                            }
                        }
                        case 1: {
                            if (selector0$temp instanceof JCTree.JCVariableDecl) {
                                n = 1;
                                break;
                            }
                        }
                        default: {
                            n = 2;
                        }
                    }
                }
                switch (n) {
                    case 0: {
                        JCTree.JCBlock block = (JCTree.JCBlock)selector0$temp;
                        this.analyzeInitializer(invoke, block, receiverRefs, () -> this.visitBlock(block));
                        break;
                    }
                    case 1: {
                        JCTree.JCVariableDecl varDecl = (JCTree.JCVariableDecl)selector0$temp;
                        this.analyzeInitializer(invoke, varDecl, receiverRefs, () -> this.scan(varDecl));
                        break;
                    }
                }
            });
            return;
        }
        this.invoke(invoke, sym, invoke.args, receiverRefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeInitializer(JCTree.JCMethodInvocation site, JCTree initializer, RefSet<ThisRef> receiverRefs, Runnable action) {
        RefSet<Ref> refsPrev = this.refs;
        this.refs = RefSet.newEmpty();
        int depthPrev = this.depth;
        this.depth = 0;
        this.callStack.add(new StackFrame(this.currentMethod, initializer, site));
        try {
            this.refs.addAll(receiverRefs);
            action.run();
        }
        finally {
            this.callStack.remove(this.callStack.size() - 1);
            this.depth = depthPrev;
            this.refs = refsPrev;
        }
    }

    private void invoke(JCTree site, Symbol sym, List<JCTree.JCExpression> args, RefSet<ThisRef> receiverRefs) {
        if (sym != null && sym.owner.kind == Kinds.Kind.TYP && sym.owner.type.tsym == this.syms.objectType.tsym && sym.isFinal()) {
            return;
        }
        MethodInfo methodInfo = this.methodMap.get(sym);
        if (methodInfo == null && receiverRefs.size() == 1) {
            ThisRef receiverRef = (ThisRef)receiverRefs.iterator().next();
            methodInfo = this.methodMap.values().stream().filter(info -> this.isTargetMethod((MethodInfo)info, sym, receiverRef.tsym)).findFirst().orElse(null);
        }
        if (methodInfo != null && methodInfo.invokable) {
            this.invokeInvokable(site, args, receiverRefs, methodInfo);
        } else {
            this.invokeUnknown(site, args, receiverRefs);
        }
    }

    private boolean isTargetMethod(MethodInfo info, Symbol method, Symbol.TypeSymbol receiverType) {
        return method.kind == Kinds.Kind.MTH && info.declaration.name == method.name && info.declaringClass.sym == receiverType && !info.declaration.sym.isConstructor() && (info.declaration.sym.flags() & 8L) == 0L && info.declaration.sym.overrides(method, receiverType, this.types, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeInvokable(JCTree site, List<JCTree.JCExpression> args, RefSet<ThisRef> receiverRefs, MethodInfo methodInfo) {
        Assert.check(methodInfo.invokable);
        JCTree.JCMethodDecl method = methodInfo.declaration;
        RefSet paramRefs = RefSet.newEmpty();
        List<JCTree.JCVariableDecl> params = method.params;
        while (args.nonEmpty() && params.nonEmpty()) {
            Symbol.VarSymbol sym = ((JCTree.JCVariableDecl)params.head).sym;
            this.scan((JCTree)args.head);
            this.refs.removeExprs(this.depth).map(ref -> new VarRef(sym, (Ref)ref)).forEach(paramRefs::add);
            args = args.tail;
            params = params.tail;
        }
        MethodInfo currentMethodPrev = this.currentMethod;
        this.currentMethod = methodInfo;
        RefSet<Ref> refsPrev = this.refs;
        this.refs = RefSet.newEmpty();
        int depthPrev = this.depth;
        this.depth = 0;
        this.callStack.add(new StackFrame(currentMethodPrev, null, site));
        try {
            this.refs.addAll(receiverRefs);
            this.refs.addAll(paramRefs);
            if (this.refs.isEmpty()) {
                return;
            }
            Pair<JCTree.JCMethodDecl, Object> invocation = Pair.of(methodInfo.declaration, this.refs.clone());
            if (!this.invocations.add(invocation)) {
                return;
            }
            try {
                this.scan(method.body);
            }
            finally {
                this.invocations.remove(invocation);
            }
            if (TreeInfo.isConstructor(methodInfo.declaration)) {
                this.refs.remove(ThisRef.class).map(ReturnRef::new).forEach(this.refs::add);
            }
            this.refs.remove(ReturnRef.class).map(ref -> new ExprRef(depthPrev, (Ref)ref)).forEach(refsPrev::add);
        }
        finally {
            this.callStack.remove(this.callStack.size() - 1);
            this.depth = depthPrev;
            this.refs = refsPrev;
            this.currentMethod = currentMethodPrev;
        }
    }

    private void invokeUnknown(JCTree invoke, List<JCTree.JCExpression> args, RefSet<ThisRef> receiverRefs) {
        if (receiverRefs.stream().anyMatch(this::triggersUnknownInvokeLeak)) {
            this.leakAt(invoke);
        }
        for (JCTree.JCExpression arg : args) {
            this.scan(arg);
            if (!this.refs.removeExprs(this.depth).anyMatch(this::triggersUnknownInvokeLeak)) continue;
            this.leakAt(arg);
        }
        if (invoke.hasTag(JCTree.Tag.NEWCLASS)) {
            receiverRefs.stream().map(ref -> new ExprRef(this.depth, (Ref)ref)).forEach(this.refs::add);
        }
    }

    private boolean triggersUnknownInvokeLeak(Ref ref) {
        return !this.nonPublicOuters.contains(ref.tsym) || ref.indirections.stream().anyMatch(i -> i != Indirection.OUTER);
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        MethodInfo methodInfo = this.methodMap.get(tree.constructor);
        Symbol.TypeSymbol tsym = tree.def != null ? tree.def.sym : tree.clazz.type.tsym;
        RefSet<ThisRef> receiverRefs = this.receiverRefsForConstructor(tree.encl, tsym);
        if (methodInfo != null && methodInfo.invokable) {
            this.invokeInvokable(tree, tree.args, receiverRefs, methodInfo);
        } else {
            this.invokeUnknown(tree, tree.args, receiverRefs);
        }
    }

    private RefSet<ThisRef> receiverRefsForConstructor(JCTree.JCExpression explicitOuterThis, Symbol.TypeSymbol tsym) {
        if (explicitOuterThis != null) {
            this.scan(explicitOuterThis);
            return this.refs.removeExprs(this.depth).map(ref -> ref.toOuter(explicitOuterThis.type.tsym)).flatMap(opt$$ -> opt$$.isPresent() ? Stream.of((ThisRef)opt$$.get()) : Stream.empty()).collect(RefSet.collector());
        }
        if (this.hasImplicitOuterInstance(tsym)) {
            return this.refs.find(ThisRef.class).map(ref -> ref.toOuter(tsym)).flatMap(opt$$ -> opt$$.isPresent() ? Stream.of((ThisRef)opt$$.get()) : Stream.empty()).collect(RefSet.collector());
        }
        return RefSet.newEmpty();
    }

    private boolean hasImplicitOuterInstance(Symbol.TypeSymbol tsym) {
        Symbol.ClassSymbol currentClassSym = this.currentMethod.declaringClass.sym;
        return tsym != currentClassSym && tsym.hasOuterInstance() && tsym.isEnclosedBy(currentClassSym);
    }

    @Override
    public void visitBlock(JCTree.JCBlock tree) {
        this.visitScoped(false, () -> super.visitBlock(tree));
        Assert.check(this.checkInvariants(true, false));
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
        this.visitLooped(tree, x$0 -> super.visitDoLoop((JCTree.JCDoWhileLoop)x$0));
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop tree) {
        this.visitLooped(tree, x$0 -> super.visitWhileLoop((JCTree.JCWhileLoop)x$0));
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop tree) {
        this.visitLooped(tree, x$0 -> super.visitForLoop((JCTree.JCForLoop)x$0));
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
        Symbol iteratorSym;
        Type elemType = this.types.elemtype(tree.expr.type);
        Symbol.MethodSymbol iterator = null;
        Symbol.MethodSymbol hasNext = null;
        Symbol.MethodSymbol next = null;
        if (elemType == null && (iteratorSym = this.rs.resolveQualifiedMethod(tree.expr.pos(), this.topLevelEnv, tree.expr.type, this.names.iterator, List.nil(), List.nil())) instanceof Symbol.MethodSymbol) {
            iterator = (Symbol.MethodSymbol)iteratorSym;
            Symbol hasNextSym = this.rs.resolveQualifiedMethod(tree.expr.pos(), this.topLevelEnv, iterator.getReturnType(), this.names.hasNext, List.nil(), List.nil());
            Symbol nextSym = this.rs.resolveQualifiedMethod(tree.expr.pos(), this.topLevelEnv, iterator.getReturnType(), this.names.next, List.nil(), List.nil());
            if (hasNextSym instanceof Symbol.MethodSymbol) {
                hasNext = (Symbol.MethodSymbol)hasNextSym;
            }
            if (nextSym instanceof Symbol.MethodSymbol) {
                next = (Symbol.MethodSymbol)nextSym;
            }
        }
        record ForeachMethods(Symbol.MethodSymbol iterator, Symbol.MethodSymbol hasNext, Symbol.MethodSymbol next) {
        }
        ForeachMethods foreachMethods = iterator != null && hasNext != null && next != null ? new ForeachMethods(iterator, hasNext, next) : null;
        this.visitLooped(tree, foreach -> {
            this.scan(foreach.expr);
            if (elemType != null) {
                if (this.isParamOrVar(foreach.var.sym)) {
                    this.refs.removeExprs(this.depth).map(ref -> ref.toIndirect(elemType.tsym)).flatMap(opt$$ -> opt$$.isPresent() ? Stream.of((ExprRef)opt$$.get()) : Stream.empty()).map(ref -> new VarRef(foreach.var.sym, (Ref)ref)).forEach(this.refs::add);
                } else {
                    this.refs.discardExprs(this.depth);
                }
            } else if (foreachMethods != null) {
                RefSet<ThisRef> receiverRefs = this.refs.removeExprs(this.depth).map(ThisRef::new).collect(RefSet.collector());
                this.invoke(foreach.expr, foreachMethods.iterator, List.nil(), receiverRefs);
                receiverRefs = this.refs.removeExprs(this.depth).map(ThisRef::new).collect(RefSet.collector());
                this.invoke(foreach.expr, foreachMethods.hasNext, List.nil(), receiverRefs);
                this.refs.discardExprs(this.depth);
                this.invoke(foreach.expr, foreachMethods.next, List.nil(), receiverRefs);
                if (this.isParamOrVar(foreach.var.sym)) {
                    this.refs.replaceExprs(this.depth, ref -> new VarRef(foreach.var.sym, (Ref)ref));
                } else {
                    this.refs.discardExprs(this.depth);
                }
            } else {
                this.refs.discardExprs(this.depth);
            }
            this.scan(foreach.body);
        });
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch tree) {
        this.visitScoped(false, () -> {
            this.scan(tree.selector);
            this.refs.discardExprs(this.depth);
            this.scan(tree.cases);
        });
    }

    @Override
    public void visitSwitchExpression(JCTree.JCSwitchExpression tree) {
        this.visitScoped(true, () -> {
            this.scan(tree.selector);
            this.refs.discardExprs(this.depth);
            RefSet combinedRefs = RefSet.newEmpty();
            List<JCTree.JCCase> cases = tree.cases;
            while (cases.nonEmpty()) {
                this.scan(((JCTree.JCCase)cases.head).stats);
                this.refs.remove(YieldRef.class).map(ref -> new ExprRef(this.depth, (Ref)ref)).forEach(combinedRefs::add);
                this.refs.removeExprs(this.depth).forEach(combinedRefs::add);
                cases = cases.tail;
            }
            this.refs.addAll(combinedRefs);
        });
    }

    @Override
    public void visitCase(JCTree.JCCase tree) {
        this.scan(tree.stats);
    }

    @Override
    public void visitYield(JCTree.JCYield tree) {
        this.scan(tree.value);
        this.refs.replaceExprs(this.depth, YieldRef::new);
    }

    @Override
    public void visitLetExpr(JCTree.LetExpr tree) {
        this.visitScoped(true, () -> super.visitLetExpr(tree));
    }

    @Override
    public void visitReturn(JCTree.JCReturn tree) {
        this.scan(tree.expr);
        this.refs.replaceExprs(this.depth, ReturnRef::new);
    }

    @Override
    public void visitLambda(JCTree.JCLambda lambda) {
        this.visitDeferred(() -> this.visitScoped(true, () -> this.scan(lambda.body)));
    }

    @Override
    public void visitAssign(JCTree.JCAssign tree) {
        Symbol.VarSymbol sym = (Symbol.VarSymbol)TreeInfo.symbolFor(tree.lhs);
        this.scan(tree.lhs);
        this.refs.discardExprs(this.depth);
        this.scan(tree.rhs);
        if (this.isParamOrVar(sym)) {
            this.refs.replaceExprs(this.depth, ref -> new VarRef(sym, (Ref)ref));
        } else {
            this.refs.discardExprs(this.depth);
        }
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess tree) {
        this.scan(tree.index);
        this.refs.discardExprs(this.depth);
        this.scan(tree.indexed);
        this.refs.removeExprs(this.depth).map(ref -> ref.toDirect(tree.type.tsym)).flatMap(opt$$ -> opt$$.isPresent() ? Stream.of((ExprRef)opt$$.get()) : Stream.empty()).forEach(this.refs::add);
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        this.scan(tree.selected);
        Stream<ExprRef> methodRefs = this.refs.removeExprs(this.depth);
        Type.ClassType currentClassType = (Type.ClassType)this.currentMethod.declaringClass.sym.type;
        if (TreeInfo.isExplicitThisReference(this.types, currentClassType, tree)) {
            this.refs.find(ThisRef.class).map(ref -> new ExprRef(this.depth, (Ref)ref)).forEach(this.refs::add);
            return;
        }
        if (this.isExplicitOuterThisReference(this.types, currentClassType, tree)) {
            this.refs.find(ThisRef.class).map(ref -> ref.fromOuter(this.depth)).flatMap(opt$$ -> opt$$.isPresent() ? Stream.of((ExprRef)opt$$.get()) : Stream.empty()).forEach(this.refs::add);
            return;
        }
        if (tree.sym.kind == Kinds.Kind.MTH && (tree.sym.flags() & 8L) == 0L) {
            methodRefs.forEach(this.refs::add);
        }
    }

    @Override
    public void visitReference(JCTree.JCMemberReference tree) {
        if (tree.type.isErroneous()) {
            return;
        }
        this.scan(tree.expr);
        RefSet receiverRefs = RefSet.newEmpty();
        switch (tree.kind) {
            case UNBOUND: 
            case STATIC: 
            case TOPLEVEL: 
            case ARRAY_CTOR: {
                this.refs.discardExprs(this.depth);
                return;
            }
            case SUPER: 
            case BOUND: {
                this.refs.removeExprs(this.depth).map(ThisRef::new).forEach(receiverRefs::add);
                break;
            }
            case IMPLICIT_INNER: {
                this.receiverRefsForConstructor(null, tree.expr.type.tsym).forEach(receiverRefs::add);
                break;
            }
            default: {
                throw new RuntimeException("non-exhaustive?");
            }
        }
        this.visitDeferred(() -> this.invoke(tree, (Symbol.MethodSymbol)tree.sym, List.nil(), receiverRefs));
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        block8: {
            block7: {
                if (tree.name == this.names._this) break block7;
                if (tree.name != this.names._super) break block8;
            }
            this.refs.find(ThisRef.class).map(ref -> new ExprRef(this.depth, (Ref)ref)).forEach(this.refs::add);
            return;
        }
        if (this.isParamOrVar(tree.sym)) {
            Symbol.VarSymbol sym = (Symbol.VarSymbol)tree.sym;
            this.refs.find(VarRef.class, ref -> ref.sym == sym).map(ref -> new ExprRef(this.depth, (Ref)ref)).forEach(this.refs::add);
            return;
        }
        if (tree.sym.kind == Kinds.Kind.MTH && (tree.sym.flags() & 8L) == 0L) {
            Symbol.MethodSymbol sym = (Symbol.MethodSymbol)tree.sym;
            Symbol.ClassSymbol methodClassSym = this.currentMethod.declaringClass.sym;
            if (methodClassSym.isSubClass(sym.owner, this.types)) {
                this.refs.find(ThisRef.class).map(ref -> new ExprRef(this.depth, (Ref)ref)).forEach(this.refs::add);
                return;
            }
            if (methodClassSym.isEnclosedBy((Symbol.ClassSymbol)sym.owner)) {
                this.refs.find(ThisRef.class).map(ref -> ref.fromOuter(this.depth)).flatMap(opt$$ -> opt$$.isPresent() ? Stream.of((ExprRef)opt$$.get()) : Stream.empty()).forEach(this.refs::add);
                return;
            }
            return;
        }
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized tree) {
        this.scan(tree.lock);
        this.refs.discardExprs(this.depth);
        this.scan(tree.body);
    }

    @Override
    public void visitConditional(JCTree.JCConditional tree) {
        this.scan(tree.cond);
        this.refs.discardExprs(this.depth);
        RefSet combinedRefs = RefSet.newEmpty();
        this.scan(tree.truepart);
        this.refs.removeExprs(this.depth).forEach(combinedRefs::add);
        this.scan(tree.falsepart);
        this.refs.removeExprs(this.depth).forEach(combinedRefs::add);
        this.refs.addAll(combinedRefs);
    }

    @Override
    public void visitIf(JCTree.JCIf tree) {
        this.scan(tree.cond);
        this.refs.discardExprs(this.depth);
        this.scan(tree.thenpart);
        this.scan(tree.elsepart);
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement tree) {
        this.scan(tree.expr);
        this.refs.discardExprs(this.depth);
    }

    @Override
    public void visitThrow(JCTree.JCThrow tree) {
        this.scan(tree.expr);
        if (this.refs.discardExprs(this.depth)) {
            this.leakAt(tree);
        }
    }

    @Override
    public void visitAssert(JCTree.JCAssert tree) {
        this.scan(tree.cond);
        this.refs.discardExprs(this.depth);
        this.scan(tree.detail);
        this.refs.discardExprs(this.depth);
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray tree) {
        RefSet combinedRefs = RefSet.newEmpty();
        if (tree.elems != null) {
            List<JCTree.JCExpression> elems = tree.elems;
            while (elems.nonEmpty()) {
                this.scan((JCTree)elems.head);
                this.refs.removeExprs(this.depth).map(ref -> ref.toIndirect(tree.type.tsym)).flatMap(opt$$ -> opt$$.isPresent() ? Stream.of((ExprRef)opt$$.get()) : Stream.empty()).forEach(combinedRefs::add);
                elems = elems.tail;
            }
        }
        combinedRefs.stream().forEach(this.refs::add);
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        this.scan(tree.expr);
        this.refs.replaceExprs(this.depth, ref -> ref.withType(tree.expr.type.tsym));
    }

    @Override
    public void visitConstantCaseLabel(JCTree.JCConstantCaseLabel tree) {
    }

    @Override
    public void visitPatternCaseLabel(JCTree.JCPatternCaseLabel tree) {
    }

    @Override
    public void visitRecordPattern(JCTree.JCRecordPattern that) {
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf tree) {
        this.scan(tree.expr);
        this.refs.discardExprs(this.depth);
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply tree) {
    }

    @Override
    public void visitTypeUnion(JCTree.JCTypeUnion tree) {
    }

    @Override
    public void visitTypeIntersection(JCTree.JCTypeIntersection tree) {
    }

    @Override
    public void visitTypeParameter(JCTree.JCTypeParameter tree) {
    }

    @Override
    public void visitWildcard(JCTree.JCWildcard tree) {
    }

    @Override
    public void visitTypeBoundKind(JCTree.TypeBoundKind that) {
    }

    @Override
    public void visitModifiers(JCTree.JCModifiers tree) {
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation tree) {
    }

    @Override
    public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp tree) {
        this.scan(tree.lhs);
        this.refs.discardExprs(this.depth);
        this.scan(tree.rhs);
        this.refs.discardExprs(this.depth);
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        this.scan(tree.arg);
        this.refs.discardExprs(this.depth);
    }

    @Override
    public void visitBinary(JCTree.JCBinary tree) {
        this.scan(tree.lhs);
        this.refs.discardExprs(this.depth);
        this.scan(tree.rhs);
        this.refs.discardExprs(this.depth);
    }

    private void analyzeConstructor(MethodInfo constructor) {
        Assert.check(this.targetClass == null);
        Assert.check(this.currentMethod == null);
        Assert.check(this.depth == -1);
        Assert.check(this.refs == null);
        this.targetClass = constructor.declaringClass;
        this.currentMethod = constructor;
        try {
            this.refs = RefSet.newEmpty();
            this.refs.add(new ThisRef(this.targetClass.sym, EnumSet.of(Indirection.DIRECT)));
            this.visitScoped(false, () -> this.scan(constructor.declaration.body));
            Assert.check(this.depth == -1);
        }
        catch (Throwable throwable) {
            Assert.check(this.depth == -1);
            this.currentMethod = null;
            this.targetClass = null;
            this.refs = null;
            throw throwable;
        }
        this.currentMethod = null;
        this.targetClass = null;
        this.refs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends JCTree> void visitDeferred(Runnable deferredCode) {
        int numWarningsPrev = this.warningList.size();
        Object refsPrev = this.refs.clone();
        try {
            deferredCode.run();
            boolean deferredCodeLeaks = this.warningList.size() > numWarningsPrev;
        }
        finally {
            this.refs = refsPrev;
            this.warningList.subList(numWarningsPrev, this.warningList.size()).clear();
        }
        if (deferredCodeLeaks |= this.refs.discardExprs(this.depth)) {
            this.refs.add(new ExprRef(this.depth, this.syms.objectType.tsym, EnumSet.of(Indirection.INDIRECT)));
        }
    }

    private <T extends JCTree> void visitLooped(T tree, Consumer<T> visitor) {
        this.visitScoped(false, () -> {
            Object prevRefs;
            do {
                prevRefs = this.refs.clone();
                visitor.accept(tree);
            } while (!this.refs.equals(prevRefs));
        });
    }

    private void visitScoped(boolean promote, Runnable action) {
        this.pushScope();
        try {
            Assert.check(this.checkInvariants(true, false));
            action.run();
            Assert.check(this.checkInvariants(true, promote));
            if (promote) {
                Assert.check(this.depth > 0);
                this.refs.removeExprs(this.depth).map(ref -> new ExprRef(this.depth - 1, (Ref)ref)).forEach(this.refs::add);
            }
        }
        finally {
            this.popScope();
        }
    }

    private void pushScope() {
        ++this.depth;
    }

    private void popScope() {
        Assert.check(this.depth >= 0);
        this.refs.discardExprs(this.depth);
        --this.depth;
    }

    private void leakAt(JCTree tree) {
        this.callStack.add(new StackFrame(this.currentMethod, null, tree));
        this.warningList.add(new Warning(this.targetClass, new ArrayList<StackFrame>(this.callStack)));
        this.callStack.remove(this.callStack.size() - 1);
    }

    private boolean isParamOrVar(Symbol sym) {
        return sym != null && sym.kind == Kinds.Kind.VAR && (sym.owner.kind == Kinds.Kind.MTH || sym.owner.kind == Kinds.Kind.VAR);
    }

    private boolean isExplicitOuterThisReference(Types types, Type.ClassType currentClass, JCTree.JCFieldAccess select) {
        Type selectedType = types.erasure(select.selected.type);
        if (selectedType.hasTag(TypeTag.CLASS)) {
            Symbol.ClassSymbol currentClassSym = (Symbol.ClassSymbol)currentClass.tsym;
            Symbol.ClassSymbol selectedTypeSym = (Symbol.ClassSymbol)selectedType.tsym;
            if (select.name == this.names._this && currentClassSym.hasOuterInstance() && currentClassSym.owner.enclClass() == selectedTypeSym) {
                return true;
            }
        }
        return false;
    }

    private boolean isAnalyzing() {
        return this.targetClass != null;
    }

    private boolean checkInvariants(boolean analyzing, boolean allowExpr) {
        Assert.check(analyzing == this.isAnalyzing());
        if (this.isAnalyzing()) {
            Assert.check(this.currentMethod != null);
            Assert.check(this.targetClass != null);
            Assert.check(this.refs != null);
            Assert.check(this.depth >= 0);
            Assert.check(this.refs.find(ExprRef.class).allMatch(ref -> allowExpr && ref.depth <= this.depth));
        } else {
            Assert.check(this.targetClass == null);
            Assert.check(this.refs == null);
            Assert.check(this.depth == -1);
            Assert.check(this.callStack.isEmpty());
            Assert.check(this.invocations.isEmpty());
        }
        return true;
    }

    private record MethodInfo(JCTree.JCClassDecl declaringClass, JCTree.JCMethodDecl declaration, boolean constructor, boolean analyzable, boolean invokable) {
        @Override
        public String toString() {
            return "MethodInfo[method=" + String.valueOf(this.declaringClass.sym.flatname) + "." + String.valueOf(this.declaration.sym) + ",constructor=" + this.constructor + ",analyzable=" + this.analyzable + ",invokable=" + this.invokable + "]";
        }
    }

    private static class RefSet<T extends Ref>
    extends HashSet<T> {
        private RefSet() {
            super(8);
        }

        public static <T extends Ref> RefSet<T> newEmpty() {
            return new RefSet<T>();
        }

        public <T extends Ref> Stream<T> find(Class<T> refType) {
            return this.find(refType, ref -> true);
        }

        public <T extends Ref> Stream<T> find(Class<T> refType, Predicate<? super T> filter) {
            return this.stream().filter(refType::isInstance).map(refType::cast).filter(filter).collect(Collectors.toList()).stream();
        }

        public Stream<ExprRef> findExprs(int depth) {
            return this.find(ExprRef.class, ref -> ref.depth == depth);
        }

        public <T extends Ref> Stream<T> remove(Class<T> refType) {
            return this.remove(refType, ref -> true);
        }

        public <T extends Ref> Stream<T> remove(Class<T> refType, Predicate<? super T> filter) {
            ArrayList list = this.stream().filter(refType::isInstance).map(refType::cast).filter(filter).collect(Collectors.toCollection(ArrayList::new));
            this.removeAll(list);
            return list.stream();
        }

        public Stream<ExprRef> removeExprs(int depth) {
            return this.remove(ExprRef.class, ref -> ref.depth == depth);
        }

        public boolean discardExprs(int depth) {
            return this.removeIf(ref -> {
                if (!(ref instanceof ExprRef)) return false;
                ExprRef exprRef = (ExprRef)ref;
                if (exprRef.depth != depth) return false;
                return true;
            });
        }

        public void replaceExprs(int depth, Function<? super ExprRef, ? extends T> mapper) {
            this.removeExprs(depth).map(mapper).forEach(this::add);
        }

        @Override
        public RefSet<T> clone() {
            return (RefSet)super.clone();
        }

        public static <T extends Ref> Collector<T, ?, RefSet<T>> collector() {
            return Collectors.toCollection(RefSet::new);
        }
    }

    private class Warning {
        final JCTree.JCClassDecl declaringClass;
        final ArrayList<StackFrame> stack;
        final JCTree origin;

        Warning(JCTree.JCClassDecl declaringClass, ArrayList<StackFrame> stack) {
            this.declaringClass = declaringClass;
            this.stack = stack;
            this.origin = stack.stream().map(frame -> frame.initializer).filter(Objects::nonNull).findFirst().orElseGet(() -> ((StackFrame)stack.get((int)0)).method.declaration);
        }

        boolean isRedundantWith(Warning that) {
            int numExtra = this.stack.size() - that.stack.size();
            return numExtra >= 0 && IntStream.range(0, that.stack.size()).allMatch(index -> this.stack.get(numExtra + index).comparePos(that.stack.get(index)) == 0);
        }

        static int sortByStackFrames(Warning warning1, Warning warning2) {
            int diff;
            int index1 = warning1.stack.size();
            int index2 = warning2.stack.size();
            do {
                boolean end2;
                boolean end1 = --index1 < 0;
                boolean bl = end2 = --index2 < 0;
                if (end1 && end2) {
                    return 0;
                }
                if (end1) {
                    return -1;
                }
                if (!end2) continue;
                return 1;
            } while ((diff = warning1.stack.get(index1).comparePos(warning2.stack.get(index2))) == 0);
            return diff;
        }

        boolean isSuppressed() {
            for (int index = this.stack.size() - 1; index >= 0; --index) {
                if (!this.stack.get(index).isSuppressed()) continue;
                return true;
            }
            return false;
        }

        void trimInitializerFrames() {
            for (int i = 0; i < this.stack.size(); ++i) {
                if (this.stack.get((int)i).initializer == null) continue;
                this.stack.subList(0, i + 1).clear();
                break;
            }
        }

        public String toString() {
            return "Warning[class=" + String.valueOf(this.declaringClass.sym.flatname) + ",stack=[\n    " + this.stack.stream().map(StackFrame::toString).collect(Collectors.joining("\n    ")) + "]]";
        }
    }

    private class StackFrame {
        final MethodInfo method;
        final JCTree site;
        final JCTree initializer;
        final boolean suppressible;

        StackFrame(MethodInfo method, JCTree initializer, JCTree site) {
            this.method = method;
            this.initializer = initializer;
            this.site = site;
            this.suppressible = initializer != null || method.constructor && method.declaringClass == ThisEscapeAnalyzer.this.targetClass;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isSuppressed() {
            Symbol symbol;
            if (!this.suppressible) return false;
            Set<Symbol> set = ThisEscapeAnalyzer.this.suppressed;
            JCTree jCTree = this.initializer;
            if (jCTree instanceof JCTree.JCVariableDecl) {
                JCTree.JCVariableDecl v = (JCTree.JCVariableDecl)jCTree;
                symbol = v.sym;
            } else {
                symbol = this.method.declaration.sym;
            }
            if (!set.contains(symbol)) return false;
            return true;
        }

        int comparePos(StackFrame that) {
            return Integer.compare(this.site.pos().getPreferredPosition(), that.site.pos().getPreferredPosition());
        }

        public String toString() {
            return "StackFrame[" + String.valueOf(this.method.declaration.sym) + "@" + this.site.pos().getPreferredPosition() + (String)(this.initializer != null ? ",init@" + this.initializer.pos().getPreferredPosition() : "") + "]";
        }
    }

    private static class ThisRef
    extends Ref {
        ThisRef(Ref ref) {
            super(ref);
        }

        ThisRef(Symbol.TypeSymbol tsym, EnumSet<Indirection> indirections) {
            super(tsym, indirections);
        }

        @Override
        public ThisRef withType(Symbol.TypeSymbol tsym) {
            return new ThisRef(tsym, this.indirections);
        }

        public Optional<ExprRef> fromOuter(int depth) {
            Symbol.ClassSymbol outerType = Optional.of(this.tsym.owner).map(Symbol::enclClass).orElse(null);
            if (outerType == null) {
                return Optional.empty();
            }
            return Optional.of(this).filter(ref -> ref.indirections.contains((Object)Indirection.OUTER)).map(ref -> new ExprRef(depth, outerType, ref.modifiedIndirections(indirections -> {
                indirections.remove((Object)Indirection.OUTER);
                indirections.remove((Object)Indirection.INDIRECT);
                indirections.add(Indirection.DIRECT);
            })));
        }
    }

    private static class ReturnRef
    extends Ref {
        ReturnRef(Ref ref) {
            super(ref);
        }

        ReturnRef(Symbol.TypeSymbol tsym, EnumSet<Indirection> indirections) {
            super(tsym, indirections);
        }

        @Override
        public ReturnRef withType(Symbol.TypeSymbol tsym) {
            return new ReturnRef(tsym, this.indirections);
        }
    }

    private static abstract class Ref {
        final Symbol.TypeSymbol tsym;
        final EnumSet<Indirection> indirections;

        Ref(Ref ref) {
            this(ref.tsym, ref.indirections);
        }

        Ref(Symbol.TypeSymbol tsym, EnumSet<Indirection> indirections) {
            Assert.check(tsym != null);
            Assert.check(indirections != null);
            this.tsym = tsym;
            this.indirections = EnumSet.copyOf(indirections);
        }

        public abstract Ref withType(Symbol.TypeSymbol var1);

        public int hashCode() {
            return this.getClass().hashCode() ^ this.tsym.hashCode() ^ this.indirections.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Ref that = (Ref)obj;
            return this.tsym == that.tsym && this.indirections.equals(that.indirections);
        }

        public final String toString() {
            ArrayList<String> properties = new ArrayList<String>();
            properties.add("tsym=" + String.valueOf(this.tsym));
            this.addProperties(properties);
            properties.add(this.indirections.stream().map(Enum::name).collect(Collectors.joining(",")));
            return this.getClass().getSimpleName() + "[" + properties.stream().collect(Collectors.joining(",")) + "]";
        }

        protected void addProperties(ArrayList<String> properties) {
        }

        public EnumSet<Indirection> modifiedIndirections(Consumer<? super EnumSet<Indirection>> modifier) {
            EnumSet<Indirection> newIndirections = EnumSet.copyOf(this.indirections);
            modifier.accept(newIndirections);
            Assert.check(!newIndirections.isEmpty());
            return newIndirections;
        }

        public Optional<ThisRef> toOuter(Symbol.TypeSymbol tsym) {
            return Optional.of(this).filter(ref -> ref.indirections.contains((Object)Indirection.DIRECT)).map(ref -> new ThisRef(tsym, ref.modifiedIndirections(indirections -> {
                indirections.remove((Object)Indirection.DIRECT);
                indirections.remove((Object)Indirection.INDIRECT);
                indirections.add(Indirection.OUTER);
            })));
        }
    }

    private static class VarRef
    extends Ref {
        final Symbol.VarSymbol sym;

        VarRef(Symbol.VarSymbol sym, Ref ref) {
            super(ref);
            this.sym = sym;
        }

        VarRef(Symbol.VarSymbol sym, Symbol.TypeSymbol tsym, EnumSet<Indirection> indirections) {
            super(tsym, indirections);
            this.sym = sym;
        }

        @Override
        public VarRef withType(Symbol.TypeSymbol tsym) {
            return new VarRef(this.sym, tsym, this.indirections);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ Objects.hashCode(this.sym);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            VarRef that = (VarRef)obj;
            return Objects.equals(this.sym, that.sym);
        }

        @Override
        protected void addProperties(ArrayList<String> properties) {
            super.addProperties(properties);
            properties.add("sym=" + String.valueOf(this.sym));
        }
    }

    static enum Indirection {
        DIRECT,
        OUTER,
        INDIRECT;

    }

    private static class ExprRef
    extends Ref {
        final int depth;

        ExprRef(int depth, Ref ref) {
            super(ref);
            this.depth = depth;
        }

        ExprRef(int depth, Symbol.TypeSymbol tsym, EnumSet<Indirection> indirections) {
            super(tsym, indirections);
            this.depth = depth;
        }

        @Override
        public ExprRef withType(Symbol.TypeSymbol tsym) {
            return new ExprRef(this.depth, tsym, this.indirections);
        }

        public Optional<ExprRef> toIndirect(Symbol.TypeSymbol indirectType) {
            return Optional.of(this).filter(ref -> ref.indirections.contains((Object)Indirection.DIRECT) || ref.indirections.contains((Object)Indirection.INDIRECT)).map(ref -> new ExprRef(this.depth, indirectType, ref.modifiedIndirections(indirections -> {
                indirections.remove((Object)Indirection.DIRECT);
                indirections.remove((Object)Indirection.OUTER);
                indirections.add(Indirection.INDIRECT);
            })));
        }

        public Optional<ExprRef> toDirect(Symbol.TypeSymbol directType) {
            return Optional.of(this).filter(ref -> ref.indirections.contains((Object)Indirection.INDIRECT)).map(ref -> new ExprRef(this.depth, directType, ref.modifiedIndirections(indirections -> {
                indirections.remove((Object)Indirection.OUTER);
                indirections.add(Indirection.DIRECT);
            })));
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ Integer.hashCode(this.depth);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            ExprRef that = (ExprRef)obj;
            return this.depth == that.depth;
        }

        @Override
        protected void addProperties(ArrayList<String> properties) {
            super.addProperties(properties);
            properties.add("depth=" + this.depth);
        }
    }

    private static class YieldRef
    extends Ref {
        YieldRef(Ref ref) {
            super(ref);
        }

        YieldRef(Symbol.TypeSymbol tsym, EnumSet<Indirection> indirections) {
            super(tsym, indirections);
        }

        @Override
        public YieldRef withType(Symbol.TypeSymbol tsym) {
            return new YieldRef(tsym, this.indirections);
        }
    }
}

