/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.mvndaemon.mvnd.common.DaemonException;
import org.mvndaemon.mvnd.common.DaemonExpirationStatus;
import org.mvndaemon.mvnd.common.DaemonInfo;
import org.mvndaemon.mvnd.common.DaemonState;
import org.mvndaemon.mvnd.common.DaemonStopEvent;
import org.mvndaemon.mvnd.common.Os;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaemonRegistry
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DaemonRegistry.class);
    private static final long LOCK_TIMEOUT_MS = 20000L;
    private static final Map<Path, Object> locks = new ConcurrentHashMap<Path, Object>();
    private final Path registryFile;
    private final Object lck;
    private final FileChannel channel;
    private final Map<String, DaemonInfo> infosMap = new HashMap<String, DaemonInfo>();
    private final List<DaemonStopEvent> stopEvents = new ArrayList<DaemonStopEvent>();
    private static final int PROCESS_ID = DaemonRegistry.getProcessId0();

    public DaemonRegistry(Path registryFile) {
        Path absPath = registryFile.toAbsolutePath().normalize();
        this.lck = locks.computeIfAbsent(absPath, p -> new Object());
        this.registryFile = absPath;
        try {
            Files.createDirectories(absPath.getParent(), new FileAttribute[0]);
            this.channel = FileChannel.open(absPath, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new DaemonException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            throw new DaemonException("Error closing registry", e);
        }
    }

    public Path getRegistryFile() {
        return this.registryFile;
    }

    public DaemonInfo get(String daemonId) {
        this.read();
        return this.infosMap.get(daemonId);
    }

    public List<DaemonInfo> getAll() {
        this.read();
        return new ArrayList<DaemonInfo>(this.infosMap.values());
    }

    public List<DaemonInfo> getIdle() {
        this.read();
        return this.infosMap.values().stream().filter(di -> di.getState() == DaemonState.Idle).collect(Collectors.toList());
    }

    public List<DaemonInfo> getNotIdle() {
        return this.infosMap.values().stream().filter(di -> di.getState() != DaemonState.Idle).collect(Collectors.toList());
    }

    public List<DaemonInfo> getCanceled() {
        this.read();
        return this.infosMap.values().stream().filter(di -> di.getState() == DaemonState.Canceled).collect(Collectors.toList());
    }

    public void remove(String daemonId) {
        this.update(() -> this.infosMap.remove(daemonId));
    }

    public void markState(String daemonId, DaemonState state) {
        LOGGER.debug("Marking busy by id: {}", (Object)daemonId);
        this.update(() -> this.infosMap.computeIfPresent(daemonId, (id, di) -> di.withState(state)));
    }

    public void storeStopEvent(DaemonStopEvent stopEvent) {
        LOGGER.debug("Storing daemon stop event with timestamp {}", (Object)stopEvent.getTimestamp());
        this.update(() -> this.stopEvents.add(stopEvent));
    }

    public List<DaemonStopEvent> getStopEvents() {
        this.read();
        return this.doGetDaemonStopEvents();
    }

    protected List<DaemonStopEvent> doGetDaemonStopEvents() {
        return new ArrayList<DaemonStopEvent>(this.stopEvents);
    }

    public void removeStopEvents(Collection<DaemonStopEvent> events) {
        LOGGER.debug("Removing {} daemon stop events from registry", (Object)events.size());
        this.update(() -> this.stopEvents.removeAll(events));
    }

    public void store(DaemonInfo info) {
        LOGGER.debug("Storing daemon {}", (Object)info);
        this.update(() -> this.infosMap.put(info.getId(), info));
    }

    public static int getProcessId() {
        return PROCESS_ID;
    }

    private void read() {
        this.doUpdate(null);
    }

    private void update(Runnable updater) {
        this.doUpdate(updater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(Runnable updater) {
        if (!Files.isReadable(this.registryFile)) {
            throw new DaemonException("Registry became unaccessible");
        }
        Object object = this.lck;
        synchronized (object) {
            try (FileLock l = this.tryLock();){
                String daemonId;
                int i;
                this.channel.position(0L);
                DataInputStream is = new DataInputStream(new BufferedInputStream(Channels.newInputStream(this.channel)));
                this.infosMap.clear();
                int nb = is.available() < 4 ? 0 : is.readInt();
                for (i = 0; i < nb; ++i) {
                    daemonId = is.readUTF();
                    String javaHome = is.readUTF();
                    String mavenHome = is.readUTF();
                    int pid = is.readInt();
                    String address = is.readUTF();
                    byte[] token = new byte[16];
                    is.read(token);
                    String locale = is.readUTF();
                    ArrayList<String> opts = new ArrayList<String>();
                    int nbOpts = is.readInt();
                    for (int j = 0; j < nbOpts; ++j) {
                        opts.add(is.readUTF());
                    }
                    DaemonState state = DaemonState.values()[is.readByte()];
                    long lastIdle = is.readLong();
                    long lastBusy = is.readLong();
                    DaemonInfo di = new DaemonInfo(daemonId, javaHome, mavenHome, pid, address, token, locale, opts, state, lastIdle, lastBusy);
                    this.infosMap.putIfAbsent(di.getId(), di);
                }
                this.stopEvents.clear();
                nb = is.available() < 4 ? 0 : is.readInt();
                for (i = 0; i < nb; ++i) {
                    daemonId = is.readUTF();
                    long date = is.readLong();
                    byte ord = is.readByte();
                    DaemonExpirationStatus des = ord >= 0 ? DaemonExpirationStatus.values()[ord] : null;
                    String reason = is.readUTF();
                    DaemonStopEvent se = new DaemonStopEvent(daemonId, date, des, reason);
                    this.stopEvents.add(se);
                }
                if (updater != null) {
                    updater.run();
                    this.channel.truncate(0L);
                    DataOutputStream os = new DataOutputStream(new BufferedOutputStream(Channels.newOutputStream(this.channel)));
                    os.writeInt(this.infosMap.size());
                    for (DaemonInfo di : this.infosMap.values()) {
                        String id = di.getId();
                        os.writeUTF(id);
                        os.writeUTF(di.getJavaHome());
                        os.writeUTF(di.getMvndHome());
                        os.writeInt(di.getPid());
                        os.writeUTF(di.getAddress());
                        os.write(di.getToken());
                        os.writeUTF(di.getLocale());
                        os.writeInt(di.getOptions().size());
                        for (String opt : di.getOptions()) {
                            os.writeUTF(opt);
                        }
                        os.writeByte((byte)di.getState().ordinal());
                        os.writeLong(di.getLastIdle());
                        os.writeLong(di.getLastBusy());
                    }
                    os.writeInt(this.stopEvents.size());
                    for (DaemonStopEvent dse : this.stopEvents) {
                        os.writeUTF(dse.getDaemonId());
                        os.writeLong(dse.getTimestamp());
                        os.writeByte((byte)(dse.getStatus() == null ? -1 : dse.getStatus().ordinal()));
                        os.writeUTF(dse.getReason());
                    }
                    os.flush();
                }
            }
            catch (DaemonException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.warn("Invalid daemon registry info at [{}], trying to recover.", (Object)this.registryFile, (Object)e);
                this.reset();
            }
        }
    }

    private FileLock tryLock() {
        try {
            long deadline = System.currentTimeMillis() + 20000L;
            while (System.currentTimeMillis() < deadline) {
                FileLock fileLock = this.channel.tryLock(0L, Long.MAX_VALUE, false);
                if (fileLock != null) {
                    return fileLock;
                }
                Thread.sleep(100L);
            }
            throw new DaemonException("Could not lock " + this.registryFile + " within " + 20000L + " ms");
        }
        catch (IOException | InterruptedException e) {
            throw new DaemonException("Could not lock " + this.registryFile, e);
        }
    }

    private void reset() {
        this.infosMap.clear();
        this.stopEvents.clear();
        try {
            this.channel.truncate(0L);
        }
        catch (IOException e) {
            LOGGER.error("Could not truncate [{}], please delete this file and try again.", (Object)this.registryFile, (Object)e);
        }
    }

    private static int getProcessId0() {
        String pid;
        block8: {
            if (Os.current() == Os.LINUX) {
                try {
                    Path self = Paths.get("/proc/self", new String[0]);
                    if (!Files.exists(self, new LinkOption[0])) break block8;
                    pid = self.toRealPath(new LinkOption[0]).getFileName().toString();
                    if (pid.equals("self")) {
                        LOGGER.debug("/proc/self symlink could not be followed");
                        break block8;
                    }
                    LOGGER.debug("loading own PID from /proc/self link: {}", (Object)pid);
                    try {
                        return Integer.parseInt(pid);
                    }
                    catch (NumberFormatException x) {
                        LOGGER.warn("Unable to determine PID from malformed /proc/self link `{}`", (Object)pid);
                    }
                }
                catch (IOException ignored) {
                    LOGGER.debug("could not load /proc/self", (Throwable)ignored);
                }
            }
        }
        String vmname = ManagementFactory.getRuntimeMXBean().getName();
        pid = vmname.split("@", 0)[0];
        LOGGER.debug("loading own PID from VM name: {}", (Object)pid);
        try {
            return Integer.parseInt(pid);
        }
        catch (NumberFormatException x) {
            int rpid = new Random().nextInt(65536);
            LOGGER.warn("Unable to determine PID from malformed VM name `{}`, picked a random number={}", (Object)vmname, (Object)rpid);
            return rpid;
        }
    }

    public String toString() {
        return String.format("DaemonRegistry[file=%s]", this.registryFile);
    }
}

