/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.shared;

import java.security.SecureRandom;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;

public class CsrfManager {
    public static final String CSRF_ATTR = "org.apache.chemistry.opencmis.csrftoken";
    private static final String CSRF_HEADER = "csrfHeader";
    private static final String CSRF_PARAMETER = "csrfParameter";
    private static final String FETCH_VALUE = "fetch";
    private static char[][] hexArrays = new char[][]{"0123456789ABCDEF".toCharArray(), "0123456789abcdef".toCharArray(), "ABCDEFGHIJKLMNOP".toCharArray(), "abcdefghijklmnop".toCharArray()};
    private String csrfHeader;
    private String csrfParameter;
    private SecureRandom random = new SecureRandom();

    public CsrfManager(String csrfHeader, String csrfParameter) {
        if (csrfHeader != null) {
            this.csrfHeader = csrfHeader.trim();
            if (this.csrfHeader.length() == 0) {
                throw new IllegalArgumentException("Invalid CSRF header!");
            }
            if (csrfParameter != null) {
                this.csrfParameter = csrfParameter.trim();
                if (this.csrfParameter.length() == 0) {
                    throw new IllegalArgumentException("Invalid CSRF parameter!");
                }
            }
        }
    }

    public CsrfManager(ServletConfig config) throws ServletException {
        this.csrfHeader = config.getInitParameter(CSRF_HEADER);
        if (this.csrfHeader != null) {
            this.csrfHeader = this.csrfHeader.trim();
            if (this.csrfHeader.length() == 0) {
                throw new ServletException("Invalid CSRF header!");
            }
            this.csrfParameter = config.getInitParameter(CSRF_PARAMETER);
            if (this.csrfParameter != null) {
                this.csrfParameter = this.csrfParameter.trim();
                if (this.csrfParameter.length() == 0) {
                    throw new ServletException("Invalid CSRF parameter!");
                }
            }
        }
    }

    public void check(HttpServletRequest req, HttpServletResponse resp, boolean isRepositoryInfoRequest, boolean isContentRequest) {
        if (this.csrfHeader == null) {
            return;
        }
        HttpSession httpSession = req.getSession(true);
        String token = (String)httpSession.getAttribute(CSRF_ATTR);
        String headerValue = req.getHeader(this.csrfHeader);
        if (headerValue == null || headerValue.isEmpty()) {
            String paramValue;
            if (isContentRequest && this.csrfParameter != null && (paramValue = req.getParameter(this.csrfParameter)) != null && paramValue.equals(token)) {
                return;
            }
            throw new CmisPermissionDeniedException("Invalid CSRF token!");
        }
        if (isRepositoryInfoRequest && FETCH_VALUE.equals(headerValue) && token == null) {
            token = this.generateNewToken();
            httpSession.setAttribute(CSRF_ATTR, (Object)token);
            resp.addHeader(this.csrfHeader, token);
            return;
        }
        if (token == null) {
            throw new CmisPermissionDeniedException("Invalid CSRF token!");
        }
        if (!token.equals(headerValue)) {
            throw new CmisPermissionDeniedException("Invalid CSRF token!");
        }
    }

    private String generateNewToken() {
        byte[] tokenBytes = new byte[16];
        this.random.nextBytes(tokenBytes);
        int ary = this.random.nextInt(hexArrays.length);
        char[] token = new char[tokenBytes.length * 2];
        for (int i = 0; i < tokenBytes.length; ++i) {
            int v = tokenBytes[i] & 0xFF;
            token[i * 2] = hexArrays[ary][v >>> 4];
            token[i * 2 + 1] = hexArrays[ary][v & 0xF];
        }
        return new String(token);
    }
}

