/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.chemistry.opencmis.commons.definitions.MutableDocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableItemTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutablePolicyTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableRelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableSecondaryTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ChoiceImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriDefinitionImpl;
import org.apache.chemistry.opencmis.inmemory.TypeCreator;
import org.apache.chemistry.opencmis.inmemory.types.DocumentTypeCreationHelper;
import org.apache.chemistry.opencmis.inmemory.types.PropertyCreationHelper;
import org.apache.chemistry.opencmis.server.support.TypeDefinitionFactory;

public class DefaultTypeSystemCreator
implements TypeCreator {
    private static final String BUILTIN_IN_MEMORY_TYPE_DEFINITION_DESCR = "Builtin InMemory type definition ";
    public static final List<TypeDefinition> SINGLETON_TYPES = DefaultTypeSystemCreator.buildTypesList();
    public static final String COMPLEX_TYPE = "ComplexType";
    public static final String TOPLEVEL_TYPE = "DocumentTopLevel";
    public static final String VERSIONED_TYPE = "VersionableType";
    public static final String ITEM_TYPE = "MyItemType";
    public static final String LEVEL1_TYPE = "DocumentLevel1";
    public static final String LEVEL2_TYPE = "DocumentLevel2";
    public static final String SECONDARY_TYPE_ID = "MySecondaryType";
    public static final String BIG_CONTENT_FAKE_TYPE = "BigContentFakeType";

    @Override
    public List<TypeDefinition> createTypesList() {
        return SINGLETON_TYPES;
    }

    public static List<TypeDefinition> getTypesList() {
        return SINGLETON_TYPES;
    }

    public static TypeDefinition getTypeById(String typeId) {
        for (TypeDefinition typeDef : SINGLETON_TYPES) {
            if (!typeDef.getId().equals(typeId)) continue;
            return typeDef;
        }
        return null;
    }

    private static List<TypeDefinition> buildTypesList() {
        TypeDefinitionFactory typeFactory = DocumentTypeCreationHelper.getTypeDefinitionFactory();
        LinkedList<TypeDefinition> typesList = new LinkedList<TypeDefinition>();
        try {
            MutableDocumentTypeDefinition cmisType1 = typeFactory.createDocumentTypeDefinition(CmisVersion.CMIS_1_1, DocumentTypeCreationHelper.getCmisDocumentType().getId());
            cmisType1.setId("MyDocType1");
            cmisType1.setDisplayName("My Type 1 Level 1");
            cmisType1.setDescription("Builtin InMemory type definition MyDocType1");
            typesList.add((TypeDefinition)cmisType1);
            MutableDocumentTypeDefinition cmisType2 = typeFactory.createDocumentTypeDefinition(CmisVersion.CMIS_1_1, DocumentTypeCreationHelper.getCmisDocumentType().getId());
            cmisType2.setId("MyDocType2");
            cmisType2.setDisplayName("My Type 2 Level 1");
            cmisType2.setDescription("Builtin InMemory type definition MyDocType2");
            typesList.add((TypeDefinition)cmisType2);
            MutableTypeDefinition cmisType11 = typeFactory.createChildTypeDefinition((TypeDefinition)cmisType1, "MyDocType1.1");
            cmisType11.setDisplayName("My Type 3 Level 2");
            cmisType11.setDescription("Builtin InMemory type definition MyDocType1.1");
            typesList.add((TypeDefinition)cmisType11);
            MutableTypeDefinition cmisType111 = typeFactory.createChildTypeDefinition((TypeDefinition)cmisType11, "MyDocType1.1.1");
            cmisType111.setDisplayName("My Type 4 Level 3");
            cmisType111.setDescription("Builtin InMemory type definition MyDocType1.1.1");
            typesList.add((TypeDefinition)cmisType111);
            MutableTypeDefinition cmisType112 = typeFactory.createChildTypeDefinition((TypeDefinition)cmisType11, "MyDocType1.1.2");
            cmisType112.setId("MyDocType1.1.2");
            cmisType112.setDisplayName("My Type 5 Level 3");
            cmisType112.setDescription("Builtin InMemory type definition MyDocType1.1.2");
            typesList.add((TypeDefinition)cmisType112);
            MutableTypeDefinition cmisType12 = typeFactory.createChildTypeDefinition((TypeDefinition)cmisType1, "MyDocType1.2");
            cmisType12.setDisplayName("My Type 6 Level 2");
            cmisType12.setDescription("Builtin InMemory type definition MyDocType1.2");
            typesList.add((TypeDefinition)cmisType12);
            MutableTypeDefinition cmisType21 = typeFactory.createChildTypeDefinition((TypeDefinition)cmisType2, "MyDocType2.1");
            cmisType21.setDisplayName("My Type 7 Level 2");
            cmisType21.setDescription("Builtin InMemory type definition MyDocType2.1");
            typesList.add((TypeDefinition)cmisType21);
            MutableTypeDefinition cmisType22 = typeFactory.createChildTypeDefinition((TypeDefinition)cmisType2, "MyDocType2.2");
            cmisType22.setDisplayName("My Type 8 Level 2");
            cmisType22.setDescription("Builtin InMemory type definition MyDocType2.2");
            typesList.add((TypeDefinition)cmisType22);
            MutableTypeDefinition cmisType23 = typeFactory.createChildTypeDefinition((TypeDefinition)cmisType2, "MyDocType2.3");
            cmisType23.setDisplayName("My Type 9 Level 2");
            cmisType23.setDescription("Builtin InMemory type definition MyDocType2.3");
            typesList.add((TypeDefinition)cmisType23);
            MutableTypeDefinition cmisType24 = typeFactory.createChildTypeDefinition((TypeDefinition)cmisType2, "MyDocType2.4");
            cmisType24.setDisplayName("My Type 10 Level 2");
            cmisType24.setDescription("Builtin InMemory type definition MyDocType2.4");
            typesList.add((TypeDefinition)cmisType24);
            MutableTypeDefinition cmisType25 = typeFactory.createChildTypeDefinition((TypeDefinition)cmisType2, "MyDocType2.5");
            cmisType25.setDisplayName("My Type 11 Level 2");
            cmisType25.setDescription("Builtin InMemory type definition MyDocType2.5");
            typesList.add((TypeDefinition)cmisType25);
            MutableTypeDefinition cmisType26 = typeFactory.createChildTypeDefinition((TypeDefinition)cmisType2, "MyDocType2.6");
            cmisType26.setDisplayName("My Type 12 Level 2");
            cmisType26.setDescription("Builtin InMemory type definition MyDocType2.6");
            typesList.add((TypeDefinition)cmisType26);
            MutableTypeDefinition cmisType27 = typeFactory.createChildTypeDefinition((TypeDefinition)cmisType2, "MyDocType2.7");
            cmisType27.setDisplayName("My Type 13 Level 2");
            cmisType27.setDescription("Builtin InMemory type definition MyDocType2.7");
            typesList.add((TypeDefinition)cmisType27);
            MutableTypeDefinition cmisType28 = typeFactory.createChildTypeDefinition((TypeDefinition)cmisType2, "MyDocType2.8");
            cmisType28.setDisplayName("My Type 14 Level 2");
            cmisType28.setDescription("Builtin InMemory type definition MyDocType2.8");
            typesList.add((TypeDefinition)cmisType28);
            MutableTypeDefinition cmisType29 = typeFactory.createChildTypeDefinition((TypeDefinition)cmisType2, "MyDocType2.9");
            cmisType29.setDisplayName("My Type 15 Level 2");
            cmisType29.setDescription("Builtin InMemory type definition MyDocType2.9");
            typesList.add((TypeDefinition)cmisType29);
            MutableDocumentTypeDefinition cmisComplexType = typeFactory.createDocumentTypeDefinition(CmisVersion.CMIS_1_1, DocumentTypeCreationHelper.getCmisDocumentType().getId());
            cmisComplexType.setId(COMPLEX_TYPE);
            cmisComplexType.setDisplayName("Complex type with properties, Level 1");
            cmisComplexType.setDescription("Builtin InMemory type definition ComplexType");
            PropertyBooleanDefinitionImpl prop = PropertyCreationHelper.createBooleanDefinition("BooleanProp", "Sample Boolean Property", Updatability.READWRITE);
            cmisComplexType.addPropertyDefinition((PropertyDefinition)prop);
            prop = PropertyCreationHelper.createBooleanMultiDefinition("BooleanPropMV", "Sample Boolean multi-value Property", Updatability.READWRITE);
            cmisComplexType.addPropertyDefinition((PropertyDefinition)prop);
            PropertyDateTimeDefinitionImpl prop2 = PropertyCreationHelper.createDateTimeDefinition("DateTimeProp", "Sample DateTime Property", Updatability.READWRITE);
            cmisComplexType.addPropertyDefinition((PropertyDefinition)prop2);
            prop2 = PropertyCreationHelper.createDateTimeMultiDefinition("DateTimePropMV", "Sample DateTime multi-value Property", Updatability.READWRITE);
            cmisComplexType.addPropertyDefinition((PropertyDefinition)prop2);
            PropertyDecimalDefinitionImpl prop3 = PropertyCreationHelper.createDecimalDefinition("DecimalProp", "Sample Decimal Property", Updatability.READWRITE);
            cmisComplexType.addPropertyDefinition((PropertyDefinition)prop3);
            prop3 = PropertyCreationHelper.createDecimalMultiDefinition("DecimalPropMV", "Sample Decimal multi-value Property", Updatability.READWRITE);
            cmisComplexType.addPropertyDefinition((PropertyDefinition)prop3);
            PropertyHtmlDefinitionImpl prop4 = PropertyCreationHelper.createHtmlDefinition("HtmlProp", "Sample Html Property", Updatability.READWRITE);
            cmisComplexType.addPropertyDefinition((PropertyDefinition)prop4);
            prop4 = PropertyCreationHelper.createHtmlMultiDefinition("HtmlPropMV", "Sample Html multi-value Property", Updatability.READWRITE);
            cmisComplexType.addPropertyDefinition((PropertyDefinition)prop4);
            PropertyIdDefinitionImpl prop5 = PropertyCreationHelper.createIdDefinition("IdProp", "Sample Id Property", Updatability.READWRITE);
            cmisComplexType.addPropertyDefinition((PropertyDefinition)prop5);
            prop5 = PropertyCreationHelper.createIdMultiDefinition("IdPropMV", "Sample Id Html multi-value Property", Updatability.READWRITE);
            cmisComplexType.addPropertyDefinition((PropertyDefinition)prop5);
            PropertyIntegerDefinitionImpl prop6 = PropertyCreationHelper.createIntegerDefinition("IntProp", "Sample Int Property", Updatability.READWRITE);
            cmisComplexType.addPropertyDefinition((PropertyDefinition)prop6);
            prop6 = PropertyCreationHelper.createIntegerMultiDefinition("IntPropMV", "Sample Int multi-value Property", Updatability.READWRITE);
            cmisComplexType.addPropertyDefinition((PropertyDefinition)prop6);
            PropertyStringDefinitionImpl prop7 = PropertyCreationHelper.createStringDefinition("StringProp", "Sample String Property", Updatability.READWRITE);
            cmisComplexType.addPropertyDefinition((PropertyDefinition)prop7);
            PropertyUriDefinitionImpl prop8 = PropertyCreationHelper.createUriDefinition("UriProp", "Sample Uri Property", Updatability.READWRITE);
            cmisComplexType.addPropertyDefinition((PropertyDefinition)prop8);
            prop8 = PropertyCreationHelper.createUriMultiDefinition("UriPropMV", "Sample Uri multi-value Property", Updatability.READWRITE);
            cmisComplexType.addPropertyDefinition((PropertyDefinition)prop8);
            PropertyStringDefinitionImpl prop9 = PropertyCreationHelper.createStringDefinition("PickListProp", "Sample Pick List Property", Updatability.READWRITE);
            ArrayList<ChoiceImpl> choiceList = new ArrayList<ChoiceImpl>();
            ChoiceImpl elem = new ChoiceImpl();
            elem.setValue(Collections.singletonList("red"));
            choiceList.add(elem);
            elem = new ChoiceImpl();
            elem.setValue(Collections.singletonList("green"));
            choiceList.add(elem);
            elem = new ChoiceImpl();
            elem.setValue(Collections.singletonList("blue"));
            choiceList.add(elem);
            elem = new ChoiceImpl();
            elem.setValue(Collections.singletonList("black"));
            choiceList.add(elem);
            prop9.setChoices(choiceList);
            prop9.setDefaultValue(Collections.singletonList("blue"));
            cmisComplexType.addPropertyDefinition((PropertyDefinition)prop9);
            typesList.add((TypeDefinition)cmisComplexType);
            MutableDocumentTypeDefinition cmisDocTypeTopLevel = typeFactory.createDocumentTypeDefinition(CmisVersion.CMIS_1_1, DocumentTypeCreationHelper.getCmisDocumentType().getId());
            cmisDocTypeTopLevel.setId(TOPLEVEL_TYPE);
            cmisDocTypeTopLevel.setDisplayName("Document type with properties, Level 1");
            cmisDocTypeTopLevel.setDescription("Builtin InMemory type definition DocumentTopLevel");
            MutableTypeDefinition cmisDocTypeLevel1 = typeFactory.createChildTypeDefinition((TypeDefinition)cmisDocTypeTopLevel, LEVEL1_TYPE);
            cmisDocTypeLevel1.setDisplayName("Document type with inherited properties, Level 2");
            cmisDocTypeLevel1.setDescription("Builtin InMemory type definition DocumentLevel1");
            MutableTypeDefinition cmisDocTypeLevel2 = typeFactory.createChildTypeDefinition((TypeDefinition)cmisDocTypeLevel1, LEVEL2_TYPE);
            cmisDocTypeLevel2.setDisplayName("Document type with inherited properties, Level 3");
            cmisDocTypeLevel2.setDescription("Builtin InMemory type definition DocumentLevel2");
            PropertyStringDefinitionImpl propTop = PropertyCreationHelper.createStringDefinition("StringPropTopLevel", "Sample String Property", Updatability.READWRITE);
            cmisDocTypeTopLevel.addPropertyDefinition((PropertyDefinition)propTop);
            PropertyStringDefinitionImpl propLevel1 = PropertyCreationHelper.createStringDefinition("StringPropLevel1", "String Property Level 1", Updatability.READWRITE);
            cmisDocTypeLevel1.addPropertyDefinition((PropertyDefinition)propLevel1);
            PropertyStringDefinitionImpl propLevel2 = PropertyCreationHelper.createStringDefinition("StringPropLevel2", "String Property Level 2", Updatability.READWRITE);
            cmisDocTypeLevel2.addPropertyDefinition((PropertyDefinition)propLevel2);
            typesList.add((TypeDefinition)cmisDocTypeTopLevel);
            typesList.add((TypeDefinition)cmisDocTypeLevel1);
            typesList.add((TypeDefinition)cmisDocTypeLevel2);
            MutableDocumentTypeDefinition cmisVersionedType = typeFactory.createDocumentTypeDefinition(CmisVersion.CMIS_1_1, DocumentTypeCreationHelper.getCmisDocumentType().getId());
            cmisVersionedType.setId(VERSIONED_TYPE);
            cmisVersionedType.setDisplayName("Versioned Type");
            cmisVersionedType.setDescription("Builtin InMemory type definition VersionableType");
            cmisVersionedType.setIsVersionable(Boolean.valueOf(true));
            PropertyStringDefinitionImpl prop1 = PropertyCreationHelper.createStringDefinition("VersionedStringProp", "Sample String Property", Updatability.WHENCHECKEDOUT);
            cmisVersionedType.addPropertyDefinition((PropertyDefinition)prop1);
            typesList.add((TypeDefinition)cmisVersionedType);
            MutableItemTypeDefinition itemType = typeFactory.createItemTypeDefinition(CmisVersion.CMIS_1_1, DocumentTypeCreationHelper.getCmisItemType().getId());
            itemType.setId(ITEM_TYPE);
            itemType.setDisplayName(ITEM_TYPE);
            itemType.setDescription("Builtin InMemory type definition MyItemType");
            DocumentTypeCreationHelper.setDefaultTypeCapabilities((MutableTypeDefinition)itemType);
            prop1 = PropertyCreationHelper.createStringDefinition("ItemStringProp", "Item String Property", Updatability.READWRITE);
            itemType.addPropertyDefinition((PropertyDefinition)prop1);
            typesList.add((TypeDefinition)itemType);
            MutableSecondaryTypeDefinition cmisSecondaryType = typeFactory.createSecondaryTypeDefinition(CmisVersion.CMIS_1_1, DocumentTypeCreationHelper.getCmisSecondaryType().getId());
            cmisSecondaryType.setId(SECONDARY_TYPE_ID);
            cmisSecondaryType.setDisplayName(SECONDARY_TYPE_ID);
            cmisSecondaryType.setDescription("Builtin InMemory type definition MySecondaryType");
            DocumentTypeCreationHelper.setDefaultTypeCapabilities((MutableTypeDefinition)cmisSecondaryType);
            cmisSecondaryType.setIsCreatable(Boolean.valueOf(false));
            cmisSecondaryType.setIsFileable(Boolean.valueOf(false));
            PropertyStringDefinitionImpl propS1 = PropertyCreationHelper.createStringDefinition("SecondaryStringProp", "Secondary String Property", Updatability.READWRITE);
            cmisSecondaryType.addPropertyDefinition((PropertyDefinition)propS1);
            PropertyIntegerDefinitionImpl propS2 = PropertyCreationHelper.createIntegerDefinition("SecondaryIntegerProp", "Secondary Integer Property", Updatability.READWRITE);
            propS2.setIsRequired(Boolean.valueOf(true));
            cmisSecondaryType.addPropertyDefinition((PropertyDefinition)propS2);
            typesList.add((TypeDefinition)cmisSecondaryType);
            MutableRelationshipTypeDefinition relType = typeFactory.createRelationshipTypeDefinition(CmisVersion.CMIS_1_1, DocumentTypeCreationHelper.getCmisRelationshipType().getId());
            relType.setId("CrossReferenceType");
            relType.setDisplayName("CrossReferenceType");
            relType.setDescription("Builtin InMemory type definition CrossReferenceType");
            DocumentTypeCreationHelper.setDefaultTypeCapabilities((MutableTypeDefinition)relType);
            relType.setIsFileable(Boolean.valueOf(false));
            prop1 = PropertyCreationHelper.createStringDefinition("CrossReferenceKind", "CrossReferenceType", Updatability.READWRITE);
            relType.addPropertyDefinition((PropertyDefinition)prop1);
            typesList.add((TypeDefinition)relType);
            MutablePolicyTypeDefinition polType = typeFactory.createPolicyTypeDefinition(CmisVersion.CMIS_1_1, DocumentTypeCreationHelper.getCmisPolicyType().getId());
            polType.setId("AuditPolicy");
            polType.setDisplayName("Audit Policy");
            polType.setDescription("Builtin InMemory type definition AuditPolicy");
            DocumentTypeCreationHelper.setDefaultTypeCapabilities((MutableTypeDefinition)polType);
            polType.setIsFileable(Boolean.valueOf(false));
            prop1 = PropertyCreationHelper.createStringDefinition("AuditSettings", "Audit Kind Property", Updatability.READWRITE);
            polType.addPropertyDefinition((PropertyDefinition)prop1);
            typesList.add((TypeDefinition)polType);
            MutableDocumentTypeDefinition cmisTypeFake = typeFactory.createDocumentTypeDefinition(CmisVersion.CMIS_1_1, DocumentTypeCreationHelper.getCmisDocumentType().getId());
            cmisTypeFake.setId(BIG_CONTENT_FAKE_TYPE);
            cmisTypeFake.setDisplayName(BIG_CONTENT_FAKE_TYPE);
            cmisTypeFake.setDescription("Builtin InMemory type definition for big content streams. Content is ignored and replaced by random bytes");
            typesList.add((TypeDefinition)cmisTypeFake);
            return typesList;
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error when creating built-in InMemory types.", (Throwable)e);
        }
    }
}

