/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.meridio;

import com.meridio.www.MeridioDMWS.DmLogicalOp;
import com.meridio.www.MeridioDMWS.DmPermission;
import com.meridio.www.MeridioDMWS.DmSearchScope;
import com.meridio.www.MeridioDMWS.DmVersionInfo;
import com.meridio.www.MeridioDMWS.GetCategoriesWTResponseGetCategoriesWTResult;
import com.meridio.www.MeridioDMWS.GetContainerDataWTResponseGetContainerDataWTResult;
import com.meridio.www.MeridioDMWS.GetDocumentDataWTResponseGetDocumentDataWTResult;
import com.meridio.www.MeridioDMWS.GetStaticDataWTResponseGetStaticDataWTResult;
import com.meridio.www.MeridioDMWS.GetUserDataWTResponseGetUserDataWTResult;
import com.meridio.www.MeridioDMWS.MeridioDMLocator;
import com.meridio.www.MeridioDMWS.MeridioDMSoapStub;
import com.meridio.www.MeridioDMWS.SearchDocumentsWTSearchInfo;
import com.meridio.www.MeridioDMWS.SearchRecordsWTSearchInfo;
import com.meridio.www.MeridioDMWS.SearchUsersWTSearchInfo;
import com.meridio.www.MeridioDMWS.holders.SearchDocumentsWTResponseSearchDocumentsWTResultHolder;
import com.meridio.www.MeridioDMWS.holders.SearchRecordsWTResponseSearchRecordsWTResultHolder;
import com.meridio.www.MeridioDMWS.holders.SearchUsersWTResponseSearchUsersWTResultHolder;
import com.meridio.www.MeridioRMWS.GetClassContentsWTResponseGetClassContentsWTResult;
import com.meridio.www.MeridioRMWS.GetConfigurationResponseGetConfigurationResult;
import com.meridio.www.MeridioRMWS.GetDocumentPartListWTResponseGetDocumentPartListWTResult;
import com.meridio.www.MeridioRMWS.GetFolderWTResponseGetFolderWTResult;
import com.meridio.www.MeridioRMWS.GetPropertyDefsResponseGetPropertyDefsResult;
import com.meridio.www.MeridioRMWS.GetProtectiveMarkingListWTResponseGetProtectiveMarkingListWTResult;
import com.meridio.www.MeridioRMWS.GetRecordPartListWTResponseGetRecordPartListWTResult;
import com.meridio.www.MeridioRMWS.GetRecordWTResponseGetRecordWTResult;
import com.meridio.www.MeridioRMWS.GetRolesAndMembershipWTResponseGetRolesAndMembershipWTResult;
import com.meridio.www.MeridioRMWS.GetUserPrivilegeListWTResponseGetUserPrivilegeListWTResult;
import com.meridio.www.MeridioRMWS.MeridioRMLocator;
import com.meridio.www.MeridioRMWS.MeridioRMSoapStub;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.Service;
import javax.xml.rpc.holders.BooleanHolder;
import org.apache.axis.AxisEngine;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.deployment.wsdd.WSDDGlobalConfiguration;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.holders.UnsignedIntHolder;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.UnsignedInt;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.log4j.Logger;
import org.apache.manifoldcf.crawler.connectors.meridio.DMDataSet.DMDataSet;
import org.apache.manifoldcf.crawler.connectors.meridio.DMDataSet.PROPERTY_OPS;
import org.apache.manifoldcf.crawler.connectors.meridio.DMDataSet.PROPERTY_TERMS;
import org.apache.manifoldcf.crawler.connectors.meridio.DMDataSet.RESULTDEFS;
import org.apache.manifoldcf.crawler.connectors.meridio.RMDataSet.RMDataSet;
import org.apache.manifoldcf.crawler.connectors.meridio.RMDataSet.Rm2vClass;
import org.apache.manifoldcf.crawler.connectors.meridio.RMDataSet.Rm2vFolder;
import org.apache.manifoldcf.meridio.DMSearchResults;
import org.apache.manifoldcf.meridio.MeridioDataSetException;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.tempuri.GroupResult;
import org.tempuri.MetaCartaLocator;
import org.tempuri.MetaCartaSoapStub;
import org.tempuri.holders.ArrayOfGroupResultHolder;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MeridioWrapper {
    public static final String HTTPCLIENT_PROPERTY = "ManifoldCF_HttpClient";
    private static String currentHost = null;
    protected long meridioCategoriesTime = -1L;
    protected DMDataSet meridioCategories_ = null;
    protected static final long meridioCategoriesExpire = 300000L;
    protected long meridioStaticDataTime = -1L;
    protected DMDataSet meridioStaticData_ = null;
    protected static final long meridioStaticDataExpire = 300000L;
    protected EngineConfiguration engineConfiguration = null;
    protected Logger oLog = null;
    protected String clientWorkstation = null;
    protected HttpClientConnectionManager dmwsConnectionManager = null;
    protected HttpClientConnectionManager rmwsConnectionManager = null;
    protected HttpClientConnectionManager mcwsConnectionManager = null;
    protected HttpClient dmwsHttpClient = null;
    protected HttpClient rmwsHttpClient = null;
    protected HttpClient mcwsHttpClient = null;
    protected MeridioDMSoapStub meridioDMWebService_ = null;
    protected MeridioRMSoapStub meridioRMWebService_ = null;
    protected MetaCartaSoapStub meridioMCWS_ = null;
    protected String loginToken_ = null;

    public MeridioDMSoapStub getDMWebService() {
        return this.meridioDMWebService_;
    }

    public MeridioRMSoapStub getRMWebService() {
        return this.meridioRMWebService_;
    }

    public MetaCartaSoapStub getMCWSWebService() {
        return this.meridioMCWS_;
    }

    public String getLoginToken() {
        return this.loginToken_;
    }

    public void clearCache() {
        this.meridioCategories_ = null;
        this.meridioStaticData_ = null;
    }

    public MeridioWrapper(Logger log, URL meridioDmwsUrl, URL meridioRmwsUrl, URL meridioManifoldCFWSUrl, String dmwsProxyHost, String dmwsProxyPort, String rmwsProxyHost, String rmwsProxyPort, String mcwsProxyHost, String mcwsProxyPort, String userName, String password, String clientWorkstation, SSLSocketFactory mySSLFactory, Class resourceClass, String engineConfigurationFile) throws RemoteException, NumberFormatException {
        HttpHost proxy;
        int port;
        String domain;
        String domainUser;
        this.oLog = log;
        this.engineConfiguration = new ResourceProvider(resourceClass, engineConfigurationFile);
        this.clientWorkstation = clientWorkstation;
        SSLConnectionSocketFactory myFactory = null;
        myFactory = mySSLFactory != null ? new SSLConnectionSocketFactory(mySSLFactory, (HostnameVerifier)new NoopHostnameVerifier()) : SSLConnectionSocketFactory.getSocketFactory();
        int index = userName.indexOf("\\");
        if (index != -1) {
            domainUser = userName.substring(index + 1);
            domain = userName.substring(0, index);
            if (this.oLog != null && this.oLog.isDebugEnabled()) {
                this.oLog.debug((Object)("Meridio: User is '" + domainUser + "', domain is '" + domain + "'"));
            }
        } else {
            domain = null;
            domainUser = userName;
            if (this.oLog != null && this.oLog.isDebugEnabled()) {
                this.oLog.debug((Object)("Meridio: User is '" + domainUser + "'; there is no domain specified"));
            }
        }
        if (this.oLog != null && this.oLog.isDebugEnabled()) {
            if (password != null && password.length() > 0) {
                this.oLog.debug((Object)"Meridio: Password exists");
            } else {
                this.oLog.debug((Object)"Meridio: Password is null");
            }
        }
        int socketTimeout = 900000;
        int connectionTimeout = 300000;
        PoolingHttpClientConnectionManager poolingDmwsConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)myFactory).build());
        poolingDmwsConnectionManager.setDefaultMaxPerRoute(1);
        poolingDmwsConnectionManager.setValidateAfterInactivity(2000);
        poolingDmwsConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(socketTimeout).build());
        this.dmwsConnectionManager = poolingDmwsConnectionManager;
        PoolingHttpClientConnectionManager poolingRmwsConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)myFactory).build());
        poolingRmwsConnectionManager.setDefaultMaxPerRoute(1);
        poolingRmwsConnectionManager.setValidateAfterInactivity(2000);
        poolingRmwsConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(socketTimeout).build());
        this.rmwsConnectionManager = poolingRmwsConnectionManager;
        PoolingHttpClientConnectionManager poolingMcwsConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)myFactory).build());
        poolingMcwsConnectionManager.setDefaultMaxPerRoute(1);
        poolingMcwsConnectionManager.setValidateAfterInactivity(2000);
        poolingMcwsConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(socketTimeout).build());
        this.mcwsConnectionManager = poolingMcwsConnectionManager;
        BasicCredentialsProvider dmwsCredentialsProvider = new BasicCredentialsProvider();
        BasicCredentialsProvider rmwsCredentialsProvider = new BasicCredentialsProvider();
        RequestConfig.Builder dmwsRequestBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(socketTimeout).setExpectContinueEnabled(false).setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(socketTimeout);
        RequestConfig.Builder rmwsRequestBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(socketTimeout).setExpectContinueEnabled(true).setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(socketTimeout);
        if (domainUser != null) {
            dmwsCredentialsProvider.setCredentials(new AuthScope(meridioDmwsUrl.getHost(), meridioDmwsUrl.getPort()), (Credentials)new NTCredentials(domainUser, password, currentHost, domain));
            rmwsCredentialsProvider.setCredentials(new AuthScope(meridioRmwsUrl.getHost(), meridioRmwsUrl.getPort()), (Credentials)new NTCredentials(domainUser, password, currentHost, domain));
        }
        if (dmwsProxyHost != null && dmwsProxyHost.length() > 0) {
            int n = port = dmwsProxyPort == null || dmwsProxyPort.length() == 0 ? 8080 : Integer.parseInt(dmwsProxyPort);
            if (domainUser != null && domainUser.length() > 0) {
                dmwsCredentialsProvider.setCredentials(new AuthScope(dmwsProxyHost, port), (Credentials)new NTCredentials(domainUser, password, currentHost, domain));
            }
            proxy = new HttpHost(dmwsProxyHost, port);
            dmwsRequestBuilder.setProxy(proxy);
        }
        if (rmwsProxyHost != null && rmwsProxyHost.length() > 0) {
            int n = port = rmwsProxyPort == null || rmwsProxyPort.length() == 0 ? 8080 : Integer.parseInt(rmwsProxyPort);
            if (domainUser != null && domainUser.length() > 0) {
                rmwsCredentialsProvider.setCredentials(new AuthScope(rmwsProxyHost, port), (Credentials)new NTCredentials(domainUser, password, currentHost, domain));
            }
            proxy = new HttpHost(rmwsProxyHost, port);
            rmwsRequestBuilder.setProxy(proxy);
        }
        this.dmwsHttpClient = HttpClients.custom().setConnectionManager(this.dmwsConnectionManager).disableAutomaticRetries().setDefaultRequestConfig(dmwsRequestBuilder.build()).setDefaultCredentialsProvider((CredentialsProvider)dmwsCredentialsProvider).setRequestExecutor(new HttpRequestExecutor(socketTimeout)).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        this.rmwsHttpClient = HttpClients.custom().setConnectionManager(this.rmwsConnectionManager).disableAutomaticRetries().setDefaultRequestConfig(rmwsRequestBuilder.build()).setDefaultCredentialsProvider((CredentialsProvider)rmwsCredentialsProvider).setRequestExecutor(new HttpRequestExecutor(socketTimeout)).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        if (meridioManifoldCFWSUrl != null) {
            BasicCredentialsProvider mcwsCredentialsProvider = new BasicCredentialsProvider();
            RequestConfig.Builder mcwsRequestBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(socketTimeout).setExpectContinueEnabled(true).setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(socketTimeout);
            if (domainUser != null) {
                mcwsCredentialsProvider.setCredentials(new AuthScope(meridioManifoldCFWSUrl.getHost(), meridioManifoldCFWSUrl.getPort()), (Credentials)new NTCredentials(domainUser, password, currentHost, domain));
            }
            if (mcwsProxyHost != null && mcwsProxyHost.length() > 0) {
                int port2;
                int n = port2 = mcwsProxyPort == null || mcwsProxyPort.length() == 0 ? 8080 : Integer.parseInt(mcwsProxyPort);
                if (domainUser != null && domainUser.length() > 0) {
                    mcwsCredentialsProvider.setCredentials(new AuthScope(mcwsProxyHost, port2), (Credentials)new NTCredentials(domainUser, password, currentHost, domain));
                }
                HttpHost proxy2 = new HttpHost(mcwsProxyHost, port2);
                mcwsRequestBuilder.setProxy(proxy2);
            }
            this.mcwsHttpClient = HttpClients.custom().setConnectionManager(this.mcwsConnectionManager).disableAutomaticRetries().setDefaultRequestConfig(mcwsRequestBuilder.build()).setDefaultCredentialsProvider((CredentialsProvider)mcwsCredentialsProvider).setRequestExecutor(new HttpRequestExecutor(socketTimeout)).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        }
        MeridioDMLocator meridioDMLocator = new MeridioDMLocator(this.engineConfiguration);
        MeridioDMSoapStub meridioDMWebService = new MeridioDMSoapStub(meridioDmwsUrl, meridioDMLocator);
        meridioDMWebService.setPortName(meridioDMLocator.getMeridioDMSoapWSDDServiceName());
        meridioDMWebService.setUsername(userName);
        meridioDMWebService.setPassword(password);
        meridioDMWebService._setProperty(HTTPCLIENT_PROPERTY, this.dmwsHttpClient);
        this.meridioDMWebService_ = meridioDMWebService;
        MeridioRMLocator meridioRMLocator = new MeridioRMLocator(this.engineConfiguration);
        MeridioRMSoapStub meridioRMWebService = new MeridioRMSoapStub(meridioRmwsUrl, meridioRMLocator);
        meridioRMWebService.setPortName(meridioRMLocator.getMeridioRMSoapWSDDServiceName());
        meridioRMWebService.setUsername(userName);
        meridioRMWebService.setPassword(password);
        meridioRMWebService._setProperty(HTTPCLIENT_PROPERTY, this.rmwsHttpClient);
        this.meridioRMWebService_ = meridioRMWebService;
        if (meridioManifoldCFWSUrl != null) {
            MetaCartaLocator meridioMCWS = new MetaCartaLocator(this.engineConfiguration);
            Service McWsService = null;
            MetaCartaSoapStub meridioMetaCartaWebService = new MetaCartaSoapStub(meridioManifoldCFWSUrl, McWsService);
            meridioMetaCartaWebService.setPortName(meridioMCWS.getMetaCartaSoapWSDDServiceName());
            meridioMetaCartaWebService.setUsername(userName);
            meridioMetaCartaWebService.setPassword(password);
            meridioMetaCartaWebService._setProperty(HTTPCLIENT_PROPERTY, this.mcwsHttpClient);
            this.meridioMCWS_ = meridioMetaCartaWebService;
        }
        this.loginUnified();
    }

    public void loginUnified() throws RemoteException {
        if (this.loginToken_ == null) {
            if (this.oLog != null) {
                this.oLog.debug((Object)"Meridio: Calling Meridio Login Web Service");
            }
            String loginToken = this.meridioDMWebService_.loginUnified(this.clientWorkstation);
            if (this.oLog != null && this.oLog.isDebugEnabled()) {
                this.oLog.debug((Object)("Meridio: Successfully logged in - Login Token is '" + loginToken + "'"));
            }
            this.loginToken_ = loginToken;
            if (this.oLog != null) {
                this.oLog.debug((Object)"Meridio: Exiting login method");
            }
        }
    }

    public void logout() throws RemoteException {
        if (this.loginToken_ != null) {
            try {
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Logging out of Meridio");
                }
                this.meridioDMWebService_.logout(this.loginToken_);
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Successfully logged out of Meridio");
                }
            }
            finally {
                this.loginToken_ = null;
                this.dmwsConnectionManager.shutdown();
                this.dmwsConnectionManager = null;
                this.rmwsConnectionManager.shutdown();
                this.rmwsConnectionManager = null;
                this.mcwsConnectionManager.shutdown();
                this.mcwsConnectionManager = null;
            }
        }
    }

    public GroupResult[] getUsersGroups(int userId) throws RemoteException {
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Entered getUsersGroups method.");
        }
        boolean loginTried = false;
        while (true) {
            this.loginUnified();
            try {
                ArrayOfGroupResultHolder groupArray = new ArrayOfGroupResultHolder();
                BooleanHolder boolHolder = new BooleanHolder();
                this.meridioMCWS_.getUsersGroups(this.loginToken_, userId, boolHolder, groupArray);
                if (this.oLog != null) {
                    this.oLog.debug((Object)("Success? <" + boolHolder.value + ">"));
                }
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting getUsersGroups method");
                }
                if (boolHolder.value) {
                    return groupArray.value;
                }
                return null;
            }
            catch (RemoteException e) {
                if (!loginTried) {
                    if (this.oLog != null) {
                        this.oLog.debug((Object)"Meridio: Retrying getUsersGroups method with login.");
                    }
                    this.loginToken_ = null;
                    loginTried = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public DMDataSet getStaticData() throws RemoteException, MeridioDataSetException {
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Entered getStaticData method.");
        }
        long currentTime = System.currentTimeMillis();
        if (this.meridioStaticData_ != null && this.meridioStaticDataTime < currentTime) {
            this.meridioStaticData_ = null;
        }
        if (this.meridioStaticData_ == null) {
            boolean loginTried = false;
            while (true) {
                this.loginUnified();
                try {
                    GetStaticDataWTResponseGetStaticDataWTResult staticDataResult = null;
                    staticDataResult = this.meridioDMWebService_.getStaticData(this.loginToken_, true, true, true, true, true);
                    this.meridioStaticData_ = this.getDMDataSet(staticDataResult.get_any());
                    this.meridioStaticDataTime = currentTime + 300000L;
                }
                catch (RemoteException e) {
                    if (!loginTried) {
                        if (this.oLog != null) {
                            this.oLog.debug((Object)"Meridio: Retrying getStaticData method with login.");
                        }
                        this.loginToken_ = null;
                        loginTried = true;
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Exiting getStaticData method.");
        }
        return this.meridioStaticData_;
    }

    public RMDataSet getConfiguration() throws RemoteException, MeridioDataSetException {
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Entered getConfiguration method.");
        }
        boolean loginTried = false;
        while (true) {
            this.loginUnified();
            try {
                GetConfigurationResponseGetConfigurationResult configurationResult = null;
                configurationResult = this.meridioRMWebService_.getConfiguration();
                RMDataSet ds = this.getRMDataSet(configurationResult.get_any());
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting getConfiguration method.");
                }
                return ds;
            }
            catch (RemoteException e) {
                if (!loginTried) {
                    if (this.oLog != null) {
                        this.oLog.debug((Object)"Meridio: Retrying getConfiguration method with login.");
                    }
                    this.loginToken_ = null;
                    loginTried = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public RMDataSet getPropertyDefs() throws RemoteException, MeridioDataSetException {
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Entered getPropertyDefs method.");
        }
        boolean loginTried = false;
        while (true) {
            this.loginUnified();
            try {
                GetPropertyDefsResponseGetPropertyDefsResult configurationResult = null;
                configurationResult = this.meridioRMWebService_.getPropertyDefs();
                RMDataSet ds = this.getRMDataSet(configurationResult.get_any());
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting getPropertyDefs method.");
                }
                return ds;
            }
            catch (RemoteException e) {
                if (!loginTried) {
                    if (this.oLog != null) {
                        this.oLog.debug((Object)"Meridio: Retrying getPropertyDefs method with login.");
                    }
                    this.loginToken_ = null;
                    loginTried = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public DMDataSet getCategories() throws RemoteException, MeridioDataSetException {
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Entered getCategories method.");
        }
        long currentTime = System.currentTimeMillis();
        if (this.meridioCategories_ != null && this.meridioCategoriesTime < currentTime) {
            this.meridioCategories_ = null;
        }
        if (this.meridioCategories_ == null) {
            boolean loginTried = false;
            while (true) {
                this.loginUnified();
                try {
                    GetCategoriesWTResponseGetCategoriesWTResult staticDataResult = null;
                    staticDataResult = this.meridioDMWebService_.getCategories(this.loginToken_);
                    this.meridioCategories_ = this.getDMDataSet(staticDataResult.get_any());
                    this.meridioCategoriesTime = currentTime + 300000L;
                }
                catch (RemoteException e) {
                    if (!loginTried) {
                        if (this.oLog != null) {
                            this.oLog.debug((Object)"Meridio: Retrying getCategories method with login.");
                        }
                        this.loginToken_ = null;
                        loginTried = true;
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Exiting getCategories method.");
        }
        return this.meridioCategories_;
    }

    public RMDataSet getClassContents(int classOrFolderId, boolean getPropDefs, boolean getActivities, boolean getCustomProperties) throws RemoteException, MeridioDataSetException {
        if (this.oLog != null) {
            this.oLog.debug((Object)("Meridio: Entered getClassContents method. Class/folder ID <" + classOrFolderId + ">"));
        }
        boolean loginTried = false;
        while (true) {
            this.loginUnified();
            try {
                GetClassContentsWTResponseGetClassContentsWTResult classContents = null;
                classContents = this.meridioRMWebService_.getClassContents(this.loginToken_, classOrFolderId, getPropDefs, getActivities, getCustomProperties);
                RMDataSet ds = this.getRMDataSet(classContents.get_any());
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting getClassContents method");
                }
                return ds;
            }
            catch (RemoteException e) {
                if (!loginTried) {
                    if (this.oLog != null) {
                        this.oLog.debug((Object)"Meridio: Retrying getClassContents method with login.");
                    }
                    this.loginToken_ = null;
                    loginTried = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public int findClassOrFolder(String classOrFolder) throws RemoteException, MeridioDataSetException {
        return this.findClassOrFolder(classOrFolder, 0);
    }

    public int findClassOrFolder(String classOrFolder, int startClassOrFolder) throws RemoteException, MeridioDataSetException {
        if (this.oLog != null) {
            this.oLog.debug((Object)("Meridio: Entered findClassOrFolder method. Path = <" + classOrFolder + "> Starting class/folder ID <" + startClassOrFolder + ">"));
        }
        if (classOrFolder == null) {
            if (this.oLog != null) {
                this.oLog.debug((Object)"Meridio: Class/folder path provided is null, so returning top level FilePlan");
            }
            return 0;
        }
        String[] classTokens = classOrFolder.split("/");
        if (classTokens.length == 0) {
            if (this.oLog != null) {
                this.oLog.debug((Object)"Meridio: No classes in path, so returning top level FilePlan");
            }
            if (this.oLog != null) {
                this.oLog.debug((Object)"Meridio: Exiting findClassOrFolder method");
            }
            return 0;
        }
        int currentClassOrFolder = startClassOrFolder;
        boolean isMatchFound = false;
        block0: for (int i = 0; i < classTokens.length; ++i) {
            if (classTokens[i].length() == 0) continue;
            RMDataSet ds = this.getClassContents(currentClassOrFolder, false, false, false);
            Rm2vClass[] classes = ds.getRm2vClass();
            isMatchFound = false;
            for (int j = 0; j < classes.length; ++j) {
                if (this.oLog != null && this.oLog.isDebugEnabled()) {
                    this.oLog.debug((Object)("Meridio: Comparing [" + classTokens[i] + "] with [" + classes[j].getName() + "]"));
                }
                if (classTokens[i].compareTo(classes[j].getName()) != 0) continue;
                currentClassOrFolder = classes[j].getId();
                isMatchFound = true;
                break;
            }
            if (isMatchFound) continue;
            if (i != classTokens.length - 1) break;
            Rm2vFolder[] folders = ds.getRm2vFolder();
            for (int j = 0; j < folders.length; ++j) {
                if (classTokens[i].compareTo(folders[j].getName()) != 0) continue;
                currentClassOrFolder = folders[j].getId();
                isMatchFound = true;
                continue block0;
            }
        }
        if (isMatchFound) {
            if (this.oLog != null && this.oLog.isDebugEnabled()) {
                this.oLog.debug((Object)("Meridio: Found match: " + currentClassOrFolder));
            }
            if (this.oLog != null) {
                this.oLog.debug((Object)"Meridio: Exiting findClassOrFolder method");
            }
            return currentClassOrFolder;
        }
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: No match found");
        }
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Exiting findClassOrFolder method");
        }
        return -1;
    }

    public DMSearchResults searchDocuments(DMDataSet searchInfo, int maxHitsToReturn, int startPositionOfHits, DmPermission permissionFilter, boolean searchAll, DmSearchScope scope, boolean useThesaurus, boolean searchChildren, boolean searchKeywordHierarchy, DmLogicalOp keywordOperator) throws RemoteException, MeridioDataSetException {
        if (this.oLog != null && this.oLog.isDebugEnabled()) {
            this.oLog.debug((Object)("Meridio: Entering searchDocuments method\n\tMax Hits to Return <" + maxHitsToReturn + "> \tStart Position <" + startPositionOfHits + "> \tPermission Folder <" + permissionFilter + "> \tSearch All <" + searchAll + "> \tSearch Scope <" + scope + "> \tUse Thesaurus <" + useThesaurus + "> \tSearch Children <" + searchChildren + "> \tSearch Keyword Hierarchy <" + searchKeywordHierarchy + "> \tKeyword Operator <" + keywordOperator + ">"));
        }
        boolean loginTried = false;
        while (true) {
            this.loginUnified();
            try {
                UnsignedIntHolder totalHitsCount = new UnsignedIntHolder();
                UnsignedIntHolder returnedHitsCount = new UnsignedIntHolder();
                SearchDocumentsWTSearchInfo searchDocumentsInfo = new SearchDocumentsWTSearchInfo();
                SearchDocumentsWTResponseSearchDocumentsWTResultHolder searchDocumentsWTResult = new SearchDocumentsWTResponseSearchDocumentsWTResultHolder();
                searchDocumentsInfo.set_any(this.getSOAPMessage(searchInfo));
                this.meridioDMWebService_.searchDocuments(this.loginToken_, searchDocumentsInfo, new UnsignedInt((long)maxHitsToReturn), new UnsignedInt((long)startPositionOfHits), permissionFilter, searchAll, scope, useThesaurus, searchChildren, searchKeywordHierarchy, keywordOperator, searchDocumentsWTResult, totalHitsCount, returnedHitsCount);
                DMSearchResults dsDMSearchResults = new DMSearchResults();
                dsDMSearchResults.dsDM = this.getDMDataSet(searchDocumentsWTResult.value.get_any());
                dsDMSearchResults.returnedHitsCount = returnedHitsCount.value.intValue();
                dsDMSearchResults.totalHitsCount = totalHitsCount.value.intValue();
                if (this.oLog != null && this.oLog.isDebugEnabled()) {
                    this.oLog.debug((Object)("Meridio: Returned Hits <" + dsDMSearchResults.returnedHitsCount + "> Total Hits <" + dsDMSearchResults.totalHitsCount + ">"));
                }
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting searchDocuments method.");
                }
                return dsDMSearchResults;
            }
            catch (RemoteException e) {
                if (!loginTried) {
                    if (this.oLog != null) {
                        this.oLog.debug((Object)"Meridio: Retrying searchDocuments method with login.");
                    }
                    this.loginToken_ = null;
                    loginTried = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public DMSearchResults searchRecords(DMDataSet searchInfo, int maxHitsToReturn, int startPositionOfHits, DmPermission permissionFilter, boolean searchAll, DmSearchScope scope, boolean useThesaurus, boolean searchChildren, boolean searchKeywordHierarchy, DmLogicalOp keywordOperator) throws RemoteException, MeridioDataSetException {
        if (this.oLog != null && this.oLog.isDebugEnabled()) {
            this.oLog.debug((Object)("Meridio: Entering searchRecords method\n\n\tMax Hits to Return <" + maxHitsToReturn + "> \n\tStart Position <" + startPositionOfHits + "> \n\tPermission Folder <" + permissionFilter + "> \n\tSearch All <" + searchAll + "> \n\tSearch Scope <" + scope + "> \n\tUse Thesaurus <" + useThesaurus + "> \n\tSearch Children <" + searchChildren + "> \n\tSearch Keyword Hierarchy <" + searchKeywordHierarchy + "> \n\tKeyword Operator <" + keywordOperator + ">"));
        }
        boolean loginTried = false;
        while (true) {
            this.loginUnified();
            try {
                UnsignedIntHolder totalHitsCount = new UnsignedIntHolder();
                UnsignedIntHolder returnedHitsCount = new UnsignedIntHolder();
                SearchRecordsWTSearchInfo searchDocumentsInfo = new SearchRecordsWTSearchInfo();
                SearchRecordsWTResponseSearchRecordsWTResultHolder searchRecordsWTResult = new SearchRecordsWTResponseSearchRecordsWTResultHolder();
                searchDocumentsInfo.set_any(this.getSOAPMessage(searchInfo));
                this.meridioDMWebService_.searchRecords(this.loginToken_, searchDocumentsInfo, new UnsignedInt((long)maxHitsToReturn), new UnsignedInt((long)startPositionOfHits), permissionFilter, searchAll, scope, useThesaurus, searchChildren, searchKeywordHierarchy, keywordOperator, searchRecordsWTResult, totalHitsCount, returnedHitsCount);
                DMSearchResults dsDMSearchResults = new DMSearchResults();
                dsDMSearchResults.dsDM = this.getDMDataSet(searchRecordsWTResult.value.get_any());
                dsDMSearchResults.returnedHitsCount = returnedHitsCount.value.intValue();
                dsDMSearchResults.totalHitsCount = totalHitsCount.value.intValue();
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting searchRecords method.");
                }
                return dsDMSearchResults;
            }
            catch (RemoteException e) {
                if (!loginTried) {
                    if (this.oLog != null) {
                        this.oLog.debug((Object)"Meridio: Retrying searchRecords method with login.");
                    }
                    this.loginToken_ = null;
                    loginTried = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public DMSearchResults searchUsers(DMDataSet searchInfo, int maxHitsToReturn, int startPositionOfHits, boolean searchChildren) throws RemoteException, MeridioDataSetException {
        if (this.oLog != null && this.oLog.isDebugEnabled()) {
            this.oLog.debug((Object)("Meridio: Entering searchUsers method\n\n\tMax Hits to Return <" + maxHitsToReturn + "> \n\tStart Position <" + startPositionOfHits + "> \n\tSearch Children <" + searchChildren + ">"));
        }
        boolean loginTried = false;
        while (true) {
            this.loginUnified();
            try {
                UnsignedIntHolder totalHitsCount = new UnsignedIntHolder();
                UnsignedIntHolder returnedHitsCount = new UnsignedIntHolder();
                SearchUsersWTSearchInfo searchUsersInfo = new SearchUsersWTSearchInfo();
                SearchUsersWTResponseSearchUsersWTResultHolder searchUsersWTResult = new SearchUsersWTResponseSearchUsersWTResultHolder();
                searchUsersInfo.set_any(this.getSOAPMessage(searchInfo));
                this.meridioDMWebService_.searchUsers(this.loginToken_, searchUsersInfo, new UnsignedInt((long)maxHitsToReturn), new UnsignedInt((long)startPositionOfHits), searchChildren, searchUsersWTResult, totalHitsCount, returnedHitsCount);
                DMSearchResults dsDMSearchResults = new DMSearchResults();
                dsDMSearchResults.dsDM = this.getDMDataSet(searchUsersWTResult.value.get_any());
                dsDMSearchResults.returnedHitsCount = returnedHitsCount.value.intValue();
                dsDMSearchResults.totalHitsCount = totalHitsCount.value.intValue();
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting searchUsers method.");
                }
                return dsDMSearchResults;
            }
            catch (RemoteException e) {
                if (!loginTried) {
                    if (this.oLog != null) {
                        this.oLog.debug((Object)"Meridio: Retrying searchUsers method with login.");
                    }
                    this.loginToken_ = null;
                    loginTried = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public long getUserIdFromName(String userName) throws RemoteException, MeridioDataSetException {
        if (this.oLog != null && this.oLog.isDebugEnabled()) {
            this.oLog.debug((Object)("Meridio: Entering getUserIdFromName method\nUser name is <" + userName + ">"));
        }
        DMDataSet dsSearchCriteria = new DMDataSet();
        PROPERTY_TERMS drUserSearch = new PROPERTY_TERMS();
        drUserSearch.setId(1L);
        drUserSearch.setTermType(new Short("0"));
        drUserSearch.setPropertyName("PROP_loginName");
        drUserSearch.setStr_relation(new Short("0"));
        drUserSearch.setStr_value(userName);
        drUserSearch.setParentId(1L);
        dsSearchCriteria.addPROPERTY_TERMS(drUserSearch);
        PROPERTY_TERMS drUserEnabled = new PROPERTY_TERMS();
        drUserEnabled.setId(2L);
        drUserEnabled.setTermType(new Short("1"));
        drUserEnabled.setPropertyName("PROP_enabled");
        drUserEnabled.setNum_relation(new Short("0"));
        drUserEnabled.setNum_value(1L);
        drUserEnabled.setParentId(1L);
        dsSearchCriteria.addPROPERTY_TERMS(drUserEnabled);
        PROPERTY_OPS drPropertyOps = new PROPERTY_OPS();
        drPropertyOps.setId(1L);
        drPropertyOps.setOperator(new Short("0"));
        dsSearchCriteria.addPROPERTY_OPS(drPropertyOps);
        RESULTDEFS drResultDefs = new RESULTDEFS();
        drResultDefs.setPropertyName("PROP_id");
        drResultDefs.setIsVersionProperty(false);
        dsSearchCriteria.addRESULTDEFS(drResultDefs);
        DMSearchResults dsSearchResults = null;
        dsSearchResults = this.searchUsers(dsSearchCriteria, 1, 1, false);
        long rval = dsSearchResults.totalHitsCount != 1 || null == dsSearchResults.dsDM ? 0L : dsSearchResults.dsDM.getSEARCHRESULTS_USERS()[0].getUserId();
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Exiting searchUsers method.");
        }
        return rval;
    }

    public RMDataSet getRolesAndMembership() throws RemoteException, MeridioDataSetException {
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Entering getRolesAndMembership method");
        }
        boolean loginTried = false;
        while (true) {
            this.loginUnified();
            try {
                GetRolesAndMembershipWTResponseGetRolesAndMembershipWTResult rolesAndMembershipResult = null;
                rolesAndMembershipResult = this.meridioRMWebService_.getRolesAndMembership(this.loginToken_);
                RMDataSet ds = this.getRMDataSet(rolesAndMembershipResult.get_any());
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting getRolesAndMembership method.");
                }
                return ds;
            }
            catch (RemoteException e) {
                if (!loginTried) {
                    if (this.oLog != null) {
                        this.oLog.debug((Object)"Meridio: Retrying getRolesAndMembership method with login.");
                    }
                    this.loginToken_ = null;
                    loginTried = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public RMDataSet getProtectiveMarkingList(int id, int objectType) throws RemoteException, MeridioDataSetException {
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Entering getProtectiveMarkingList method");
        }
        boolean loginTried = false;
        while (true) {
            this.loginUnified();
            try {
                GetProtectiveMarkingListWTResponseGetProtectiveMarkingListWTResult getProtectiveMarkingList = null;
                getProtectiveMarkingList = this.meridioRMWebService_.getProtectiveMarkingList(this.loginToken_, id, objectType);
                RMDataSet ds = this.getRMDataSet(getProtectiveMarkingList.get_any());
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting getProtectiveMarkingList method.");
                }
                return ds;
            }
            catch (RemoteException e) {
                if (!loginTried) {
                    if (this.oLog != null) {
                        this.oLog.debug((Object)"Meridio: Retrying getProtectiveMarkingList method with login.");
                    }
                    this.loginToken_ = null;
                    loginTried = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public RMDataSet getUserPrivilegeList(int userId) throws RemoteException, MeridioDataSetException {
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Entering getUserPrivilegeList method");
        }
        boolean loginTried = false;
        while (true) {
            this.loginUnified();
            try {
                GetUserPrivilegeListWTResponseGetUserPrivilegeListWTResult getUserPrivilegeList = null;
                getUserPrivilegeList = this.meridioRMWebService_.getUserPrivilegeList(this.loginToken_, userId);
                RMDataSet ds = this.getRMDataSet(getUserPrivilegeList.get_any());
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting getUserPrivilegeList method.");
                }
                return ds;
            }
            catch (RemoteException e) {
                if (!loginTried) {
                    if (this.oLog != null) {
                        this.oLog.debug((Object)"Meridio: Retrying getUserPrivilegeList method with login.");
                    }
                    this.loginToken_ = null;
                    loginTried = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public RMDataSet getRecord(int recordId, boolean getPropDefs, boolean getActivities, boolean getCustomProperties) throws RemoteException, MeridioDataSetException {
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Entering getRecord method");
        }
        boolean loginTried = false;
        while (true) {
            this.loginUnified();
            try {
                GetRecordWTResponseGetRecordWTResult getRecord = null;
                getRecord = this.meridioRMWebService_.getRecord(this.loginToken_, recordId, getPropDefs, getActivities, getCustomProperties);
                RMDataSet ds = this.getRMDataSet(getRecord.get_any());
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting getRecord method.");
                }
                return ds;
            }
            catch (RemoteException e) {
                if (!loginTried) {
                    if (this.oLog != null) {
                        this.oLog.debug((Object)"Meridio: Retrying getRecord method with login.");
                    }
                    this.loginToken_ = null;
                    loginTried = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public RMDataSet getFolder(int folderId, boolean getPropDefs, boolean getActivities, boolean getContents, boolean getCustomProperties) throws RemoteException, MeridioDataSetException {
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Entering getFolder method");
        }
        boolean loginTried = false;
        while (true) {
            this.loginUnified();
            try {
                GetFolderWTResponseGetFolderWTResult getFolder = null;
                getFolder = this.meridioRMWebService_.getFolder(this.loginToken_, folderId, getPropDefs, getActivities, getContents, getCustomProperties);
                RMDataSet ds = this.getRMDataSet(getFolder.get_any());
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting getFolder method.");
                }
                return ds;
            }
            catch (RemoteException e) {
                if (!loginTried) {
                    if (this.oLog != null) {
                        this.oLog.debug((Object)"Meridio: Retrying getFolder method with login.");
                    }
                    this.loginToken_ = null;
                    loginTried = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public DMDataSet getUserData(long userId, boolean getPropList, boolean getCanDo, boolean getGroups, boolean getSharedContainers, boolean getStoredSearches, boolean getLockedDocuments) throws RemoteException, MeridioDataSetException {
        if (this.oLog != null && this.oLog.isDebugEnabled()) {
            this.oLog.debug((Object)("Meridio: Entering getUserData method\n\n\tUser Identifier <" + userId + "> \n\tGet Property List <" + getPropList + "> \n\tGet Can Do <" + getCanDo + "> \n\tGet Groups <" + getGroups + "> \n\tGet Shared Containers <" + getSharedContainers + ">\n\tSet Stored Searches <" + getStoredSearches + "> \n\tGet Locked Documents <" + getLockedDocuments + ">"));
        }
        boolean loginTried = false;
        while (true) {
            this.loginUnified();
            try {
                GetUserDataWTResponseGetUserDataWTResult userData = null;
                userData = this.meridioDMWebService_.getUserData(this.loginToken_, new UnsignedInt(userId), getPropList, getCanDo, getGroups, getSharedContainers, getStoredSearches, getLockedDocuments);
                DMDataSet dmDS = this.getDMDataSet(userData.get_any());
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting getUserData method.");
                }
                return dmDS;
            }
            catch (RemoteException e) {
                if (!loginTried) {
                    if (this.oLog != null) {
                        this.oLog.debug((Object)"Meridio: Retrying getUserData method with login.");
                    }
                    this.loginToken_ = null;
                    loginTried = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public DMDataSet getDocumentData(int docId, boolean getPropList, boolean getAcl, boolean getCanDo, boolean getPolicy, DmVersionInfo getVersions, boolean getKeywords, boolean getReferencingContainers, boolean getLockInfo) throws RemoteException, MeridioDataSetException {
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Entered getDocumentData method.");
        }
        boolean loginTried = false;
        while (true) {
            this.loginUnified();
            try {
                GetDocumentDataWTResponseGetDocumentDataWTResult getDocumentResponse = null;
                getDocumentResponse = this.meridioDMWebService_.getDocumentData(this.loginToken_, new UnsignedInt((long)docId), getPropList, getAcl, getCanDo, getPolicy, getVersions, getKeywords, getReferencingContainers, getLockInfo);
                DMDataSet ds = this.getDMDataSet(getDocumentResponse.get_any());
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting getDocumentData method.");
                }
                return ds;
            }
            catch (RemoteException e) {
                if (!loginTried) {
                    if (this.oLog != null) {
                        this.oLog.debug((Object)"Meridio: Retrying getDocumentData method with login.");
                    }
                    this.loginToken_ = null;
                    loginTried = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public DMDataSet getContainerData(int containerId, boolean getPropList, boolean getAcl, boolean getCanDo, boolean getChildContainers, boolean getContainerRefs, boolean getDocumentRefs, boolean getStoredSearchRefs, boolean getKeywords, boolean getReferencingContainers) throws RemoteException, MeridioDataSetException {
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Entered getContainerData method.");
        }
        boolean loginTried = false;
        while (true) {
            this.loginUnified();
            try {
                GetContainerDataWTResponseGetContainerDataWTResult getContainerDataResponse = null;
                getContainerDataResponse = this.meridioDMWebService_.getContainerData(this.loginToken_, new UnsignedInt((long)containerId), getPropList, getAcl, getCanDo, getChildContainers, getContainerRefs, getDocumentRefs, getStoredSearchRefs, getKeywords, getReferencingContainers);
                DMDataSet ds = this.getDMDataSet(getContainerDataResponse.get_any());
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting getContainerData method.");
                }
                return ds;
            }
            catch (RemoteException e) {
                if (!loginTried) {
                    if (this.oLog != null) {
                        this.oLog.debug((Object)"Meridio: Retrying getContainerData method with login.");
                    }
                    this.loginToken_ = null;
                    loginTried = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public AttachmentPart getLatestVersionFile(int docId) throws RemoteException, MeridioDataSetException {
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Entered getLatestVersionFile method.");
        }
        boolean loginTried = false;
        while (true) {
            this.loginUnified();
            try {
                String mimeType = null;
                this.meridioDMWebService_._setProperty("attachment_encapsulation_format", "axis.attachment.style.dime");
                mimeType = this.meridioDMWebService_.getLatestVersionFile(this.loginToken_, new UnsignedInt((long)docId));
                Object[] attachments = this.meridioDMWebService_.getAttachments();
                if (this.oLog != null && this.oLog.isDebugEnabled()) {
                    this.oLog.debug((Object)("Meridio: Mime Type is: <" + mimeType + "> - " + attachments.length + " attachment(s)"));
                }
                if (attachments.length != 1) {
                    if (this.oLog != null) {
                        this.oLog.debug((Object)"Meridio: Exiting getLatestVersionFile method with null.");
                    }
                    return null;
                }
                AttachmentPart ap = (AttachmentPart)attachments[0];
                if (this.oLog != null && this.oLog.isDebugEnabled()) {
                    this.oLog.debug((Object)("Meridio: Temp File is <" + ap.getAttachmentFile() + ">"));
                }
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting getLatestVersionFile method.");
                }
                return ap;
            }
            catch (RemoteException e) {
                if (!loginTried) {
                    if (this.oLog != null) {
                        this.oLog.debug((Object)"Meridio: Retrying getLatestVersionFile method with login.");
                    }
                    this.loginToken_ = null;
                    loginTried = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public RMDataSet getRecordPartList(int recordId, boolean getPropDefs, boolean getActivities) throws RemoteException, MeridioDataSetException {
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Entering getRecordPartList method");
        }
        boolean loginTried = false;
        while (true) {
            this.loginUnified();
            try {
                GetRecordPartListWTResponseGetRecordPartListWTResult getRecordPartList = null;
                getRecordPartList = this.meridioRMWebService_.getRecordPartList(this.loginToken_, recordId, getPropDefs, getActivities);
                RMDataSet ds = this.getRMDataSet(getRecordPartList.get_any());
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting getRecordPartList method.");
                }
                return ds;
            }
            catch (RemoteException e) {
                if (!loginTried) {
                    if (this.oLog != null) {
                        this.oLog.debug((Object)"Meridio: Retrying getRecordPartList method with login.");
                    }
                    this.loginToken_ = null;
                    loginTried = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public RMDataSet getDocumentPartList(int documentId) throws RemoteException, MeridioDataSetException {
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Entering getDocumentPartList method");
        }
        boolean loginTried = false;
        while (true) {
            this.loginUnified();
            try {
                GetDocumentPartListWTResponseGetDocumentPartListWTResult getDocumentPartList = null;
                getDocumentPartList = this.meridioRMWebService_.getDocumentPartList(this.loginToken_, documentId);
                RMDataSet ds = this.getRMDataSet(getDocumentPartList.get_any());
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting getDocumentPartList method.");
                }
                return ds;
            }
            catch (RemoteException e) {
                if (!loginTried) {
                    if (this.oLog != null) {
                        this.oLog.debug((Object)"Meridio: Retrying getDocumentPartList method with login.");
                    }
                    this.loginToken_ = null;
                    loginTried = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    protected DMDataSet getDMDataSet(MessageElement[] messageElement) throws MeridioDataSetException {
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Entered getDMDataSet method.");
        }
        try {
            if (messageElement.length != 2) {
                if (this.oLog != null) {
                    this.oLog.warn((Object)"Meridio: SOAP Message not of expected length");
                }
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting getDMDataSet method with null.");
                }
                return null;
            }
            Document document = messageElement[1].getAsDocument();
            NodeList nl = document.getElementsByTagName("DMDataSet");
            NodeList errors = document.getElementsByTagName("diffgr:errors");
            if (errors.getLength() != 0) {
                Object errorXML = "";
                if (this.oLog != null) {
                    this.oLog.error((Object)("Found <" + errors.getLength() + "> errors in returned data set"));
                }
                for (int i = 0; i < errors.getLength(); ++i) {
                    Element e = (Element)errors.item(i);
                    DocumentImpl resultDocument = new DocumentImpl();
                    Node node = resultDocument.importNode(e, true);
                    resultDocument.appendChild(node);
                    DOMImplementation domImpl = DOMImplementationImpl.getDOMImplementation();
                    DOMImplementationLS implLS = (DOMImplementationLS)((Object)domImpl);
                    LSSerializer writer = implLS.createLSSerializer();
                    errorXML = (String)errorXML + writer.writeToString((Node)resultDocument) + "\n";
                    if (this.oLog == null) continue;
                    this.oLog.warn((Object)("..." + (String)errorXML));
                }
                throw new MeridioDataSetException((String)errorXML);
            }
            if (nl.getLength() != 1) {
                if (this.oLog != null) {
                    this.oLog.warn((Object)"Meridio: Returning null - could not find DMDataSet in SOAP Message");
                }
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting getDMDataSet method with null.");
                }
                return null;
            }
            Element e = (Element)nl.item(0);
            DocumentImpl resultDocument = new DocumentImpl();
            Node node = resultDocument.importNode(e, true);
            resultDocument.appendChild(node);
            DOMImplementation domImpl = DOMImplementationImpl.getDOMImplementation();
            DOMImplementationLS implLS = (DOMImplementationLS)((Object)domImpl);
            LSSerializer writer = implLS.createLSSerializer();
            String documentXML = writer.writeToString((Node)resultDocument);
            StringReader sr = new StringReader(documentXML);
            DMDataSet dsDM = new DMDataSet();
            dsDM = DMDataSet.unmarshal(sr);
            if (this.oLog != null) {
                this.oLog.debug((Object)"Meridio: Exiting getDMDataSet method.");
            }
            return dsDM;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MeridioDataSetException("Could not find the DOM Parser class when unmarshalling the Meridio Dataset", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new MeridioDataSetException("Error instantiating the DOM Parser when unmarshalling the Meridio Dataset", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MeridioDataSetException("DOM Parser illegal access when unmarshalling the Meridio Dataset", illegalAccessException);
        }
        catch (MarshalException marshalException) {
            throw new MeridioDataSetException("Castor error in marshalling the XML from the Meridio Dataset", marshalException);
        }
        catch (ValidationException validationException) {
            throw new MeridioDataSetException("Castor error in validating the XML from the Meridio Dataset", validationException);
        }
        catch (Exception ex) {
            throw new MeridioDataSetException("Error retrieving the XML Document from the Web Service response", ex);
        }
    }

    protected RMDataSet getRMDataSet(MessageElement[] messageElement) throws MeridioDataSetException {
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Entered getRMDataSet method.");
        }
        try {
            if (messageElement.length != 2) {
                if (this.oLog != null) {
                    this.oLog.warn((Object)"Meridio: SOAP Message not of expected length");
                }
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting getRMDataSet method with null.");
                }
                return null;
            }
            Document document = messageElement[1].getAsDocument();
            NodeList nl = document.getElementsByTagName("RMDataSet");
            NodeList errors = document.getElementsByTagName("diffgr:errors");
            if (errors.getLength() != 0) {
                Object errorXML = "";
                if (this.oLog != null) {
                    this.oLog.error((Object)("Found <" + errors.getLength() + "> errors in returned data set"));
                }
                for (int i = 0; i < errors.getLength(); ++i) {
                    Element e = (Element)errors.item(i);
                    DocumentImpl resultDocument = new DocumentImpl();
                    Node node = resultDocument.importNode(e, true);
                    resultDocument.appendChild(node);
                    DOMImplementation domImpl = DOMImplementationImpl.getDOMImplementation();
                    DOMImplementationLS implLS = (DOMImplementationLS)((Object)domImpl);
                    LSSerializer writer = implLS.createLSSerializer();
                    errorXML = (String)errorXML + writer.writeToString((Node)resultDocument) + "\n";
                    if (this.oLog == null) continue;
                    this.oLog.warn((Object)("..." + (String)errorXML));
                }
                throw new MeridioDataSetException((String)errorXML);
            }
            if (nl.getLength() != 1) {
                if (this.oLog != null) {
                    this.oLog.warn((Object)"Meridio: Returning null - could not find RMDataSet in SOAP Message");
                }
                if (this.oLog != null) {
                    this.oLog.debug((Object)"Meridio: Exiting getRMDataSet method with null.");
                }
                return null;
            }
            Element e = (Element)nl.item(0);
            DocumentImpl resultDocument = new DocumentImpl();
            Node node = resultDocument.importNode(e, true);
            resultDocument.appendChild(node);
            DOMImplementation domImpl = DOMImplementationImpl.getDOMImplementation();
            DOMImplementationLS implLS = (DOMImplementationLS)((Object)domImpl);
            LSSerializer writer = implLS.createLSSerializer();
            String documentXML = writer.writeToString((Node)resultDocument);
            StringReader sr = new StringReader(documentXML);
            RMDataSet dsRM = new RMDataSet();
            dsRM = RMDataSet.unmarshal(sr);
            if (this.oLog != null) {
                this.oLog.debug((Object)"Meridio: Exiting getRMDataSet method.");
            }
            return dsRM;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MeridioDataSetException("Could not find the DOM Parser class when unmarshalling the Meridio Dataset", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new MeridioDataSetException("Error instantiating the DOM Parser when unmarshalling the Meridio Dataset", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MeridioDataSetException("DOM Parser illegal access when unmarshalling the Meridio Dataset", illegalAccessException);
        }
        catch (MarshalException marshalException) {
            throw new MeridioDataSetException("Castor error in marshalling the XML from the Meridio Dataset", marshalException);
        }
        catch (ValidationException validationException) {
            throw new MeridioDataSetException("Castor error in validating the XML from the Meridio Dataset", validationException);
        }
        catch (Exception ex) {
            throw new MeridioDataSetException("Error retrieving the XML Document from the Web Service response", ex);
        }
    }

    protected MessageElement[] getSOAPMessage(DMDataSet dsDM) throws MeridioDataSetException {
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Entered getSOAPMessage method.");
        }
        try {
            StringWriter writer = new StringWriter();
            dsDM.marshal(writer);
            ((Writer)writer).close();
            StringReader stringReader = new StringReader(((Object)writer).toString());
            InputSource inputSource = new InputSource(stringReader);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            Document document = documentBuilderFactory.newDocumentBuilder().parse(inputSource);
            Element element = document.getDocumentElement();
            MessageElement messageElement = new MessageElement(element);
            MessageElement[] messageElementArray = new MessageElement[]{messageElement};
            if (this.oLog != null) {
                this.oLog.debug((Object)"Meridio: Exiting getSOAPMessage method.");
            }
            return messageElementArray;
        }
        catch (MarshalException marshalException) {
            throw new MeridioDataSetException("Castor error in marshalling the XML from the Meridio Dataset", marshalException);
        }
        catch (ValidationException validationException) {
            throw new MeridioDataSetException("Castor error in validating the XML from the Meridio Dataset", validationException);
        }
        catch (IOException IoException) {
            throw new MeridioDataSetException("IO Error in marshalling the Meridio Dataset", IoException);
        }
        catch (SAXException SaxException) {
            throw new MeridioDataSetException("XML Error in marshalling the Meridio Dataset", SaxException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new MeridioDataSetException("XML Error in parsing the Meridio Dataset", parserConfigurationException);
        }
    }

    protected MessageElement[] getSOAPMessage(RMDataSet dsRM) throws MeridioDataSetException {
        if (this.oLog != null) {
            this.oLog.debug((Object)"Meridio: Entered getSOAPMessage method.");
        }
        try {
            StringWriter writer = new StringWriter();
            dsRM.marshal(writer);
            ((Writer)writer).close();
            StringReader stringReader = new StringReader(((Object)writer).toString());
            InputSource inputSource = new InputSource(stringReader);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            Document document = documentBuilderFactory.newDocumentBuilder().parse(inputSource);
            Element element = document.getDocumentElement();
            MessageElement messageElement = new MessageElement(element);
            MessageElement[] messageElementArray = new MessageElement[]{messageElement};
            if (this.oLog != null) {
                this.oLog.debug((Object)"Meridio: Exiting getSOAPMessage method.");
            }
            return messageElementArray;
        }
        catch (MarshalException marshalException) {
            throw new MeridioDataSetException("Castor error in marshalling the XML from the Meridio Dataset", marshalException);
        }
        catch (ValidationException validationException) {
            throw new MeridioDataSetException("Castor error in validating the XML from the Meridio Dataset", validationException);
        }
        catch (IOException IoException) {
            throw new MeridioDataSetException("IO Error in marshalling the Meridio Dataset", IoException);
        }
        catch (SAXException SaxException) {
            throw new MeridioDataSetException("XML Error in marshalling the Meridio Dataset", SaxException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new MeridioDataSetException("XML Error in parsing the Meridio Dataset", parserConfigurationException);
        }
    }

    static {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            currentHost = addr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    protected static class ResourceProvider
    implements WSDDEngineConfiguration {
        private WSDDDeployment deployment = null;
        private Class resourceClass;
        private String resourceName;

        public ResourceProvider(Class resourceClass, String resourceName) {
            this.resourceClass = resourceClass;
            this.resourceName = resourceName;
        }

        public WSDDDeployment getDeployment() {
            return this.deployment;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void configureEngine(AxisEngine engine) throws ConfigurationException {
            try {
                InputStream resourceStream = this.resourceClass.getResourceAsStream(this.resourceName);
                if (resourceStream == null) {
                    throw new ConfigurationException("Resource not found: '" + this.resourceName + "'");
                }
                try {
                    WSDDDocument doc = new WSDDDocument(XMLUtils.newDocument((InputStream)resourceStream));
                    this.deployment = doc.getDeployment();
                    this.deployment.configureEngine(engine);
                    engine.refreshGlobalOptions();
                }
                finally {
                    resourceStream.close();
                }
            }
            catch (ConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        }

        public void writeEngineConfig(AxisEngine engine) throws ConfigurationException {
        }

        public Handler getHandler(QName qname) throws ConfigurationException {
            return this.deployment.getHandler(qname);
        }

        public SOAPService getService(QName qname) throws ConfigurationException {
            SOAPService service = this.deployment.getService(qname);
            if (service == null) {
                throw new ConfigurationException(Messages.getMessage((String)"noService10", (String)qname.toString()));
            }
            return service;
        }

        public SOAPService getServiceByNamespaceURI(String namespace) throws ConfigurationException {
            return this.deployment.getServiceByNamespaceURI(namespace);
        }

        public Handler getTransport(QName qname) throws ConfigurationException {
            return this.deployment.getTransport(qname);
        }

        public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
            return this.deployment.getTypeMappingRegistry();
        }

        public Handler getGlobalRequest() throws ConfigurationException {
            return this.deployment.getGlobalRequest();
        }

        public Handler getGlobalResponse() throws ConfigurationException {
            return this.deployment.getGlobalResponse();
        }

        public Hashtable getGlobalOptions() throws ConfigurationException {
            WSDDGlobalConfiguration globalConfig = this.deployment.getGlobalConfiguration();
            if (globalConfig != null) {
                return globalConfig.getParametersTable();
            }
            return null;
        }

        public Iterator getDeployedServices() throws ConfigurationException {
            return this.deployment.getDeployedServices();
        }

        public List getRoles() {
            return this.deployment.getRoles();
        }
    }
}

