/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.ui.passwords;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class PasswordMapper {
    public static final String _rcsid = "@(#)$Id$";
    private final String randomPrefix;
    private final Map<String, Integer> passwordToKey = new HashMap<String, Integer>();
    private final List<String> passwordList = new ArrayList<String>();
    protected static char[] pickChars = new char[]{'\u0d5d', '\u20c4', '\u0392', '\u1a2b'};

    public PasswordMapper() {
        this.randomPrefix = PasswordMapper.generateRandomPrefix();
    }

    public synchronized String mapPasswordToKey(String password) {
        if (password == null || password.length() == 0) {
            return password;
        }
        Integer index = this.passwordToKey.get(password);
        if (index == null) {
            index = new Integer(this.passwordList.size());
            this.passwordList.add(password);
            this.passwordToKey.put(password, index);
        }
        return this.randomPrefix + index;
    }

    public synchronized String mapKeyToPassword(String key) {
        if (key != null && key.startsWith(this.randomPrefix)) {
            String intPart = key.substring(this.randomPrefix.length());
            try {
                int index = Integer.parseInt(intPart);
                if (index < this.passwordList.size()) {
                    return this.passwordList.get(index);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return key;
    }

    protected static String generateRandomPrefix() {
        Random r = new Random(System.currentTimeMillis());
        StringBuilder sb = new StringBuilder("_");
        for (int i = 0; i < 8; ++i) {
            int index = r.nextInt(pickChars.length);
            sb.append(pickChars[index]);
        }
        sb.append("_");
        return sb.toString();
    }
}

