/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents;

import org.apache.manifoldcf.agents.BaseAgentsInitializationCommand;
import org.apache.manifoldcf.agents.system.AgentsDaemon;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IShutdownHook;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class AgentRun
extends BaseAgentsInitializationCommand {
    public static final String _rcsid = "@(#)$Id: AgentRun.java 988245 2010-08-23 18:39:35Z kwright $";
    public static final String agentServiceType = "AGENT";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(IThreadContext tc) throws ManifoldCFException {
        String processID = ManifoldCF.getProcessID();
        ILockManager lockManager = LockManagerFactory.make((IThreadContext)tc);
        lockManager.registerServiceBeginServiceActivity(agentServiceType, processID, null);
        try {
            ManifoldCF.addShutdownHook((IShutdownHook)new AgentRunShutdownRunner(processID));
            Logging.root.info((Object)"Running...");
            AgentsDaemon ad = new AgentsDaemon(processID);
            ad.registerAgentsShutdownHook(tc);
            ad.runAgents(tc);
            Logging.root.info((Object)"Shutting down...");
        }
        catch (ManifoldCFException e) {
            Logging.root.error((Object)("Exception: " + e.getMessage()), (Throwable)e);
            e.printStackTrace(System.err);
        }
        finally {
            lockManager.endServiceActivity(agentServiceType, processID);
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            System.err.println("Usage: AgentRun");
            System.exit(1);
        }
        try {
            System.err.println("Running...");
            AgentRun agentRun = new AgentRun();
            agentRun.execute();
            System.err.println("Shutting down...");
        }
        catch (ManifoldCFException e) {
            Logging.root.error((Object)("Exception: " + e.getMessage()), (Throwable)e);
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    protected static class AgentRunShutdownRunner
    implements IShutdownHook {
        protected final String processID;

        public AgentRunShutdownRunner(String processID) {
            this.processID = processID;
        }

        public void doCleanup(IThreadContext tc) throws ManifoldCFException {
            ILockManager lockManager = LockManagerFactory.make((IThreadContext)tc);
            if (lockManager.checkServiceActive(AgentRun.agentServiceType, this.processID)) {
                lockManager.endServiceActivity(AgentRun.agentServiceType, this.processID);
            }
        }
    }
}

