/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.inmemory.FilterParser;
import org.apache.chemistry.opencmis.inmemory.NameValidator;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Folder;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.FilingImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.StoredObjectImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderImpl
extends StoredObjectImpl
implements Folder {
    private static final Logger LOG = LoggerFactory.getLogger((String)FilingImpl.class.getName());
    private String parentId;

    public FolderImpl() {
    }

    public FolderImpl(String name, String parentId) {
        this.init(name, parentId);
    }

    @Override
    public void fillProperties(Map<String, PropertyData<?>> properties, BindingsObjectFactory objFactory, List<String> requestedIds) {
        super.fillProperties(properties, objFactory, requestedIds);
        if (FilterParser.isContainedInFilter("cmis:parentId", requestedIds)) {
            properties.put("cmis:parentId", (PropertyData<?>)objFactory.createPropertyIdData("cmis:parentId", this.parentId));
        }
        if (FilterParser.isContainedInFilter("cmis:allowedChildObjectTypeIds", requestedIds)) {
            String allowedChildObjects = null;
            properties.put("cmis:allowedChildObjectTypeIds", (PropertyData<?>)objFactory.createPropertyIdData("cmis:allowedChildObjectTypeIds", allowedChildObjects));
        }
    }

    @Override
    public List<String> getAllowedChildObjectTypeIds() {
        return null;
    }

    @Override
    public boolean hasRendition(String user) {
        return true;
    }

    @Override
    public List<String> getParentIds() {
        if (this.parentId == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.parentId);
    }

    @Override
    public boolean hasParent() {
        return null != this.parentId;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public String getPathSegment() {
        return this.getName();
    }

    @Override
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    private void init(String name, String parentId) {
        if (!NameValidator.isValidName(name)) {
            throw new CmisInvalidArgumentException("Name contains illegal characters, not allowed are '/', '\\', ':', '\"', '*'. '?', '<','>', '|'");
        }
        this.setName(name);
        this.parentId = parentId;
    }
}

