/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class ConsumerRecords<K, V> {
    private final String topic;
    private final Map<Integer, List<ConsumerRecord<K, V>>> recordsPerPartition;

    public ConsumerRecords(String topic, Map<Integer, List<ConsumerRecord<K, V>>> records) {
        this.topic = topic;
        this.recordsPerPartition = records;
    }

    public List<ConsumerRecord<K, V>> records(int ... partitions) {
        ArrayList<ConsumerRecord<K, V>> recordsToReturn = new ArrayList<ConsumerRecord<K, V>>();
        if (partitions.length == 0) {
            for (Map.Entry<Integer, List<ConsumerRecord<K, V>>> record : this.recordsPerPartition.entrySet()) {
                recordsToReturn.addAll((Collection)record.getValue());
            }
        } else {
            for (int partition : partitions) {
                List<ConsumerRecord<K, V>> recordsForThisPartition = this.recordsPerPartition.get(partition);
                recordsToReturn.addAll(recordsForThisPartition);
            }
        }
        return recordsToReturn;
    }

    public String topic() {
        return this.topic;
    }
}

