/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.internal.util.XMLUtils;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public class XMLSerializer {
    private static final SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    private TransformerHandler mHandler;
    private Transformer mTransformer;
    private OutputStream mOutputStream;
    private Writer mWriter;

    public XMLSerializer() {
        this(true);
    }

    public XMLSerializer(boolean isFormattedOutput) {
        try {
            this.mHandler = transformerFactory.newTransformerHandler();
            this.mTransformer = this.mHandler.getTransformer();
            if (isFormattedOutput) {
                this.mTransformer.setOutputProperty("indent", "yes");
                this.mTransformer.setOutputProperty("encoding", "UTF-8");
                this.mTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                this.mTransformer.setOutputProperty("method", "xml");
            }
        }
        catch (TransformerConfigurationException e) {
            throw new UIMARuntimeException(e);
        }
    }

    public void setIndent(boolean yes) {
        this.mTransformer.setOutputProperty("indent", yes ? "yes" : "no");
    }

    public XMLSerializer(OutputStream aOutputStream) {
        this();
        this.setOutputStream(aOutputStream);
    }

    public XMLSerializer(OutputStream aOutputStream, boolean isFormattedOutput) {
        this(isFormattedOutput);
        this.setOutputStream(aOutputStream);
    }

    public XMLSerializer(Writer aWriter) {
        this();
        this.setWriter(aWriter);
    }

    public XMLSerializer(Writer aWriter, boolean isFormattedOutput) {
        this(isFormattedOutput);
        this.setWriter(aWriter);
    }

    public void setOutputStream(OutputStream aOutputStream) {
        this.mWriter = null;
        this.mOutputStream = aOutputStream;
        this.mHandler.setResult(this.createSaxResultObject());
    }

    public void setWriter(Writer aWriter) {
        this.mOutputStream = null;
        this.mWriter = aWriter;
        this.mHandler.setResult(this.createSaxResultObject());
    }

    public ContentHandler getContentHandler() {
        String xmlVer = this.mTransformer.getOutputProperty("version");
        boolean xml10 = xmlVer == null || "1.0".equals(xmlVer);
        return new CharacterValidatingContentHandler(!xml10, this.mHandler);
    }

    private Result createSaxResultObject() {
        if (this.mOutputStream != null) {
            return new StreamResult(this.mOutputStream);
        }
        if (this.mWriter != null) {
            return new StreamResult(this.mWriter);
        }
        return null;
    }

    public void serialize(Node node) {
        try {
            this.mTransformer.transform(new DOMSource(node), this.createSaxResultObject());
        }
        catch (TransformerException e) {
            throw new UIMARuntimeException(e);
        }
    }

    public void dom2sax(Node node, ContentHandler handler) {
        try {
            this.mTransformer.transform(new DOMSource(node), new SAXResult(handler));
        }
        catch (TransformerException e) {
            throw new UIMARuntimeException(e);
        }
    }

    public void setOutputProperty(String name, String value) {
        try {
            this.mTransformer.setOutputProperty(name, value);
        }
        catch (IllegalArgumentException e) {
            throw new UIMARuntimeException(e);
        }
        Result result = this.createSaxResultObject();
        if (result != null) {
            this.mHandler.setResult(result);
        }
    }

    public class CharacterValidatingContentHandler
    implements ContentHandler,
    LexicalHandler {
        ContentHandler mHandler;
        boolean mXml11;
        private int indent = 0;
        private int indentDelta = 0;
        private List<Node> mLastOutputNode = new ArrayList<Node>();
        public boolean prevWasEndElement = false;
        public boolean prevNL = false;

        public int getIndent() {
            return this.indent;
        }

        public int nextIndent() {
            this.indent += this.indentDelta;
            return this.indent;
        }

        public int prevIndent() {
            this.indent -= this.indentDelta;
            return this.indent;
        }

        public int getIndentDelta() {
            return this.indentDelta;
        }

        public void setIndentDelta(int indentDelta) {
            this.indentDelta = indentDelta;
        }

        public void lastOutputNodeAddLevel() {
            this.mLastOutputNode.add(null);
        }

        public void setLastOutputNode(Node n) {
            this.mLastOutputNode.set(this.mLastOutputNode.size() - 1, n);
        }

        public Node getLastOutputNode() {
            return this.mLastOutputNode.get(this.mLastOutputNode.size() - 1);
        }

        public Node getLastOutputNodePrevLevel() {
            int lastIndex = this.mLastOutputNode.size() - 1;
            if (lastIndex > 0) {
                return this.mLastOutputNode.get(lastIndex - 1);
            }
            return null;
        }

        public void lastOutputNodeClearLevel() {
            this.mLastOutputNode.remove(this.mLastOutputNode.size() - 1);
        }

        CharacterValidatingContentHandler(boolean xml11, ContentHandler serializerHandler) {
            this.mHandler = serializerHandler;
            this.mXml11 = xml11;
            String indentDeltaString = XMLSerializer.this.mTransformer.getOutputProperty("{http://xml.apache.org/xslt}indent-amount");
            if (null != indentDeltaString) {
                try {
                    this.indentDelta = Integer.parseInt(indentDeltaString);
                }
                catch (NumberFormatException e) {
                    this.indentDelta = 0;
                }
            }
            this.mLastOutputNode.add(null);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            for (int i = 0; i < atts.getLength(); ++i) {
                String val = atts.getValue(i);
                this.checkForInvalidXmlChars(val, this.mXml11);
            }
            this.mHandler.startElement(uri, localName, qName, atts);
            this.prevWasEndElement = false;
            this.prevNL = false;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.checkForInvalidXmlChars(ch, start, length, this.mXml11);
            this.mHandler.characters(ch, start, length);
            this.prevNL = false;
            for (int i = start; i < start + length; ++i) {
                if (ch[i] != '\n') continue;
                this.prevNL = true;
                break;
            }
        }

        @Override
        public void endDocument() throws SAXException {
            this.mHandler.endDocument();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.mHandler.endElement(uri, localName, qName);
            this.prevWasEndElement = true;
            this.prevNL = false;
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.mHandler.endPrefixMapping(prefix);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.mHandler.ignorableWhitespace(ch, start, length);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.mHandler.processingInstruction(target, data);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.mHandler.setDocumentLocator(locator);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            this.mHandler.skippedEntity(name);
        }

        @Override
        public void startDocument() throws SAXException {
            this.indent = 0;
            this.mHandler.startDocument();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.mHandler.startPrefixMapping(prefix, uri);
        }

        private final void checkForInvalidXmlChars(String s, boolean xml11) throws SAXParseException {
            int index = XMLUtils.checkForNonXmlCharacters(s, xml11);
            if (index >= 0) {
                String msg = String.format("Trying to serialize non-XML %s character: %c, 0x%x at offset %,d in string starting with %s", xml11 ? "1.1" : "1.0", Character.valueOf(s.charAt(index)), (int)s.charAt(index), index, s.substring(0, Math.min(100, s.length())));
                throw new SAXParseException(msg, null);
            }
        }

        private final void checkForInvalidXmlChars(char[] ch, int start, int length, boolean xml11) throws SAXParseException {
            int index = XMLUtils.checkForNonXmlCharacters(ch, start, length, xml11);
            if (index >= 0) {
                String msg = String.format("Trying to serialize non-XML %s character: %c, 0x%x at offset %,d in string starting with %s", xml11 ? "1.1" : "1.0", Character.valueOf(ch[index]), (int)ch[index], index, new String(ch).substring(0, Math.min(100, ch.length)));
                throw new SAXParseException(msg, null);
            }
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            ((LexicalHandler)((Object)this.mHandler)).comment(ch, start, length);
            this.prevNL = false;
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void endEntity(String arg0) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
        }

        @Override
        public void startEntity(String arg0) throws SAXException {
        }
    }
}

