/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiFunction;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;
import org.openqa.selenium.json.Types;

public class StaticInitializerCoercer
extends TypeCoercer<Object> {
    private static final Json JSON = new Json();
    private static final String FACTORY_METHOD_NAME = "fromJson";

    @Override
    public boolean test(Class<?> aClass) {
        Method fromJson = this.getStaticMethod(FACTORY_METHOD_NAME, aClass);
        if (fromJson == null) {
            return false;
        }
        return Arrays.equals(new Object[]{String.class}, fromJson.getParameterTypes());
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, Object> apply(Type type) {
        Class<?> aClass = Types.narrow(type);
        Method fromJson = Objects.requireNonNull(this.getStaticMethod(FACTORY_METHOD_NAME, aClass));
        return (jsonInput, setting) -> {
            Object obj = jsonInput.read((Type)((Object)Object.class));
            String json = JSON.toJson(obj);
            try {
                return fromJson.invoke(null, json);
            }
            catch (ReflectiveOperationException e) {
                throw new JsonException("Unable to create instance of " + type, e);
            }
        };
    }

    private Method getStaticMethod(String name, Class<?> aClass) {
        try {
            Method method = aClass.getMethod(name, String.class);
            if (!Modifier.isStatic(method.getModifiers())) {
                return null;
            }
            method.setAccessible(true);
            return method;
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }
}

