/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.tests;

import java.util.List;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public class SeleniumTester {
    protected WebDriver driver = null;
    protected WebDriverWait wait = null;
    private final long defaultTimeOutInSeconds = 15L;

    @Before
    public void setup() throws Exception {
        this.driver = null;
        this.wait = null;
    }

    public void start(BrowserType browserType, String language, String startURL) {
        switch (browserType) {
            case CHROME: {
                if (System.getProperty("webdriver.chrome.driver") == null || System.getProperty("webdriver.chrome.driver").length() == 0) {
                    throw new IllegalStateException("Please configure your SL_CHROME_DRIVER environment variable to point to the Selenium Google Chrome Driver");
                }
                ChromeOptions options = new ChromeOptions();
                options.addArguments(new String[]{"--start-maximized", "--lang=" + language});
                this.driver = new ChromeDriver(options);
                break;
            }
            case FIREFOX: {
                if (System.getProperty("webdriver.gecko.driver") == null || System.getProperty("webdriver.gecko.driver").length() == 0) {
                    throw new IllegalStateException("Please configure your SL_FIREFOX_DRIVER environment variable to point to the Mozilla Firefox Driver");
                }
                this.driver = new FirefoxDriver();
                break;
            }
            case IE: {
                if (System.getProperty("webdriver.ie.driver") == null || System.getProperty("webdriver.ie.driver").length() == 0) {
                    throw new IllegalStateException("Please configure your SL_IE_DRIVER environment variable to point to the Internet Explorer Driver");
                }
                this.driver = new InternetExplorerDriver();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown browser type");
            }
        }
        this.wait = new WebDriverWait(this.driver, 15L);
        this.driver.get(startURL);
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public WebDriverWait getWait() {
        return this.wait;
    }

    public WebElement findElementById(String id) {
        return this.driver.findElement(By.id((String)id));
    }

    public void verifyHeader(String expected) {
        WebElement element = (WebElement)this.wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.id((String)"heading")));
        Assert.assertThat((Object)element.getText(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)expected)));
    }

    public void verifyHeaderContains(String expected) {
        WebElement element = (WebElement)this.wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.id((String)"heading")));
        Assert.assertThat((Object)element.getText(), (Matcher)CoreMatchers.containsString((String)expected));
    }

    public void verifyThereIsNoError() {
        WebElement element = (WebElement)this.wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.id((String)"heading")));
        Assert.assertNotEquals((Object)"Error!", (Object)element.getText());
    }

    public void navigateTo(String lintAlt) {
        WebElement ele = this.driver.findElement(By.cssSelector((String)(".sidebar-menu .treeview-menu a[alt=\"" + lintAlt + "\"]")));
        String js = "return $(arguments[0]).closest('.treeview').get(0)";
        WebElement parent = (WebElement)((JavascriptExecutor)this.driver).executeScript(js, new Object[]{ele});
        if (!this.hasClass(parent, "active")) {
            js = "$(arguments[0]).closest('.treeview').find('a:first-child').click();";
            ((JavascriptExecutor)this.driver).executeScript(js, new Object[]{ele});
            try {
                Thread.sleep(2500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        ((WebElement)this.wait.until((Function)ExpectedConditions.elementToBeClickable((WebElement)ele))).click();
        this.waitForAjaxAndDocumentReady();
    }

    private boolean exists(By selector) {
        return this.driver.findElements(selector).size() != 0;
    }

    public WebElement waitFindElement(By selector) {
        return (WebElement)this.wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)selector));
    }

    public WebElement waitElementClickable(By selector) {
        return (WebElement)this.wait.until((Function)ExpectedConditions.elementToBeClickable((By)selector));
    }

    public WebElement waitUntilPresenceOfElementLocated(By selector) {
        return (WebElement)this.wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)selector));
    }

    public void waitForElementWithName(String name) {
        this.waitFor(By.name((String)name));
    }

    public void waitForPresenceById(String id) {
        this.waitForPresence(By.id((String)id));
    }

    public void waitForPresence(By selector) {
        this.wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)selector));
    }

    public void waitFor(By selector) {
        this.wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)selector));
    }

    public void clickTab(String tabName) {
        WebElement element = this.waitElementClickable(By.cssSelector((String)(".nav-tabs li > a[alt=\"" + tabName + " tab\"], .tab-group .btn-group > a[alt=\"" + tabName + " tab\"]")));
        element.click();
        this.waitForAjaxAndDocumentReady();
    }

    public void clickButtonByTitle(String title) {
        WebElement element = this.waitElementClickable(By.xpath((String)("//a[contains(@class,'btn') and contains(@data-original-title,'" + title + "')]")));
        element.click();
        if (!this.isAlertPresent()) {
            this.waitForAjaxAndDocumentReady();
        }
    }

    public void clickButton(String text) throws Exception {
        this.clickButton(text, 15L);
    }

    public void clickButton(String text, long timeOutInSeconds) throws Exception {
        boolean found = false;
        List elements = this.driver.findElements(By.xpath((String)"//a[contains(concat(' ',@class,' '), ' btn ')] | //button[contains(concat(' ',@class,' '), ' btn ')]"));
        for (int i = 0; i < elements.size(); ++i) {
            WebElement element = (WebElement)elements.get(i);
            System.out.println(this.getRenderedSource(element));
            this.wait.until((Function)ExpectedConditions.elementToBeClickable((WebElement)element));
            String actualText = element.getText();
            if (actualText != null && actualText.length() > 0) {
                actualText = actualText.trim();
            }
            if (!actualText.equals(text)) continue;
            element.click();
            found = true;
            break;
        }
        if (!found) {
            throw new Exception("Button not found with text - " + text);
        }
        if (!this.isAlertPresent()) {
            this.waitForAjaxAndDocumentReady(timeOutInSeconds);
        }
    }

    public void clickButton(String buttonText, boolean islegacy) throws Exception {
        if (!islegacy) {
            this.clickButton(buttonText);
        } else {
            this.waitFindElement(By.cssSelector((String)("[type=\"button\"][value=\"" + buttonText + "\"]"))).click();
        }
    }

    public void clickRadioButton(String name, String value) {
        this.waitElementClickable(By.xpath((String)("//input[@type='radio'][@name='" + name + "'][@value='" + value + "']"))).click();
    }

    public void clickCheckbox(String name) {
        this.waitElementClickable(By.xpath((String)("//input[@type='checkbox'][@name='" + name + "']"))).click();
    }

    public boolean isAlertPresent() {
        boolean foundAlert = false;
        WebDriverWait wait = new WebDriverWait(this.driver, 0L);
        try {
            wait.until((Function)ExpectedConditions.alertIsPresent());
            foundAlert = true;
        }
        catch (TimeoutException eTO) {
            foundAlert = false;
        }
        return foundAlert;
    }

    public void acceptAlert() {
        this.wait.until((Function)ExpectedConditions.alertIsPresent());
        Alert alert = this.driver.switchTo().alert();
        alert.accept();
    }

    public void setValue(String name, String value) {
        this.setValue((SearchContext)this.driver, name, value);
    }

    public void setValue(SearchContext context, String name, String value) {
        this.setValue(context, By.name((String)name), value);
    }

    public void setValue(SearchContext context, By selector, String value) {
        WebElement element = context.findElement(selector);
        element.clear();
        element.sendKeys(new CharSequence[]{value});
    }

    public void selectValue(String name, String value) {
        WebElement element = this.waitUntilPresenceOfElementLocated(By.name((String)name));
        System.out.println(element.toString());
        if (this.hasClass(element, "selectpicker")) {
            String js = "$(arguments[0]).selectpicker('val','" + value + "')";
            ((JavascriptExecutor)this.driver).executeScript(js, new Object[]{element});
        } else {
            Select select = new Select(element);
            select.selectByValue(value);
        }
    }

    public void executeJquery(WebElement element, String method, String params) {
        String js = "$(arguments[0])." + method + "(" + params + ")";
        System.out.println("JavaScript to be executed: " + js);
        ((JavascriptExecutor)this.driver).executeScript(js, new Object[]{element});
    }

    private boolean hasClass(WebElement element, String className) {
        if (element.getAttribute("class") != null) {
            return element.getAttribute("class").contains(className);
        }
        return false;
    }

    public String getAttributeValueById(String id, String attribute) {
        WebElement element = this.driver.findElement(By.id((String)id));
        return element.getAttribute(attribute);
    }

    public void performJobActionEN(String jobID, String action) {
        this.navigateTo("Manage jobs");
        this.waitForElementWithName("liststatuses");
        this.waitElementClickable(By.xpath((String)("//tr[@job-id=" + jobID + "]//a[contains(@class,'btn') and text()='" + action + "']"))).click();
    }

    public void waitForJobStatusEN(String jobID, String jobStatus, int timeoutAmount) throws Exception {
        this.waitForJobStatus(jobID, jobStatus, timeoutAmount, "Manage jobs", "liststatuses", "Refresh");
    }

    public void waitForJobStatus(String jobID, String jobStatus, int timeoutAmount, String manageJobsPage, String listStatusesElement, String refreshButton) throws Exception {
        this.navigateTo(manageJobsPage);
        this.waitForElementWithName(listStatusesElement);
        while (true) {
            if (!this.exists(By.xpath((String)("//tr[@job-id='" + jobID + "']")))) {
                throw new Exception("Job " + jobID + " not found");
            }
            if (this.exists(By.xpath((String)("//tr[@job-id='" + jobID + "' and @job-status-name='" + jobStatus + "']")))) break;
            if (timeoutAmount == 0) {
                throw new Exception("Timed out waiting for job " + jobID + " to acheive status '" + jobStatus + "'");
            }
            this.clickButton(refreshButton);
            this.waitForElementWithName(listStatusesElement);
            Thread.sleep(1000L);
            --timeoutAmount;
        }
    }

    public String getJobStatusEN(String jobID) throws Exception {
        return this.getJobStatus(jobID, "Manage jobs", "liststatuses");
    }

    public String getJobStatus(String jobID, String manageJobsPage, String listStatusesElement) throws Exception {
        this.navigateTo(manageJobsPage);
        this.waitForElementWithName(listStatusesElement);
        WebElement element = this.driver.findElement(By.xpath((String)("//tr[@job-id=" + jobID + "]")));
        if (element == null) {
            throw new Exception("Can't find job " + jobID);
        }
        return element.getAttribute("job-status-name");
    }

    public void waitForJobDeleteEN(String jobID, int timeoutAmount) throws Exception {
        this.waitForJobDelete(jobID, timeoutAmount, "Manage jobs", "liststatuses", "Refresh");
    }

    public void waitForJobDelete(String jobID, int timeoutAmount, String manageJobsPage, String listStatusesElement, String refreshButton) throws Exception {
        this.navigateTo(manageJobsPage);
        this.waitForElementWithName(listStatusesElement);
        while (this.exists(By.xpath((String)("//tr[@job-id=\"" + jobID + "\"]")))) {
            if (timeoutAmount == 0) {
                throw new Exception("Timed out waiting for job " + jobID + " to go away");
            }
            this.clickButton(refreshButton);
            this.waitForElementWithName(listStatusesElement);
            Thread.sleep(1000L);
            --timeoutAmount;
        }
    }

    public boolean waitForAjaxAndDocumentReady() {
        return this.waitForAjaxAndDocumentReady(15L);
    }

    public boolean waitForAjaxAndDocumentReady(long timeOutInSeconds) {
        WebDriverWait wait = new WebDriverWait(this.driver, timeOutInSeconds);
        ExpectedCondition<Boolean> jQueryLoad = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    return (Long)((JavascriptExecutor)SeleniumTester.this.getDriver()).executeScript("return jQuery.active", new Object[0]) == 0L;
                }
                catch (Exception e) {
                    return true;
                }
            }
        };
        ExpectedCondition<Boolean> jsLoad = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return ((JavascriptExecutor)SeleniumTester.this.getDriver()).executeScript("return document.readyState", new Object[0]).toString().equals("complete");
            }
        };
        return (Boolean)wait.until((Function)jQueryLoad) != false && (Boolean)wait.until((Function)jsLoad) != false;
    }

    public void waitUntilAnimationIsDone(String selector) {
        this.waitUntilAnimationIsDone(selector, 15L);
    }

    public void waitUntilAnimationIsDone(final String selector, long timeOutInSeconds) {
        WebDriverWait wait = new WebDriverWait(this.driver, timeOutInSeconds);
        ExpectedCondition<Boolean> expectation = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                String temp = ((JavascriptExecutor)driver).executeScript("return jQuery('" + selector + "').is(':animated')", new Object[0]).toString();
                return temp.equalsIgnoreCase("false");
            }
        };
        try {
            wait.until((Function)expectation);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)("Element animation is not finished in time. selector: " + selector));
        }
    }

    public String getRenderedSource() {
        return this.getRenderedSource(By.tagName((String)"html"));
    }

    public String getRenderedSource(By selector) {
        return this.getRenderedSource(this.driver.findElement(selector));
    }

    public String getRenderedSource(WebElement element) {
        return (String)((JavascriptExecutor)this.driver).executeScript("return arguments[0].innerHTML", new Object[]{element});
    }

    private long tick() {
        long TICKS_AT_EPOCH = 621355968000000000L;
        return System.currentTimeMillis() * 10000L + TICKS_AT_EPOCH;
    }

    @After
    public void teardown() throws Exception {
        if (this.driver != null) {
            this.driver.close();
            this.driver.quit();
            this.driver = null;
            this.wait = null;
        }
    }

    public static enum BrowserType {
        CHROME,
        FIREFOX,
        IE;

    }
}

