/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.measure.UnitConverter;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.Fraction;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.ConcatenatedConverter;
import org.apache.sis.measure.IdentityConverter;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.StringBuilders;

final class LinearConverter
extends AbstractConverter
implements LenientComparable {
    private static final long serialVersionUID = -3759983642723729926L;
    private final double scale;
    private final double offset;
    private final double divisor;
    private volatile transient BigDecimal scale10;
    private volatile transient BigDecimal offset10;
    private volatile transient LinearConverter inverse;

    LinearConverter(double d, double d2, double d3) {
        this.scale = d;
        this.offset = d2;
        this.divisor = d3;
    }

    static AbstractConverter create(Number number, Number number2) {
        double d;
        double d2;
        double d3;
        double d4 = d3 = number2 != null ? LinearConverter.doubleValue(number2) : 0.0;
        if (number instanceof Fraction) {
            d2 = ((Fraction)number).numerator;
            d = ((Fraction)number).denominator;
            d3 *= d;
        } else {
            d2 = number != null ? LinearConverter.doubleValue(number) : 1.0;
            d = 1.0;
        }
        if (d3 == 0.0 && d2 == d) {
            return IdentityConverter.INSTANCE;
        }
        LinearConverter linearConverter = new LinearConverter(d2, d3, d);
        if (number instanceof BigDecimal) {
            linearConverter.scale10 = (BigDecimal)number;
        }
        if (number2 instanceof BigDecimal) {
            linearConverter.offset10 = (BigDecimal)number2;
        }
        return linearConverter;
    }

    static LinearConverter scale(double d, double d2) {
        return new LinearConverter(d, 0.0, d2);
    }

    static LinearConverter offset(double d, double d2) {
        return new LinearConverter(d2, d, d2);
    }

    static LinearConverter pow(UnitConverter unitConverter, int n, boolean bl) {
        double d;
        double d2;
        if (unitConverter instanceof LinearConverter) {
            LinearConverter linearConverter = (LinearConverter)unitConverter;
            d2 = linearConverter.scale;
            d = linearConverter.divisor;
        } else {
            d2 = unitConverter.convert(1.0) - unitConverter.convert(0.0);
            d = 1.0;
        }
        if (bl) {
            switch (n) {
                case 1: {
                    break;
                }
                case 2: {
                    d2 = Math.sqrt(d2);
                    d = Math.sqrt(d);
                    break;
                }
                case 3: {
                    d2 = Math.cbrt(d2);
                    d = Math.cbrt(d);
                    break;
                }
                default: {
                    double d3 = 1.0 / (double)n;
                    d2 = Math.pow(d2, d3);
                    d = Math.pow(d, d3);
                    break;
                }
            }
        } else {
            d2 = d2 == 10.0 ? MathFunctions.pow10(n) : Math.pow(d2, n);
            d = d == 10.0 ? MathFunctions.pow10(n) : Math.pow(d, n);
        }
        return LinearConverter.scale(d2, d);
    }

    @Override
    public boolean isLinear() {
        return this.offset == 0.0;
    }

    @Override
    public boolean isIdentity() {
        return this.scale == this.divisor && this.offset == 0.0;
    }

    final boolean almostIdentity() {
        return LinearConverter.epsilonEquals(this.scale, this.divisor) && LinearConverter.epsilonEquals(this.offset, 0.0);
    }

    @Override
    public synchronized UnitConverter inverse() {
        if (this.inverse == null) {
            this.inverse = this.isIdentity() ? this : new LinearConverter(this.divisor, -this.offset, this.scale);
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    @Override
    final Number[] coefficients() {
        Number[] numberArray = new Number[this.scale != this.divisor ? 2 : (this.offset != 0.0 ? 1 : 0)];
        switch (numberArray.length) {
            case 2: {
                numberArray[1] = LinearConverter.ratio(this.scale, this.divisor);
            }
            case 1: {
                numberArray[0] = LinearConverter.ratio(this.offset, this.divisor);
            }
        }
        return numberArray;
    }

    private static Number ratio(double d, double d2) {
        int n;
        int n2 = (int)d;
        if ((double)n2 == d && (double)(n = (int)d2) == d2) {
            return n == 1 ? Integer.valueOf(n2) : new Fraction(n2, n);
        }
        return d / d2;
    }

    @Override
    public double convert(double d) {
        return (d * this.scale + this.offset) / this.divisor;
    }

    @Override
    public Number convert(Number number) {
        ArgumentChecks.ensureNonNull("value", number);
        if (!this.isIdentity()) {
            if (number instanceof BigInteger) {
                number = new BigDecimal((BigInteger)number);
            }
            if (number instanceof BigDecimal) {
                BigDecimal bigDecimal = this.scale10;
                BigDecimal bigDecimal2 = this.offset10;
                if (bigDecimal == null || bigDecimal2 == null) {
                    BigDecimal bigDecimal3 = BigDecimal.valueOf(this.divisor);
                    bigDecimal = BigDecimal.valueOf(this.scale).divide(bigDecimal3);
                    bigDecimal2 = BigDecimal.valueOf(this.offset).divide(bigDecimal3);
                    this.scale10 = bigDecimal;
                    this.offset10 = bigDecimal2;
                }
                number = ((BigDecimal)number).multiply(bigDecimal).add(bigDecimal2);
            } else {
                number = this.convert(LinearConverter.doubleValue(number));
            }
        }
        return number;
    }

    @Override
    public double derivative(double d) {
        return this.scale / this.divisor;
    }

    @Override
    public UnitConverter concatenate(UnitConverter unitConverter) {
        double d;
        double d2;
        double d3;
        ArgumentChecks.ensureNonNull("converter", unitConverter);
        if (unitConverter.isIdentity()) {
            return this;
        }
        if (this.isIdentity()) {
            return unitConverter;
        }
        if (unitConverter instanceof LinearConverter) {
            LinearConverter linearConverter = (LinearConverter)unitConverter;
            d3 = linearConverter.scale;
            d2 = linearConverter.offset;
            d = linearConverter.divisor;
        } else if (unitConverter.isLinear()) {
            d2 = unitConverter.convert(0.0);
            d3 = unitConverter.convert(1.0) - d2;
            d = 1.0;
        } else {
            return new ConcatenatedConverter(unitConverter, this);
        }
        d2 = d2 * this.scale + d * this.offset;
        if ((d3 *= this.scale) != 0.0 || d2 != 0.0 || (d *= this.divisor) != 0.0) {
            double d4;
            double d5 = 1.0;
            do {
                d4 = d5;
            } while (d3 % (d5 *= 10.0) == 0.0 && d2 % d5 == 0.0 && d % d5 == 0.0);
            d3 /= d4;
            d2 /= d4;
            d /= d4;
        }
        if (d2 == 0.0 && d3 == d) {
            return IdentityConverter.INSTANCE;
        }
        return new LinearConverter(d3, d2, d);
    }

    public int hashCode() {
        return Long.hashCode(Double.doubleToLongBits(this.scale) + 31L * (Double.doubleToLongBits(this.offset) + 37L * Double.doubleToLongBits(this.divisor)));
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof LinearConverter) {
            LinearConverter linearConverter = (LinearConverter)object;
            return Numerics.equals(this.scale, linearConverter.scale) && Numerics.equals(this.offset, linearConverter.offset) && Numerics.equals(this.divisor, linearConverter.divisor);
        }
        if (object instanceof IdentityConverter) {
            return this.isIdentity();
        }
        return false;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (comparisonMode.isApproximate()) {
            if (object instanceof LinearConverter) {
                return this.equivalent((LinearConverter)object);
            }
            if (object instanceof IdentityConverter) {
                return this.almostIdentity();
            }
            return false;
        }
        return this.equals(object);
    }

    final boolean equivalent(LinearConverter linearConverter) {
        return LinearConverter.epsilonEquals(this.scale * linearConverter.divisor, linearConverter.scale * this.divisor) && LinearConverter.epsilonEquals(this.offset * linearConverter.divisor, linearConverter.offset * this.divisor);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("y\u00a0=\u00a0");
        if (this.offset != 0.0) {
            stringBuilder.append('(');
        }
        if (this.scale != 1.0) {
            StringBuilders.trimFractionalPart(stringBuilder.append(this.scale));
            stringBuilder.append('\u22c5');
        }
        stringBuilder.append('x');
        if (this.offset != 0.0) {
            StringBuilders.trimFractionalPart(stringBuilder.append("\u00a0+\u00a0").append(this.offset));
            stringBuilder.append(')');
        }
        if (this.divisor != 1.0) {
            StringBuilders.trimFractionalPart(stringBuilder.append('\u2215').append(this.divisor));
        }
        return stringBuilder.toString();
    }
}

