/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import org.apache.manifoldcf.scriptengine.NewOperation;
import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.ScriptParser;
import org.apache.manifoldcf.scriptengine.Token;
import org.apache.manifoldcf.scriptengine.TokenStream;
import org.apache.manifoldcf.scriptengine.VariableQueryArg;
import org.apache.manifoldcf.scriptengine.VariableReference;

public class NewQueryArgument
implements NewOperation {
    @Override
    public VariableReference parseAndCreate(ScriptParser sp, TokenStream currentStream) throws ScriptException {
        VariableReference name = sp.evaluateExpression(currentStream);
        if (name == null) {
            ScriptParser.syntaxError(currentStream, "Need name expression");
        }
        String nameString = ScriptParser.resolveMustExist(currentStream, name).getStringValue();
        String valueString = null;
        Token equal = currentStream.peek();
        if (equal != null && equal.getPunctuation() != null && equal.getPunctuation().equals("=")) {
            currentStream.skip();
            VariableReference value = sp.evaluateExpression(currentStream);
            if (value == null) {
                ScriptParser.syntaxError(currentStream, "Need value expression");
            }
            valueString = ScriptParser.resolveMustExist(currentStream, value).getStringValue();
        }
        return new VariableQueryArg(nameString, valueString);
    }

    @Override
    public void parseAndSkip(ScriptParser sp, TokenStream currentStream) throws ScriptException {
        sp.skipExpression(currentStream);
        Token equal = currentStream.peek();
        if (equal != null && equal.getPunctuation() != null && equal.getPunctuation().equals("=")) {
            currentStream.skip();
            sp.skipExpression(currentStream);
        }
    }
}

