/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.connectorcommon.fuzzyml;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.manifoldcf.connectorcommon.fuzzyml.BOMEncodingDetector;
import org.apache.manifoldcf.connectorcommon.fuzzyml.ByteReceiver;
import org.apache.manifoldcf.connectorcommon.fuzzyml.CharacterReceiver;
import org.apache.manifoldcf.connectorcommon.fuzzyml.DecodingByteReceiver;
import org.apache.manifoldcf.connectorcommon.fuzzyml.ReplayableInputStream;
import org.apache.manifoldcf.connectorcommon.fuzzyml.XMLEncodingDetector;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class Parser {
    public void parseWithCharsetDetection(String startingCharset, InputStream inputStream, CharacterReceiver characterReceiver) throws IOException, ManifoldCFException {
        ReplayableInputStream replayableInputStream = new ReplayableInputStream(inputStream);
        BOMEncodingDetector bomEncodingDetector = new BOMEncodingDetector(null);
        bomEncodingDetector.setEncoding(startingCharset);
        if (!bomEncodingDetector.dealWithBytes(replayableInputStream)) {
            bomEncodingDetector.finishUp();
        }
        if ((startingCharset = bomEncodingDetector.getEncoding()) == null) {
            startingCharset = StandardCharsets.UTF_8.name();
        }
        replayableInputStream.restart(false);
        XMLEncodingDetector xmlEncodingDetector = new XMLEncodingDetector();
        xmlEncodingDetector.setEncoding(startingCharset);
        bomEncodingDetector = new BOMEncodingDetector(new DecodingByteReceiver(1024, startingCharset, xmlEncodingDetector));
        if (!bomEncodingDetector.dealWithBytes(replayableInputStream)) {
            bomEncodingDetector.finishUp();
        }
        startingCharset = xmlEncodingDetector.getEncoding();
        replayableInputStream.restart(true);
        bomEncodingDetector = new BOMEncodingDetector(new DecodingByteReceiver(65536, startingCharset, characterReceiver));
        if (!bomEncodingDetector.dealWithBytes(replayableInputStream)) {
            bomEncodingDetector.finishUp();
        }
    }

    public void parseWithoutCharsetDetection(String startingCharset, InputStream inputStream, CharacterReceiver characterReceiver) throws IOException, ManifoldCFException {
        DecodingByteReceiver byteReceiver;
        if (startingCharset == null) {
            startingCharset = StandardCharsets.UTF_8.name();
        }
        if (!((ByteReceiver)(byteReceiver = new DecodingByteReceiver(65536, startingCharset, characterReceiver))).dealWithBytes(inputStream)) {
            ((ByteReceiver)byteReceiver).finishUp();
        }
    }
}

