/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import org.apache.hive.service.rpc.thrift.TTableSchema;
import org.apache.hive.service.rpc.thrift.TTypeId;
import org.apache.kyuubi.jdbc.hive.JdbcColumnAttributes;
import org.apache.kyuubi.jdbc.hive.KyuubiResultSetMetaData;
import org.apache.kyuubi.jdbc.hive.KyuubiSQLException;
import org.apache.kyuubi.jdbc.hive.adapter.SQLResultSet;
import org.apache.kyuubi.jdbc.hive.common.HiveIntervalDayTime;
import org.apache.kyuubi.jdbc.hive.common.HiveIntervalYearMonth;
import org.apache.kyuubi.jdbc.hive.common.TimestampTZUtil;

public abstract class KyuubiBaseResultSet
implements SQLResultSet {
    protected Statement statement = null;
    protected SQLWarning warningChain = null;
    protected boolean wasNull = false;
    protected Object[] row;
    protected List<String> columnNames;
    protected List<String> normalizedColumnNames;
    protected List<TTypeId> columnTypes;
    protected List<JdbcColumnAttributes> columnAttributes;
    private TTableSchema schema;

    @Override
    public int findColumn(String columnName) throws SQLException {
        int columnIndex = 0;
        boolean findColumn = false;
        for (String normalizedColumnName : this.normalizedColumnNames) {
            ++columnIndex;
            String[] names = normalizedColumnName.split("\\.");
            String name = names[names.length - 1];
            if (!name.equalsIgnoreCase(columnName) && !normalizedColumnName.equalsIgnoreCase(columnName)) continue;
            findColumn = true;
            break;
        }
        if (!findColumn) {
            throw new KyuubiSQLException("Could not find " + columnName + " in " + this.normalizedColumnNames);
        }
        return columnIndex;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object val = this.getObject(columnIndex);
        if (val == null || val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        throw new KyuubiSQLException("Illegal conversion");
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        MathContext mc = new MathContext(scale);
        return this.getBigDecimal(columnIndex).round(mc);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof InputStream) {
            return (InputStream)obj;
        }
        if (obj instanceof byte[]) {
            byte[] byteArray = (byte[])obj;
            return new ByteArrayInputStream(byteArray);
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
        }
        throw new KyuubiSQLException("Illegal conversion to binary stream from column " + columnIndex);
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue() != 0;
        }
        if (obj instanceof String) {
            return !obj.equals("0");
        }
        throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to boolean");
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj instanceof Number) {
            return ((Number)obj).byteValue();
        }
        if (obj == null) {
            return 0;
        }
        throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to byte");
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        try {
            if (obj instanceof String) {
                return Date.valueOf((String)obj);
            }
        }
        catch (Exception e) {
            throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to date: " + e, e);
        }
        throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to date: Illegal conversion");
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            if (obj == null) {
                return 0.0;
            }
            if (obj instanceof String) {
                return Double.parseDouble((String)obj);
            }
            throw new Exception("Illegal conversion");
        }
        catch (Exception e) {
            throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to double: " + e, e);
        }
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj instanceof Number) {
                return ((Number)obj).floatValue();
            }
            if (obj == null) {
                return 0.0f;
            }
            if (obj instanceof String) {
                return Float.parseFloat((String)obj);
            }
            throw new Exception("Illegal conversion");
        }
        catch (Exception e) {
            throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to float: " + e, e);
        }
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            if (obj == null) {
                return 0;
            }
            if (obj instanceof String) {
                return Integer.parseInt((String)obj);
            }
            throw new Exception("Illegal conversion");
        }
        catch (Exception e) {
            throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to integer" + e, e);
        }
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            if (obj == null) {
                return 0L;
            }
            if (obj instanceof String) {
                return Long.parseLong((String)obj);
            }
            throw new Exception("Illegal conversion");
        }
        catch (Exception e) {
            throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to long: " + e, e);
        }
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new KyuubiResultSetMetaData(this.columnNames, this.columnTypes, this.columnAttributes);
    }

    private Object getColumnValue(int columnIndex) throws SQLException {
        if (this.row == null) {
            throw new KyuubiSQLException("No row found.");
        }
        if (this.row.length == 0) {
            throw new KyuubiSQLException("RowSet does not contain any columns!");
        }
        if (columnIndex > this.row.length) {
            throw new KyuubiSQLException("Invalid columnIndex: " + columnIndex);
        }
        TTypeId columnType = this.columnTypes.get(columnIndex - 1);
        try {
            Object evaluated = this.evaluate(columnType, this.row[columnIndex - 1]);
            this.wasNull = evaluated == null;
            return evaluated;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KyuubiSQLException("Unrecognized column type:" + columnType, e);
        }
    }

    private Object evaluate(TTypeId columnType, Object value) {
        if (value == null) {
            return null;
        }
        switch (columnType) {
            case BINARY_TYPE: {
                if (value instanceof String) {
                    return ((String)value).getBytes();
                }
                return value;
            }
            case TIMESTAMP_TYPE: {
                return Timestamp.valueOf((String)value);
            }
            case TIMESTAMPLOCALTZ_TYPE: {
                return TimestampTZUtil.parse((String)value);
            }
            case DECIMAL_TYPE: {
                return new BigDecimal((String)value);
            }
            case DATE_TYPE: {
                return Date.valueOf((String)value);
            }
            case INTERVAL_YEAR_MONTH_TYPE: {
                return HiveIntervalYearMonth.valueOf((String)value);
            }
            case INTERVAL_DAY_TIME_TYPE: {
                return HiveIntervalDayTime.valueOf((String)value);
            }
            case ARRAY_TYPE: 
            case MAP_TYPE: 
            case STRUCT_TYPE: {
                return value;
            }
        }
        return value;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getColumnValue(columnIndex);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        try {
            Object obj = this.getObject(columnIndex);
            if (obj instanceof Number) {
                return ((Number)obj).shortValue();
            }
            if (obj == null) {
                return 0;
            }
            if (obj instanceof String) {
                return Short.parseShort((String)obj);
            }
            throw new Exception("Illegal conversion");
        }
        catch (Exception e) {
            throw new KyuubiSQLException("Cannot convert column " + columnIndex + " to short: " + e, e);
        }
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object value = this.getColumnValue(columnIndex);
        if (this.wasNull) {
            return null;
        }
        if (value instanceof byte[]) {
            return new String((byte[])value);
        }
        return value.toString();
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        if (obj instanceof String) {
            return Timestamp.valueOf((String)obj);
        }
        throw new KyuubiSQLException("Illegal conversion");
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    protected void setSchema(TTableSchema schema) {
        this.schema = schema;
    }

    protected TTableSchema getSchema() {
        return this.schema;
    }
}

