/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.trino.api;

import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.service.BackendService;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.sql.parser.trino.KyuubiTrinoFeParser;
import org.apache.kyuubi.sql.plan.KyuubiTreeNode;
import org.apache.kyuubi.sql.plan.PassThroughNode;
import org.apache.kyuubi.sql.plan.trino.GetCatalogs;
import org.apache.kyuubi.sql.plan.trino.GetColumns;
import org.apache.kyuubi.sql.plan.trino.GetPrimaryKeys;
import org.apache.kyuubi.sql.plan.trino.GetSchemas;
import org.apache.kyuubi.sql.plan.trino.GetTableTypes;
import org.apache.kyuubi.sql.plan.trino.GetTables;
import org.apache.kyuubi.sql.plan.trino.GetTypeInfo;
import scala.MatchError;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0002\u0004\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003\"\u0001\u0011\u0005!\u0005\u0003\u0005'\u0001!\u0015\r\u0011\"\u0001(\u0011\u0015\u0001\u0004\u0001\"\u00012\u0005yY\u00150^;cSR\u0013\u0018N\\8Pa\u0016\u0014\u0018\r^5p]R\u0013\u0018M\\:mCR|'O\u0003\u0002\b\u0011\u0005\u0019\u0011\r]5\u000b\u0005%Q\u0011!\u0002;sS:|'BA\u0006\r\u0003\u0019\u0019XM\u001d<fe*\u0011QBD\u0001\u0007Wf,XOY5\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VMZ\u0001\u000fE\u0006\u001c7.\u001a8e'\u0016\u0014h/[2f!\tar$D\u0001\u001e\u0015\tqB\"A\u0004tKJ4\u0018nY3\n\u0005\u0001j\"A\u0004\"bG.,g\u000eZ*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\r*\u0003C\u0001\u0013\u0001\u001b\u00051\u0001\"\u0002\u000e\u0003\u0001\u0004Y\u0012A\u00029beN,'/F\u0001)!\tIc&D\u0001+\u0015\tI1F\u0003\u0002'Y)\u0011Q\u0006D\u0001\u0004gFd\u0017BA\u0018+\u0005MY\u00150^;cSR\u0013\u0018N\\8GKB\u000b'o]3s\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u00043q\u0015k%k\u0016\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k1\t\u0011b\u001c9fe\u0006$\u0018n\u001c8\n\u0005]\"$aD(qKJ\fG/[8o\u0011\u0006tG\r\\3\t\u000be\"\u0001\u0019\u0001\u001e\u0002\u0013M$\u0018\r^3nK:$\bCA\u001eC\u001d\ta\u0004\t\u0005\u0002>-5\taH\u0003\u0002@%\u00051AH]8pizJ!!\u0011\f\u0002\rA\u0013X\rZ3g\u0013\t\u0019EI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0003ZAQA\u0012\u0003A\u0002\u001d\u000bQb]3tg&|g\u000eS1oI2,\u0007C\u0001%L\u001b\u0005I%B\u0001&\r\u0003\u001d\u0019Xm]:j_:L!\u0001T%\u0003\u001bM+7o]5p]\"\u000bg\u000e\u001a7f\u0011\u0015qE\u00011\u0001P\u0003\u001d\u0019wN\u001c4jON\u0004Ba\u000f);u%\u0011\u0011\u000b\u0012\u0002\u0004\u001b\u0006\u0004\b\"B*\u0005\u0001\u0004!\u0016\u0001\u0003:v]\u0006\u001b\u0018P\\2\u0011\u0005U)\u0016B\u0001,\u0017\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u0017\u0003A\u0002e\u000bA\"];fef$\u0016.\\3pkR\u0004\"!\u0006.\n\u0005m3\"\u0001\u0002'p]\u001e\u0004")
public class KyuubiTrinoOperationTranslator {
    private KyuubiTrinoFeParser parser;
    private final BackendService backendService;
    private volatile boolean bitmap$0;

    private KyuubiTrinoFeParser parser$lzycompute() {
        KyuubiTrinoOperationTranslator kyuubiTrinoOperationTranslator = this;
        synchronized (kyuubiTrinoOperationTranslator) {
            if (!this.bitmap$0) {
                this.parser = new KyuubiTrinoFeParser();
                this.bitmap$0 = true;
            }
        }
        return this.parser;
    }

    public KyuubiTrinoFeParser parser() {
        if (!this.bitmap$0) {
            return this.parser$lzycompute();
        }
        return this.parser;
    }

    public OperationHandle transform(String statement, SessionHandle sessionHandle, Map<String, String> configs, boolean runAsync, long queryTimeout) {
        KyuubiTreeNode kyuubiTreeNode = this.parser().parsePlan(statement);
        if (kyuubiTreeNode instanceof GetSchemas) {
            GetSchemas getSchemas = (GetSchemas)kyuubiTreeNode;
            String catalogName = getSchemas.catalogName();
            String schemaPattern = getSchemas.schemaPattern();
            return this.backendService.getSchemas(sessionHandle, catalogName, schemaPattern);
        }
        if (kyuubiTreeNode instanceof GetCatalogs) {
            return this.backendService.getCatalogs(sessionHandle);
        }
        if (kyuubiTreeNode instanceof GetTableTypes) {
            return this.backendService.getTableTypes(sessionHandle);
        }
        if (kyuubiTreeNode instanceof GetTypeInfo) {
            return this.backendService.getTypeInfo(sessionHandle);
        }
        if (kyuubiTreeNode instanceof GetTables) {
            GetTables getTables = (GetTables)kyuubiTreeNode;
            String catalogName = getTables.catalogName();
            String schemaPattern = getTables.schemaPattern();
            String tableNamePattern = getTables.tableNamePattern();
            List<String> tableTypes = getTables.tableTypes();
            boolean emptyResult = getTables.emptyResult();
            OperationHandle operationHandle = this.backendService.getTables(sessionHandle, catalogName, schemaPattern, tableNamePattern, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(tableTypes).asJava());
            operationHandle.setHasResultSet(!emptyResult);
            return operationHandle;
        }
        if (kyuubiTreeNode instanceof GetColumns) {
            GetColumns getColumns = (GetColumns)kyuubiTreeNode;
            String catalogName = getColumns.catalogName();
            String schemaPattern = getColumns.schemaPattern();
            String tableNamePattern = getColumns.tableNamePattern();
            String colNamePattern = getColumns.colNamePattern();
            return this.backendService.getColumns(sessionHandle, catalogName, schemaPattern, tableNamePattern, colNamePattern);
        }
        if (kyuubiTreeNode instanceof GetPrimaryKeys) {
            OperationHandle operationHandle = this.backendService.getPrimaryKeys(sessionHandle, null, null, null);
            operationHandle.setHasResultSet(false);
            return operationHandle;
        }
        if (kyuubiTreeNode instanceof PassThroughNode) {
            return this.backendService.executeStatement(sessionHandle, statement, configs, runAsync, queryTimeout);
        }
        throw new MatchError((Object)kyuubiTreeNode);
    }

    public KyuubiTrinoOperationTranslator(BackendService backendService) {
        this.backendService = backendService;
    }
}

